/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.basicdataset.cv.classification;

import ai.djl.Application;
import ai.djl.basicdataset.BasicDatasets;
import ai.djl.engine.Engine;
import ai.djl.modality.cv.transform.ToTensor;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDManager;
import ai.djl.ndarray.types.DataType;
import ai.djl.ndarray.types.Shape;
import ai.djl.repository.Artifact;
import ai.djl.repository.MRL;
import ai.djl.repository.Repository;
import ai.djl.training.dataset.ArrayDataset;
import ai.djl.training.dataset.Dataset;
import ai.djl.training.dataset.RandomAccessDataset;
import ai.djl.translate.Pipeline;
import ai.djl.translate.Transform;
import ai.djl.util.Progress;
import ai.djl.util.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

public final class Cifar10
extends ArrayDataset {
    private static final String ARTIFACT_ID = "cifar10";
    private static final String VERSION = "1.0";
    public static final int IMAGE_WIDTH = 32;
    public static final int IMAGE_HEIGHT = 32;
    public static final float[] NORMALIZE_MEAN = new float[]{0.4914f, 0.4822f, 0.4465f};
    public static final float[] NORMALIZE_STD = new float[]{0.2023f, 0.1994f, 0.201f};
    private static final int DATA_AND_LABEL_SIZE = 3073;
    private NDManager manager;
    private Dataset.Usage usage;
    private MRL mrl;
    private boolean prepared;

    Cifar10(Builder builder) {
        super((RandomAccessDataset.BaseBuilder)builder);
        this.manager = builder.manager;
        this.manager.setName(ARTIFACT_ID);
        this.usage = builder.usage;
        this.mrl = builder.getMrl();
    }

    public static Builder builder() {
        return new Builder();
    }

    public void prepare(Progress progress) throws IOException {
        Artifact.Item item;
        if (this.prepared) {
            return;
        }
        Artifact artifact = this.mrl.getDefaultArtifact();
        this.mrl.prepare(artifact, progress);
        Map map = artifact.getFiles();
        switch (this.usage) {
            case TRAIN: {
                item = (Artifact.Item)map.get("data_batch.bin");
                break;
            }
            case TEST: {
                item = (Artifact.Item)map.get("test_batch.bin");
                break;
            }
            default: {
                throw new UnsupportedOperationException("Validation data not available.");
            }
        }
        NDArray dataAndLabels = this.readData(item);
        this.data = new NDArray[]{dataAndLabels.get(":, 1:", new Object[0]).reshape(new long[]{-1L, 3L, 32L, 32L}).transpose(new int[]{0, 2, 3, 1})};
        this.labels = new NDArray[]{dataAndLabels.get(":,0", new Object[0])};
        if (this.data[0].size(0) != this.labels[0].size(0)) {
            throw new IOException("the size of data " + this.data[0].size(0) + " didn't match with the size of labels " + this.labels[0].size(0));
        }
        this.prepared = true;
    }

    private NDArray readData(Artifact.Item item) throws IOException {
        try (InputStream is = this.mrl.getRepository().openStream(item, null);){
            NDArray nDArray;
            block12: {
                byte[] buf = Utils.toByteArray((InputStream)is);
                int length = buf.length / 3073;
                NDArray array = this.manager.create(new Shape(new long[]{length, 3073L}), DataType.UINT8);
                try {
                    array.set(buf);
                    nDArray = array.toType(DataType.FLOAT32, false);
                    if (array == null) break block12;
                }
                catch (Throwable throwable) {
                    if (array != null) {
                        try {
                            array.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                array.close();
            }
            return nDArray;
        }
    }

    public static final class Builder
    extends RandomAccessDataset.BaseBuilder<Builder> {
        NDManager manager;
        Repository repository = BasicDatasets.REPOSITORY;
        String groupId = "ai.djl.basicdataset";
        String artifactId = "cifar10";
        Dataset.Usage usage = Dataset.Usage.TRAIN;

        Builder() {
            this.pipeline = new Pipeline(new Transform[]{new ToTensor()});
            this.manager = Engine.getInstance().newBaseManager();
        }

        protected Builder self() {
            return this;
        }

        public Builder optManager(NDManager manager) {
            this.manager.close();
            this.manager = manager.newSubManager();
            return this;
        }

        public Builder optRepository(Repository repository) {
            this.repository = repository;
            return this;
        }

        public Builder optGroupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public Builder optArtifactId(String artifactId) {
            if (artifactId.contains(":")) {
                String[] tokens = artifactId.split(":");
                this.groupId = tokens[0];
                this.artifactId = tokens[1];
            } else {
                this.artifactId = artifactId;
            }
            return this;
        }

        public Builder optUsage(Dataset.Usage usage) {
            this.usage = usage;
            return this;
        }

        public Cifar10 build() {
            return new Cifar10(this);
        }

        MRL getMrl() {
            return this.repository.dataset(Application.CV.ANY, this.groupId, this.artifactId, Cifar10.VERSION);
        }
    }
}

