/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v24.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v24.datatype.CE;
import ca.uhn.hl7v2.model.v24.datatype.HD;
import ca.uhn.hl7v2.model.v24.datatype.ID;
import ca.uhn.hl7v2.model.v24.datatype.MSG;
import ca.uhn.hl7v2.model.v24.datatype.NM;
import ca.uhn.hl7v2.model.v24.datatype.PT;
import ca.uhn.hl7v2.model.v24.datatype.ST;
import ca.uhn.hl7v2.model.v24.datatype.TS;
import ca.uhn.hl7v2.model.v24.datatype.VID;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class MSH
extends AbstractSegment {
    public MSH(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ST.class, true, 1, 1, new Object[]{this.getMessage()}, "Field Separator");
            this.add(ST.class, true, 1, 4, new Object[]{this.getMessage()}, "Encoding Characters");
            this.add(HD.class, false, 1, 180, new Object[]{this.getMessage()}, "Sending Application");
            this.add(HD.class, false, 1, 180, new Object[]{this.getMessage()}, "Sending Facility");
            this.add(HD.class, false, 1, 180, new Object[]{this.getMessage()}, "Receiving Application");
            this.add(HD.class, false, 1, 180, new Object[]{this.getMessage()}, "Receiving Facility");
            this.add(TS.class, true, 1, 26, new Object[]{this.getMessage()}, "Date/Time Of Message");
            this.add(ST.class, false, 1, 40, new Object[]{this.getMessage()}, "Security");
            this.add(MSG.class, true, 1, 15, new Object[]{this.getMessage()}, "Message Type");
            this.add(ST.class, true, 1, 20, new Object[]{this.getMessage()}, "Message Control ID");
            this.add(PT.class, true, 1, 3, new Object[]{this.getMessage()}, "Processing ID");
            this.add(VID.class, true, 1, 60, new Object[]{this.getMessage()}, "Version ID");
            this.add(NM.class, false, 1, 15, new Object[]{this.getMessage()}, "Sequence Number");
            this.add(ST.class, false, 1, 180, new Object[]{this.getMessage()}, "Continuation Pointer");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(155)}, "Accept Acknowledgment Type");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(155)}, "Application Acknowledgment Type");
            this.add(ID.class, false, 1, 3, new Object[]{this.getMessage(), new Integer(399)}, "Country Code");
            this.add(ID.class, false, 0, 16, new Object[]{this.getMessage(), new Integer(211)}, "Character Set");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Principal Language Of Message");
            this.add(ID.class, false, 1, 20, new Object[]{this.getMessage(), new Integer(356)}, "Alternate Character Set Handling Scheme");
            this.add(ID.class, false, 0, 10, new Object[]{this.getMessage(), new Integer(449)}, "Conformance Statement ID");
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating MSH - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public ST getFieldSeparator() {
        ST retVal = (ST)this.getTypedField(1, 0);
        return retVal;
    }

    public ST getMsh1_FieldSeparator() {
        ST retVal = (ST)this.getTypedField(1, 0);
        return retVal;
    }

    public ST getEncodingCharacters() {
        ST retVal = (ST)this.getTypedField(2, 0);
        return retVal;
    }

    public ST getMsh2_EncodingCharacters() {
        ST retVal = (ST)this.getTypedField(2, 0);
        return retVal;
    }

    public HD getSendingApplication() {
        HD retVal = (HD)this.getTypedField(3, 0);
        return retVal;
    }

    public HD getMsh3_SendingApplication() {
        HD retVal = (HD)this.getTypedField(3, 0);
        return retVal;
    }

    public HD getSendingFacility() {
        HD retVal = (HD)this.getTypedField(4, 0);
        return retVal;
    }

    public HD getMsh4_SendingFacility() {
        HD retVal = (HD)this.getTypedField(4, 0);
        return retVal;
    }

    public HD getReceivingApplication() {
        HD retVal = (HD)this.getTypedField(5, 0);
        return retVal;
    }

    public HD getMsh5_ReceivingApplication() {
        HD retVal = (HD)this.getTypedField(5, 0);
        return retVal;
    }

    public HD getReceivingFacility() {
        HD retVal = (HD)this.getTypedField(6, 0);
        return retVal;
    }

    public HD getMsh6_ReceivingFacility() {
        HD retVal = (HD)this.getTypedField(6, 0);
        return retVal;
    }

    public TS getDateTimeOfMessage() {
        TS retVal = (TS)this.getTypedField(7, 0);
        return retVal;
    }

    public TS getMsh7_DateTimeOfMessage() {
        TS retVal = (TS)this.getTypedField(7, 0);
        return retVal;
    }

    public ST getSecurity() {
        ST retVal = (ST)this.getTypedField(8, 0);
        return retVal;
    }

    public ST getMsh8_Security() {
        ST retVal = (ST)this.getTypedField(8, 0);
        return retVal;
    }

    public MSG getMessageType() {
        MSG retVal = (MSG)this.getTypedField(9, 0);
        return retVal;
    }

    public MSG getMsh9_MessageType() {
        MSG retVal = (MSG)this.getTypedField(9, 0);
        return retVal;
    }

    public ST getMessageControlID() {
        ST retVal = (ST)this.getTypedField(10, 0);
        return retVal;
    }

    public ST getMsh10_MessageControlID() {
        ST retVal = (ST)this.getTypedField(10, 0);
        return retVal;
    }

    public PT getProcessingID() {
        PT retVal = (PT)this.getTypedField(11, 0);
        return retVal;
    }

    public PT getMsh11_ProcessingID() {
        PT retVal = (PT)this.getTypedField(11, 0);
        return retVal;
    }

    public VID getVersionID() {
        VID retVal = (VID)this.getTypedField(12, 0);
        return retVal;
    }

    public VID getMsh12_VersionID() {
        VID retVal = (VID)this.getTypedField(12, 0);
        return retVal;
    }

    public NM getSequenceNumber() {
        NM retVal = (NM)this.getTypedField(13, 0);
        return retVal;
    }

    public NM getMsh13_SequenceNumber() {
        NM retVal = (NM)this.getTypedField(13, 0);
        return retVal;
    }

    public ST getContinuationPointer() {
        ST retVal = (ST)this.getTypedField(14, 0);
        return retVal;
    }

    public ST getMsh14_ContinuationPointer() {
        ST retVal = (ST)this.getTypedField(14, 0);
        return retVal;
    }

    public ID getAcceptAcknowledgmentType() {
        ID retVal = (ID)this.getTypedField(15, 0);
        return retVal;
    }

    public ID getMsh15_AcceptAcknowledgmentType() {
        ID retVal = (ID)this.getTypedField(15, 0);
        return retVal;
    }

    public ID getApplicationAcknowledgmentType() {
        ID retVal = (ID)this.getTypedField(16, 0);
        return retVal;
    }

    public ID getMsh16_ApplicationAcknowledgmentType() {
        ID retVal = (ID)this.getTypedField(16, 0);
        return retVal;
    }

    public ID getCountryCode() {
        ID retVal = (ID)this.getTypedField(17, 0);
        return retVal;
    }

    public ID getMsh17_CountryCode() {
        ID retVal = (ID)this.getTypedField(17, 0);
        return retVal;
    }

    public ID[] getCharacterSet() {
        ID[] retVal = (ID[])this.getTypedField(18, (Type[])new ID[0]);
        return retVal;
    }

    public ID[] getMsh18_CharacterSet() {
        ID[] retVal = (ID[])this.getTypedField(18, (Type[])new ID[0]);
        return retVal;
    }

    public int getCharacterSetReps() {
        return this.getReps(18);
    }

    public ID getCharacterSet(int rep) {
        ID retVal = (ID)this.getTypedField(18, rep);
        return retVal;
    }

    public ID getMsh18_CharacterSet(int rep) {
        ID retVal = (ID)this.getTypedField(18, rep);
        return retVal;
    }

    public int getMsh18_CharacterSetReps() {
        return this.getReps(18);
    }

    public ID insertCharacterSet(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(18, rep);
    }

    public ID insertMsh18_CharacterSet(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(18, rep);
    }

    public ID removeCharacterSet(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(18, rep);
    }

    public ID removeMsh18_CharacterSet(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(18, rep);
    }

    public CE getPrincipalLanguageOfMessage() {
        CE retVal = (CE)this.getTypedField(19, 0);
        return retVal;
    }

    public CE getMsh19_PrincipalLanguageOfMessage() {
        CE retVal = (CE)this.getTypedField(19, 0);
        return retVal;
    }

    public ID getAlternateCharacterSetHandlingScheme() {
        ID retVal = (ID)this.getTypedField(20, 0);
        return retVal;
    }

    public ID getMsh20_AlternateCharacterSetHandlingScheme() {
        ID retVal = (ID)this.getTypedField(20, 0);
        return retVal;
    }

    public ID[] getConformanceStatementID() {
        ID[] retVal = (ID[])this.getTypedField(21, (Type[])new ID[0]);
        return retVal;
    }

    public ID[] getMsh21_ConformanceStatementID() {
        ID[] retVal = (ID[])this.getTypedField(21, (Type[])new ID[0]);
        return retVal;
    }

    public int getConformanceStatementIDReps() {
        return this.getReps(21);
    }

    public ID getConformanceStatementID(int rep) {
        ID retVal = (ID)this.getTypedField(21, rep);
        return retVal;
    }

    public ID getMsh21_ConformanceStatementID(int rep) {
        ID retVal = (ID)this.getTypedField(21, rep);
        return retVal;
    }

    public int getMsh21_ConformanceStatementIDReps() {
        return this.getReps(21);
    }

    public ID insertConformanceStatementID(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(21, rep);
    }

    public ID insertMsh21_ConformanceStatementID(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(21, rep);
    }

    public ID removeConformanceStatementID(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(21, rep);
    }

    public ID removeMsh21_ConformanceStatementID(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(21, rep);
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new ST(this.getMessage());
            }
            case 1: {
                return new ST(this.getMessage());
            }
            case 2: {
                return new HD(this.getMessage());
            }
            case 3: {
                return new HD(this.getMessage());
            }
            case 4: {
                return new HD(this.getMessage());
            }
            case 5: {
                return new HD(this.getMessage());
            }
            case 6: {
                return new TS(this.getMessage());
            }
            case 7: {
                return new ST(this.getMessage());
            }
            case 8: {
                return new MSG(this.getMessage());
            }
            case 9: {
                return new ST(this.getMessage());
            }
            case 10: {
                return new PT(this.getMessage());
            }
            case 11: {
                return new VID(this.getMessage());
            }
            case 12: {
                return new NM(this.getMessage());
            }
            case 13: {
                return new ST(this.getMessage());
            }
            case 14: {
                return new ID(this.getMessage(), new Integer(155));
            }
            case 15: {
                return new ID(this.getMessage(), new Integer(155));
            }
            case 16: {
                return new ID(this.getMessage(), new Integer(399));
            }
            case 17: {
                return new ID(this.getMessage(), new Integer(211));
            }
            case 18: {
                return new CE(this.getMessage());
            }
            case 19: {
                return new ID(this.getMessage(), new Integer(356));
            }
            case 20: {
                return new ID(this.getMessage(), new Integer(449));
            }
        }
        return null;
    }
}

