/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.cal10n.plugins;

import ch.qos.cal10n.plugins.ThisFirstClassLoader;
import ch.qos.cal10n.verifier.IMessageKeyVerifier;
import java.io.File;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VerifyMojo
extends AbstractMojo {
    private String[] enumTypes;
    private File outputDirectory;
    private Set<Artifact> projectArtifacts;
    private ArtifactRepository localRepository;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.enumTypes == null) {
            throw new MojoFailureException("Missing <enumTypes> element. Please see http://cal10n.qos.ch/codes.html#missingEnumType");
        }
        for (String enumTypeAsStr : this.enumTypes) {
            IMessageKeyVerifier imcv = this.getMessageKeyVerifierInstance(enumTypeAsStr);
            this.getLog().info((CharSequence)("Checking all resource bundles for enum type [" + enumTypeAsStr + "]"));
            this.checkAllLocales(imcv);
        }
    }

    public void checkAllLocales(IMessageKeyVerifier mcv) throws MojoFailureException, MojoExecutionException {
        String enumClassAsStr = mcv.getEnumTypeAsStr();
        String[] localeNameArray = mcv.getLocaleNames();
        if (localeNameArray == null || localeNameArray.length == 0) {
            String errMsg = MessageFormat.format("Missing @LocaleData annotation in enum type [{0}]. Please see http://cal10n.qos.ch/codes.html#missingLDAnnotation", enumClassAsStr);
            this.getLog().error((CharSequence)errMsg);
            throw new MojoFailureException(errMsg);
        }
        boolean failure = false;
        for (String localeName : localeNameArray) {
            Locale locale = new Locale(localeName);
            List errorList = mcv.typeIsolatedVerify(locale);
            if (errorList.size() == 0) {
                String resourceBundleName = mcv.getBaseName();
                this.getLog().info((CharSequence)("SUCCESSFUL verification for resource bundle [" + resourceBundleName + "] for locale [" + locale + "]"));
                continue;
            }
            failure = true;
            this.getLog().error((CharSequence)("FAILURE during verification of resource bundle for locale [" + locale + "] enum class [" + enumClassAsStr + "]"));
            for (String s : errorList) {
                this.getLog().error((CharSequence)s);
            }
        }
        if (failure) {
            throw new MojoFailureException("FAIL Verification of [" + enumClassAsStr + "] keys.");
        }
    }

    IMessageKeyVerifier getMessageKeyVerifierInstance(String enumClassAsStr) throws MojoExecutionException {
        String errMsg = "Failed to instantiate MessageKeyVerifier class";
        try {
            ThisFirstClassLoader thisFirstClassLoader = (ThisFirstClassLoader)this.buildClassLoader();
            Class<?> mkvClass = Class.forName("ch.qos.cal10n.verifier.MessageKeyVerifier", true, thisFirstClassLoader);
            Constructor<?> mkvCons = mkvClass.getConstructor(String.class);
            IMessageKeyVerifier imcv = (IMessageKeyVerifier)mkvCons.newInstance(enumClassAsStr);
            return imcv;
        }
        catch (ClassNotFoundException e) {
            throw new MojoExecutionException(errMsg, (Exception)e);
        }
        catch (NoClassDefFoundError e) {
            throw new MojoExecutionException(errMsg, (Throwable)e);
        }
        catch (Exception e) {
            throw new MojoExecutionException(errMsg, e);
        }
    }

    ClassLoader buildClassLoader() {
        ArrayList<URL> classpathURLList = new ArrayList<URL>();
        classpathURLList.add(this.toURL(this.outputDirectory));
        classpathURLList.addAll(this.getDirectDependencies());
        ClassLoader parentCL = ((Object)((Object)this)).getClass().getClassLoader();
        URL[] classpathURLArray = classpathURLList.toArray(new URL[0]);
        return new ThisFirstClassLoader(classpathURLArray, parentCL);
    }

    List<URL> getDirectDependencies() {
        ArrayList<URL> urlList = new ArrayList<URL>();
        for (Artifact a : this.projectArtifacts) {
            String pathOfArtifact = this.localRepository.getBasedir() + "/" + this.localRepository.pathOf(a);
            File artifactAsFile = new File(pathOfArtifact);
            if (!artifactAsFile.exists()) {
                this.getLog().error((CharSequence)("Artifact [" + artifactAsFile + "] could not be located"));
            }
            try {
                URL url = artifactAsFile.toURI().toURL();
                urlList.add(url);
            }
            catch (MalformedURLException e) {
                this.getLog().info((CharSequence)"Failed to build URL", (Throwable)e);
            }
        }
        return urlList;
    }

    URL toURL(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            this.getLog().error((CharSequence)("Failed to convert file [" + file + "] to a URL"), (Throwable)e);
            return null;
        }
    }
}

