/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.captcha.generator.impl;

import cloud.tianai.captcha.generator.AbstractImageCaptchaGenerator;
import cloud.tianai.captcha.generator.ImageTransform;
import cloud.tianai.captcha.generator.common.model.dto.CaptchaExchange;
import cloud.tianai.captcha.generator.common.model.dto.CustomData;
import cloud.tianai.captcha.generator.common.model.dto.GenerateParam;
import cloud.tianai.captcha.generator.common.model.dto.ImageTransformData;
import cloud.tianai.captcha.generator.common.model.dto.SliderImageCaptchaInfo;
import cloud.tianai.captcha.generator.common.util.CaptchaImageUtils;
import cloud.tianai.captcha.interceptor.CaptchaInterceptor;
import cloud.tianai.captcha.resource.ImageCaptchaResourceManager;
import cloud.tianai.captcha.resource.common.model.dto.Resource;
import cloud.tianai.captcha.resource.common.model.dto.ResourceMap;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardSliderImageCaptchaGenerator
extends AbstractImageCaptchaGenerator {
    private static final Logger log = LoggerFactory.getLogger(StandardSliderImageCaptchaGenerator.class);
    public static String TEMPLATE_ACTIVE_IMAGE_NAME = "active.png";
    public static String TEMPLATE_FIXED_IMAGE_NAME = "fixed.png";
    public static String TEMPLATE_MASK_IMAGE_NAME = "mask.png";
    public static String OBFUSCATE_TEMPLATE_FIXED_IMAGE_NAME = "obfuscate_" + TEMPLATE_FIXED_IMAGE_NAME;

    public StandardSliderImageCaptchaGenerator(ImageCaptchaResourceManager imageCaptchaResourceManager) {
        super(imageCaptchaResourceManager);
    }

    public StandardSliderImageCaptchaGenerator(ImageCaptchaResourceManager imageCaptchaResourceManager, ImageTransform imageTransform) {
        super(imageCaptchaResourceManager);
        this.setImageTransform(imageTransform);
    }

    public StandardSliderImageCaptchaGenerator(ImageCaptchaResourceManager imageCaptchaResourceManager, ImageTransform imageTransform, CaptchaInterceptor interceptor) {
        super(imageCaptchaResourceManager);
        this.setImageTransform(imageTransform);
        this.setInterceptor(interceptor);
    }

    @Override
    protected void doInit() {
    }

    @Override
    public void doGenerateCaptchaImage(CaptchaExchange captchaExchange) {
        GenerateParam param = captchaExchange.getParam();
        Boolean obfuscate = param.getObfuscate();
        ResourceMap templateResource = this.requiredRandomGetTemplate(param.getType(), param.getTemplateImageTag());
        Resource resourceImage = this.requiredRandomGetResource(param.getType(), param.getBackgroundImageTag());
        BufferedImage background = this.getResourceImage(resourceImage);
        BufferedImage fixedTemplate = this.getTemplateImage(templateResource, TEMPLATE_FIXED_IMAGE_NAME);
        BufferedImage activeTemplate = this.getTemplateImage(templateResource, TEMPLATE_ACTIVE_IMAGE_NAME);
        BufferedImage maskTemplate = fixedTemplate;
        Optional<BufferedImage> maskTemplateOptional = this.getTemplateImageOfOptional(templateResource, TEMPLATE_MASK_IMAGE_NAME);
        if (maskTemplateOptional.isPresent()) {
            maskTemplate = maskTemplateOptional.get();
        }
        int randomX = this.randomInt(fixedTemplate.getWidth() + 5, background.getWidth() - fixedTemplate.getWidth() - 10);
        int randomY = this.randomInt(background.getHeight() - fixedTemplate.getHeight());
        BufferedImage cutImage = CaptchaImageUtils.cutImage(background, maskTemplate, randomX, randomY);
        CaptchaImageUtils.overlayImage(background, fixedTemplate, randomX, randomY);
        if (obfuscate.booleanValue()) {
            Optional<BufferedImage> obfuscateFixedTemplate = this.getTemplateImageOfOptional(templateResource, OBFUSCATE_TEMPLATE_FIXED_IMAGE_NAME);
            BufferedImage obfuscateImage = obfuscateFixedTemplate.orElseGet(() -> this.createObfuscate(fixedTemplate));
            int obfuscateX = this.randomObfuscateX(randomX, fixedTemplate.getWidth(), background.getWidth());
            CaptchaImageUtils.overlayImage(background, obfuscateImage, obfuscateX, randomY);
        }
        CaptchaImageUtils.overlayImage(cutImage, activeTemplate, 0, 0);
        BufferedImage matrixTemplate = CaptchaImageUtils.createTransparentImage(activeTemplate.getWidth(), background.getHeight());
        CaptchaImageUtils.overlayImage(matrixTemplate, cutImage, 0, randomY);
        XandY xandY = new XandY();
        xandY.x = randomX;
        xandY.y = randomY;
        captchaExchange.setBackgroundImage(background);
        captchaExchange.setTemplateImage(matrixTemplate);
        captchaExchange.setTemplateResource(templateResource);
        captchaExchange.setResourceImage(resourceImage);
        captchaExchange.setTransferData(xandY);
    }

    protected BufferedImage createObfuscate(BufferedImage fixedImage) {
        int width = fixedImage.getWidth();
        int height = fixedImage.getHeight();
        int window = this.randomInt(-3, 4);
        if (this.randomBoolean()) {
            height += window * 5;
        } else {
            width += window * 5;
        }
        int type = fixedImage.getColorModel().getTransparency();
        BufferedImage image = new BufferedImage(width, height, type);
        Graphics2D graphics = image.createGraphics();
        double alpha = ThreadLocalRandom.current().nextDouble(0.5, 0.8);
        AlphaComposite alphaComposite = AlphaComposite.Src.derive((float)alpha);
        graphics.setComposite(alphaComposite);
        graphics.drawImage(fixedImage, 0, 0, width, height, null);
        return image;
    }

    @Override
    public SliderImageCaptchaInfo doWrapImageCaptchaInfo(CaptchaExchange captchaExchange) {
        GenerateParam param = captchaExchange.getParam();
        BufferedImage backgroundImage = captchaExchange.getBackgroundImage();
        BufferedImage sliderImage = captchaExchange.getTemplateImage();
        Resource resourceImage = captchaExchange.getResourceImage();
        ResourceMap templateResource = captchaExchange.getTemplateResource();
        CustomData customData = captchaExchange.getCustomData();
        XandY data = (XandY)captchaExchange.getTransferData();
        ImageTransformData transform = this.getImageTransform().transform(param, backgroundImage, sliderImage, resourceImage, templateResource, customData);
        SliderImageCaptchaInfo imageCaptchaInfo = SliderImageCaptchaInfo.of(data.x, data.y, transform.getBackgroundImageUrl(), transform.getTemplateImageUrl(), resourceImage.getTag(), templateResource.getTag(), (Integer)backgroundImage.getWidth(), (Integer)backgroundImage.getHeight(), (Integer)sliderImage.getWidth(), sliderImage.getHeight());
        imageCaptchaInfo.setData(customData);
        return imageCaptchaInfo;
    }

    protected int randomObfuscateX(int sliderX, int slWidth, int bgWidth) {
        if (bgWidth / 2 > sliderX + slWidth / 2) {
            return this.randomInt(sliderX + slWidth, bgWidth - slWidth);
        }
        return this.randomInt(slWidth, sliderX - slWidth);
    }

    public static class XandY {
        int x;
        int y;
    }
}

