/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.captcha.application;

import cloud.tianai.captcha.application.DefaultImageCaptchaApplication;
import cloud.tianai.captcha.application.ImageCaptchaApplication;
import cloud.tianai.captcha.application.ImageCaptchaProperties;
import cloud.tianai.captcha.cache.CacheStore;
import cloud.tianai.captcha.cache.impl.LocalCacheStore;
import cloud.tianai.captcha.generator.ImageCaptchaGenerator;
import cloud.tianai.captcha.generator.ImageTransform;
import cloud.tianai.captcha.generator.impl.MultiImageCaptchaGenerator;
import cloud.tianai.captcha.interceptor.CaptchaInterceptor;
import cloud.tianai.captcha.interceptor.EmptyCaptchaInterceptor;
import cloud.tianai.captcha.resource.CrudResourceStore;
import cloud.tianai.captcha.resource.DefaultBuiltInResources;
import cloud.tianai.captcha.resource.ResourceProviders;
import cloud.tianai.captcha.resource.ResourceStore;
import cloud.tianai.captcha.resource.common.model.dto.Resource;
import cloud.tianai.captcha.resource.common.model.dto.ResourceMap;
import cloud.tianai.captcha.resource.impl.DefaultImageCaptchaResourceManager;
import cloud.tianai.captcha.resource.impl.LocalMemoryResourceStore;
import cloud.tianai.captcha.validator.ImageCaptchaValidator;
import cloud.tianai.captcha.validator.impl.SimpleImageCaptchaValidator;

public class TACBuilder {
    private CacheStore cacheStore;
    private ImageCaptchaGenerator generator;
    private ImageCaptchaValidator validator;
    private CaptchaInterceptor interceptor = EmptyCaptchaInterceptor.INSTANCE;
    private ImageCaptchaProperties prop = new ImageCaptchaProperties();
    private ResourceStore resourceStore;
    private ImageTransform imageTransform;

    public static TACBuilder builder() {
        return TACBuilder.builder(new LocalMemoryResourceStore());
    }

    public static TACBuilder builder(ResourceStore resourceStore) {
        TACBuilder builder = new TACBuilder(resourceStore);
        builder.prop = new ImageCaptchaProperties();
        return builder;
    }

    private TACBuilder(ResourceStore resourceStore) {
        this.resourceStore = resourceStore;
    }

    public TACBuilder addDefaultTemplate(String defaultPathPrefix) {
        DefaultBuiltInResources defaultBuiltInResources = new DefaultBuiltInResources(defaultPathPrefix);
        defaultBuiltInResources.addDefaultTemplate(this.resourceStore);
        return this;
    }

    public TACBuilder addDefaultTemplate() {
        return this.addDefaultTemplate("classpath:META-INF/cut-image/template");
    }

    public TACBuilder setCacheStore(CacheStore cacheStore) {
        this.cacheStore = cacheStore;
        return this;
    }

    public TACBuilder setGenerator(ImageCaptchaGenerator generator) {
        this.generator = generator;
        return this;
    }

    public TACBuilder setValidator(ImageCaptchaValidator validator) {
        this.validator = validator;
        return this;
    }

    public TACBuilder setInterceptor(CaptchaInterceptor interceptor) {
        this.interceptor = interceptor;
        return this;
    }

    public TACBuilder addFont(Resource resource) {
        this.addResource("font", resource);
        return this;
    }

    public TACBuilder cached(int size, int waitTime, int period, Long expireTime) {
        this.prop.setLocalCacheEnabled(true);
        this.prop.setLocalCacheSize(size);
        this.prop.setLocalCacheWaitTime(waitTime);
        this.prop.setLocalCachePeriod(period);
        this.prop.setLocalCacheExpireTime(expireTime);
        return this;
    }

    public TACBuilder prefix(String prefix) {
        this.prop.setPrefix(prefix);
        return this;
    }

    public TACBuilder expire(String captchaType, Long expireTime) {
        this.prop.getExpire().put(captchaType, expireTime);
        return this;
    }

    public TACBuilder setProp(ImageCaptchaProperties prop) {
        this.prop = prop;
        return this;
    }

    public TACBuilder addResource(String captchaType, Resource imageResource) {
        if (this.resourceStore instanceof CrudResourceStore) {
            ((CrudResourceStore)this.resourceStore).addResource(captchaType, imageResource);
        }
        return this;
    }

    public TACBuilder addTemplate(String captchaType, ResourceMap resourceMap) {
        if (this.resourceStore instanceof CrudResourceStore) {
            ((CrudResourceStore)this.resourceStore).addTemplate(captchaType, resourceMap);
        }
        return this;
    }

    public TACBuilder setTransform(ImageTransform imageTransform) {
        this.imageTransform = imageTransform;
        return this;
    }

    public ImageCaptchaApplication build() {
        if (this.cacheStore == null) {
            this.cacheStore = new LocalCacheStore();
        }
        if (this.generator == null) {
            ResourceProviders resourceProviders = new ResourceProviders();
            DefaultImageCaptchaResourceManager resourceManager = new DefaultImageCaptchaResourceManager(this.resourceStore, resourceProviders);
            this.generator = new MultiImageCaptchaGenerator(resourceManager, this.imageTransform);
        }
        if (this.validator == null) {
            this.validator = new SimpleImageCaptchaValidator();
        }
        if (this.interceptor == null) {
            this.interceptor = EmptyCaptchaInterceptor.INSTANCE;
        }
        DefaultImageCaptchaApplication application = new DefaultImageCaptchaApplication(this.generator, this.validator, this.cacheStore, this.prop, this.interceptor);
        return application;
    }
}

