/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.captcha.cache.impl;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public interface ExpiringMap<K, V>
extends Map<K, V> {
    public static final Long DEFAULT_EXPIRE = -1L;

    public TimeMapEntity<K, V> put(K var1, V var2, Long var3, TimeUnit var4);

    public Optional<TimeMapEntity<K, V>> getData(K var1);

    public Long getExpire(K var1);

    public boolean incr(K var1, Long var2, TimeUnit var3);

    public void init();

    public static class TimeMapEntity<K, V> {
        private K key;
        private V value;
        private Long expire;
        private Long createTime;
        private long timeout = -1L;

        TimeMapEntity(K k, V value, Long expire, Long createTime) {
            this.key = k;
            this.value = value;
            this.expire = expire;
            this.createTime = createTime;
            if (expire > 0L) {
                this.timeout = createTime + expire;
            }
        }

        public TimeMapEntity(TimeMapEntity<K, V> entity) {
            this.key = entity.getKey();
            this.value = entity.getValue();
            this.expire = entity.getExpire();
            this.createTime = entity.getCreateTime();
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }

        public Long getExpire() {
            return this.expire;
        }

        public Long getCreateTime() {
            return this.createTime;
        }

        public long getTimeout() {
            return this.timeout;
        }

        public void setKey(K key) {
            this.key = key;
        }

        public void setValue(V value) {
            this.value = value;
        }

        public void setExpire(Long expire) {
            this.expire = expire;
        }

        public void setCreateTime(Long createTime) {
            this.createTime = createTime;
        }

        public void setTimeout(long timeout) {
            this.timeout = timeout;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TimeMapEntity)) {
                return false;
            }
            TimeMapEntity other = (TimeMapEntity)o;
            if (!other.canEqual(this)) {
                return false;
            }
            K this$key = this.getKey();
            K other$key = other.getKey();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            V this$value = this.getValue();
            V other$value = other.getValue();
            if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
                return false;
            }
            Long this$expire = this.getExpire();
            Long other$expire = other.getExpire();
            if (this$expire == null ? other$expire != null : !((Object)this$expire).equals(other$expire)) {
                return false;
            }
            Long this$createTime = this.getCreateTime();
            Long other$createTime = other.getCreateTime();
            if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
                return false;
            }
            return this.getTimeout() == other.getTimeout();
        }

        protected boolean canEqual(Object other) {
            return other instanceof TimeMapEntity;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            K $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            V $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            Long $expire = this.getExpire();
            result = result * 59 + ($expire == null ? 43 : ((Object)$expire).hashCode());
            Long $createTime = this.getCreateTime();
            result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
            long $timeout = this.getTimeout();
            result = result * 59 + (int)($timeout >>> 32 ^ $timeout);
            return result;
        }

        public String toString() {
            return "ExpiringMap.TimeMapEntity(key=" + this.getKey() + ", value=" + this.getValue() + ", expire=" + this.getExpire() + ", createTime=" + this.getCreateTime() + ", timeout=" + this.getTimeout() + ")";
        }
    }
}

