/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.captcha.common.response;

import cloud.tianai.captcha.common.response.ApiResponseStatusConstant;
import cloud.tianai.captcha.common.response.CodeDefinition;
import java.io.Serializable;

public class ApiResponse<T>
implements Serializable {
    public static final ApiResponse<?> SUCCESS;
    private Integer code;
    private String msg;
    private T data;

    public ApiResponse(Integer code, String errMsg, T data) {
        this.code = code;
        this.msg = errMsg;
        this.data = data;
    }

    public ApiResponse(CodeDefinition definition, T data) {
        this.code = definition.getCode();
        this.msg = definition.getMessage();
        this.data = data;
    }

    public ApiResponse() {
        CodeDefinition definition = ApiResponseStatusConstant.SUCCESS;
        this.code = definition.getCode();
        this.msg = definition.getMessage();
    }

    public <R> ApiResponse<R> convert() {
        ApiResponse<T> result = new ApiResponse<T>();
        result.setCode(this.getCode());
        result.setMsg(this.getMsg());
        return result;
    }

    public boolean isSuccess() {
        return ApiResponseStatusConstant.SUCCESS.getCode().equals(this.getCode());
    }

    public static <T> ApiResponse<T> of(Integer code, String msg, T data) {
        return new ApiResponse<T>(code, msg, data);
    }

    public static <T> ApiResponse<T> of(CodeDefinition definition, T data) {
        return new ApiResponse<T>(definition.getCode(), definition.getMessage(), data);
    }

    public static <T> ApiResponse<T> ofMessage(CodeDefinition definition) {
        return new ApiResponse<Object>(definition.getCode(), definition.getMessage(), null);
    }

    public static <T> ApiResponse<T> ofError(String message) {
        return new ApiResponse<Object>(ApiResponseStatusConstant.INTERNAL_SERVER_ERROR.getCode(), message, null);
    }

    public static <T> ApiResponse<T> ofError(String message, Object obj) {
        return new ApiResponse<Object>(ApiResponseStatusConstant.INTERNAL_SERVER_ERROR.getCode(), message, obj);
    }

    public static <T> ApiResponse<T> ofCheckError(String message) {
        return new ApiResponse<Object>(ApiResponseStatusConstant.NOT_VALID_PARAM.getCode(), message, null);
    }

    public static <T> ApiResponse<T> ofSuccess(T data) {
        CodeDefinition definition = ApiResponseStatusConstant.SUCCESS;
        return new ApiResponse<T>(definition.getCode(), definition.getMessage(), data);
    }

    public static <T> ApiResponse<T> ofSuccess() {
        return SUCCESS;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public T getData() {
        return this.data;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void setData(T data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApiResponse)) {
            return false;
        }
        ApiResponse other = (ApiResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$code = this.getCode();
        Integer other$code = other.getCode();
        if (this$code == null ? other$code != null : !((Object)this$code).equals(other$code)) {
            return false;
        }
        String this$msg = this.getMsg();
        String other$msg = other.getMsg();
        if (this$msg == null ? other$msg != null : !this$msg.equals(other$msg)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ApiResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : ((Object)$code).hashCode());
        String $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "ApiResponse(code=" + this.getCode() + ", msg=" + this.getMsg() + ", data=" + this.getData() + ")";
    }

    static {
        CodeDefinition definition = ApiResponseStatusConstant.SUCCESS;
        SUCCESS = new ApiResponse<Object>(definition.getCode(), definition.getMessage(), null);
    }
}

