/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.captcha.generator.impl;

import cloud.tianai.captcha.generator.AbstractImageCaptchaGenerator;
import cloud.tianai.captcha.generator.common.model.dto.CaptchaExchange;
import cloud.tianai.captcha.generator.common.model.dto.ClickImageCheckDefinition;
import cloud.tianai.captcha.generator.common.model.dto.GenerateParam;
import cloud.tianai.captcha.generator.common.util.CaptchaImageUtils;
import cloud.tianai.captcha.resource.ImageCaptchaResourceManager;
import cloud.tianai.captcha.resource.common.model.dto.Resource;
import cloud.tianai.captcha.resource.common.model.dto.ResourceMap;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;

public abstract class AbstractClickImageCaptchaGenerator
extends AbstractImageCaptchaGenerator {
    public static final String CLICK_IMAGE_DISTORT_KEY = "clickImageDistort";

    public AbstractClickImageCaptchaGenerator(ImageCaptchaResourceManager imageCaptchaResourceManager) {
        super(imageCaptchaResourceManager);
    }

    public AbstractClickImageCaptchaGenerator() {
    }

    @Override
    public void doGenerateCaptchaImage(CaptchaExchange captchaExchange) {
        GenerateParam param = captchaExchange.getParam();
        Resource resourceImage = this.requiredRandomGetResource(param.getType(), param.getBackgroundImageTag());
        BufferedImage bgImage = this.getResourceImage(resourceImage);
        List<ResourceMap> imgTips = this.randomGetClickImgTips(param);
        int allImages = imgTips.size();
        ArrayList<ClickImageCheckDefinition> clickImageCheckDefinitionList = new ArrayList<ClickImageCheckDefinition>(allImages);
        int avg = bgImage.getWidth() / allImages;
        if (allImages < imgTips.size()) {
            throw new IllegalStateException("\u968f\u673a\u751f\u6210\u70b9\u51fb\u56fe\u7247\u5c0f\u4e8e\u8bf7\u6c42\u6570\u91cf\uff0c \u8bf7\u6c42\u751f\u6210\u6570\u91cf=" + allImages + ",\u5b9e\u9645\u751f\u6210\u6570\u91cf=" + imgTips.size());
        }
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (int i = 0; i < allImages; ++i) {
            ResourceMap resourceMap = imgTips.get(i);
            Resource tipResource = resourceMap.get("IMAGE_TIP_ICON");
            Resource clickResource = resourceMap.get("IMAGE_CLICK_ICON");
            if (clickResource == null) {
                throw new IllegalStateException("\u968f\u673a\u751f\u6210\u70b9\u51fb\u56fe\u7247\u5931\u8d25\uff0c\u8d44\u6e90\u4e2d\u5fc5\u987b\u5305\u542b[IMAGE_CLICK_ICON]" + resourceMap);
            }
            if (tipResource == null) {
                tipResource = clickResource;
            }
            ClickImageCheckDefinition.ImgWrapper imgWrapper = this.getClickImg(param, clickResource, null);
            BufferedImage image = imgWrapper.getImage();
            image = this.obfuscateImage(image, param);
            int clickImgWidth = image.getWidth();
            int clickImgHeight = image.getHeight();
            if (i == 0) {
                int w = clickImgWidth + clickImgWidth / 2;
                int h = clickImgHeight + clickImgHeight / 2;
                int xNum = (int)Math.floor((double)bgImage.getWidth() / (double)w);
                int yNum = (int)Math.floor((double)bgImage.getHeight() / (double)h);
                for (int x = 0; x < xNum; ++x) {
                    for (int y = 0; y < yNum; ++y) {
                        blocks.add(new Block(x * w + clickImgWidth / 2, clickImgWidth, y * h + clickImgHeight / 2, clickImgHeight));
                    }
                }
            }
            Block block = (Block)blocks.remove(ThreadLocalRandom.current().nextInt(0, blocks.size()));
            CaptchaImageUtils.overlayImage(bgImage, image, block.startX, block.startY);
            ClickImageCheckDefinition clickImageCheckDefinition = new ClickImageCheckDefinition();
            clickImageCheckDefinition.setTip(tipResource);
            clickImageCheckDefinition.setTipImage(imgWrapper);
            clickImageCheckDefinition.setX(block.startX + clickImgWidth / 2);
            clickImageCheckDefinition.setY(block.startY + clickImgHeight / 2);
            clickImageCheckDefinition.setWidth(clickImgWidth);
            clickImageCheckDefinition.setHeight(clickImgHeight);
            clickImageCheckDefinition.setImageColor(imgWrapper.getImageColor());
            clickImageCheckDefinitionList.add(clickImageCheckDefinition);
        }
        List<ClickImageCheckDefinition> checkClickImageCheckDefinitionList = this.filterAndSortClickImageCheckDefinition(captchaExchange, clickImageCheckDefinitionList);
        captchaExchange.setBackgroundImage(bgImage);
        captchaExchange.setTransferData(checkClickImageCheckDefinitionList);
        captchaExchange.setResourceImage(resourceImage);
    }

    private BufferedImage obfuscateImage(BufferedImage image, GenerateParam param) {
        return image;
    }

    protected abstract List<ClickImageCheckDefinition> filterAndSortClickImageCheckDefinition(CaptchaExchange var1, List<ClickImageCheckDefinition> var2);

    protected abstract List<ResourceMap> randomGetClickImgTips(GenerateParam var1);

    public abstract ClickImageCheckDefinition.ImgWrapper getClickImg(GenerateParam var1, Resource var2, Color var3);

    private static class Block {
        private int startX;
        private int width;
        private int startY;
        private int height;

        public int getStartX() {
            return this.startX;
        }

        public int getWidth() {
            return this.width;
        }

        public int getStartY() {
            return this.startY;
        }

        public int getHeight() {
            return this.height;
        }

        public void setStartX(int startX) {
            this.startX = startX;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public void setStartY(int startY) {
            this.startY = startY;
        }

        public void setHeight(int height) {
            this.height = height;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Block)) {
                return false;
            }
            Block other = (Block)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getStartX() != other.getStartX()) {
                return false;
            }
            if (this.getWidth() != other.getWidth()) {
                return false;
            }
            if (this.getStartY() != other.getStartY()) {
                return false;
            }
            return this.getHeight() == other.getHeight();
        }

        protected boolean canEqual(Object other) {
            return other instanceof Block;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getStartX();
            result = result * 59 + this.getWidth();
            result = result * 59 + this.getStartY();
            result = result * 59 + this.getHeight();
            return result;
        }

        public String toString() {
            return "AbstractClickImageCaptchaGenerator.Block(startX=" + this.getStartX() + ", width=" + this.getWidth() + ", startY=" + this.getStartY() + ", height=" + this.getHeight() + ")";
        }

        public Block() {
        }

        public Block(int startX, int width, int startY, int height) {
            this.startX = startX;
            this.width = width;
            this.startY = startY;
            this.height = height;
        }
    }
}

