/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.captcha.interceptor;

import cloud.tianai.captcha.application.vo.ImageCaptchaVO;
import cloud.tianai.captcha.common.AnyMap;
import cloud.tianai.captcha.common.response.ApiResponse;
import cloud.tianai.captcha.generator.AbstractImageCaptchaGenerator;
import cloud.tianai.captcha.generator.common.model.dto.CaptchaExchange;
import cloud.tianai.captcha.generator.common.model.dto.GenerateParam;
import cloud.tianai.captcha.generator.common.model.dto.ImageCaptchaInfo;
import cloud.tianai.captcha.interceptor.CaptchaInterceptor;
import cloud.tianai.captcha.interceptor.Context;
import cloud.tianai.captcha.validator.common.model.dto.MatchParam;
import java.util.ArrayList;
import java.util.List;

public class CaptchaInterceptorGroup
implements CaptchaInterceptor {
    private String name = "group_interceptor";
    private List<CaptchaInterceptor> validators = new ArrayList<CaptchaInterceptor>();

    public void addInterceptor(CaptchaInterceptor validator) {
        this.validators.add(validator);
    }

    public void addInterceptor(List<CaptchaInterceptor> validators) {
        this.validators.addAll(validators);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CaptchaInterceptorGroup() {
    }

    public CaptchaInterceptorGroup(String name) {
        this.name = name;
    }

    @Override
    public Context createContext() {
        return new Context(this.getName(), null, -1, this.validators.size(), this);
    }

    protected Context createContextIfNecessary(Context context) {
        if (context == null) {
            return this.createContext();
        }
        if (!context.getGroup().equals(this)) {
            Context innerContext = this.createContext();
            innerContext.setParent(context);
            context = innerContext;
        }
        return context;
    }

    @Override
    public ApiResponse<ImageCaptchaVO> beforeGenerateCaptcha(Context context, String type, GenerateParam param) {
        context = this.createContextIfNecessary(context);
        ApiResponse<ImageCaptchaVO> captchaResponse = null;
        while (context.next() < context.getCount()) {
            CaptchaInterceptor interceptor = this.validators.get(context.getCurrent());
            captchaResponse = interceptor.beforeGenerateCaptcha(context, type, param);
            context.setPreReturnData(captchaResponse);
        }
        return captchaResponse;
    }

    @Override
    public void afterGenerateCaptcha(Context context, String type, ImageCaptchaInfo imageCaptchaInfo, ApiResponse<ImageCaptchaVO> captchaResponse) {
        context = this.createContextIfNecessary(context);
        while (context.next() < context.getCount()) {
            CaptchaInterceptor interceptor = this.validators.get(context.getCurrent());
            interceptor.afterGenerateCaptcha(context, type, imageCaptchaInfo, captchaResponse);
        }
    }

    @Override
    public ApiResponse<?> beforeValid(Context context, String type, MatchParam matchParam, AnyMap validData) {
        context = this.createContextIfNecessary(context);
        ApiResponse<?> beforeValid = null;
        while (context.next() < context.getCount()) {
            CaptchaInterceptor interceptor = this.validators.get(context.getCurrent());
            beforeValid = interceptor.beforeValid(context, type, matchParam, validData);
            context.setPreReturnData(beforeValid);
        }
        return beforeValid == null ? ApiResponse.ofSuccess() : beforeValid;
    }

    @Override
    public ApiResponse<?> afterValid(Context context, String type, MatchParam matchParam, AnyMap validData, ApiResponse<?> basicValid) {
        context = this.createContextIfNecessary(context);
        ApiResponse<?> valid = null;
        while (context.next() < context.getCount()) {
            CaptchaInterceptor interceptor = this.validators.get(context.getCurrent());
            valid = interceptor.afterValid(context, type, matchParam, validData, basicValid);
            context.setPreReturnData(valid);
        }
        return valid == null ? ApiResponse.ofSuccess() : valid;
    }

    @Override
    public ApiResponse<ImageCaptchaVO> beforeGenerateImageCaptchaValidData(Context context, String type, ImageCaptchaInfo imageCaptchaInfo) {
        context = this.createContextIfNecessary(context);
        ApiResponse<ImageCaptchaVO> captchaResponse = null;
        while (context.next() < context.getCount()) {
            CaptchaInterceptor interceptor = this.validators.get(context.getCurrent());
            captchaResponse = interceptor.beforeGenerateImageCaptchaValidData(context, type, imageCaptchaInfo);
            context.setPreReturnData(captchaResponse);
        }
        return captchaResponse;
    }

    @Override
    public void afterGenerateImageCaptchaValidData(Context context, String type, ImageCaptchaInfo imageCaptchaInfo, AnyMap validData) {
        context = this.createContextIfNecessary(context);
        while (context.next() < context.getCount()) {
            CaptchaInterceptor interceptor = this.validators.get(context.getCurrent());
            interceptor.afterGenerateImageCaptchaValidData(context, type, imageCaptchaInfo, validData);
        }
    }

    @Override
    public ImageCaptchaInfo beforeGenerateCaptchaImage(Context context, CaptchaExchange captchaExchange, AbstractImageCaptchaGenerator generator) {
        context = this.createContextIfNecessary(context);
        ImageCaptchaInfo response = null;
        while (context.next() < context.getCount()) {
            CaptchaInterceptor interceptor = this.validators.get(context.getCurrent());
            response = interceptor.beforeGenerateCaptchaImage(context, captchaExchange, generator);
        }
        return response;
    }

    @Override
    public void beforeWrapImageCaptchaInfo(Context context, CaptchaExchange captchaExchange, AbstractImageCaptchaGenerator generator) {
        context = this.createContextIfNecessary(context);
        while (context.next() < context.getCount()) {
            CaptchaInterceptor interceptor = this.validators.get(context.getCurrent());
            interceptor.beforeWrapImageCaptchaInfo(context, captchaExchange, generator);
        }
    }

    @Override
    public void afterGenerateCaptchaImage(Context context, CaptchaExchange captchaExchange, ImageCaptchaInfo imageCaptchaInfo, AbstractImageCaptchaGenerator generator) {
        context = this.createContextIfNecessary(context);
        while (context.next() < context.getCount()) {
            CaptchaInterceptor interceptor = this.validators.get(context.getCurrent());
            interceptor.afterGenerateCaptchaImage(context, captchaExchange, imageCaptchaInfo, generator);
        }
    }

    public String printTree() {
        return this.doPrintTree(1);
    }

    private String doPrintTree(int index) {
        int i;
        StringBuilder sb = new StringBuilder();
        StringBuilder start = new StringBuilder();
        for (i = 0; i < index; ++i) {
            start.append("|-----");
        }
        for (i = 0; i < this.validators.size(); ++i) {
            CaptchaInterceptor validator = this.validators.get(i);
            sb.append((CharSequence)start).append("[").append(validator.getName()).append("]").append("\n");
            if (!(validator instanceof CaptchaInterceptorGroup)) continue;
            sb.append(((CaptchaInterceptorGroup)validator).doPrintTree(index + 1));
        }
        return sb.toString();
    }

    public List<CaptchaInterceptor> getValidators() {
        return this.validators;
    }

    public void setValidators(List<CaptchaInterceptor> validators) {
        this.validators = validators;
    }
}

