/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.captcha.resource.impl;

import cloud.tianai.captcha.common.util.CollectionUtils;
import cloud.tianai.captcha.resource.FontCache;
import cloud.tianai.captcha.resource.ImageCaptchaResourceManager;
import cloud.tianai.captcha.resource.ResourceProvider;
import cloud.tianai.captcha.resource.ResourceProviders;
import cloud.tianai.captcha.resource.ResourceStore;
import cloud.tianai.captcha.resource.common.model.dto.Resource;
import cloud.tianai.captcha.resource.common.model.dto.ResourceMap;
import cloud.tianai.captcha.resource.impl.LocalMemoryResourceStore;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class DefaultImageCaptchaResourceManager
implements ImageCaptchaResourceManager {
    private ResourceStore resourceStore;
    private ResourceProviders resourceProviders;

    public DefaultImageCaptchaResourceManager() {
        this.init();
    }

    public DefaultImageCaptchaResourceManager(ResourceStore resourceStore, ResourceProviders resourceProviders) {
        this.resourceStore = resourceStore;
        this.resourceProviders = resourceProviders;
        this.init();
    }

    private void init() {
        if (this.resourceStore == null) {
            this.resourceStore = new LocalMemoryResourceStore();
        }
        this.resourceStore = new FontCache(this.resourceStore);
        this.resourceStore.init(this);
    }

    @Override
    public ResourceMap randomGetTemplate(String type, String tag) {
        return this.randomGetTemplate(type, tag, 1).get(0);
    }

    @Override
    public Resource randomGetResource(String type, String tag) {
        return this.randomGetResource(type, tag, 1).get(0);
    }

    @Override
    public List<ResourceMap> randomGetTemplate(String type, String tag, Integer quantity) {
        List<ResourceMap> resourceMaps = this.resourceStore.randomGetTemplateByTypeAndTag(type, tag, quantity);
        if (CollectionUtils.isEmpty(resourceMaps) || resourceMaps.size() != quantity.intValue()) {
            throw new IllegalStateException("\u968f\u673a\u83b7\u53d6**\u6a21\u677f**\u9519\u8bef\uff0c\u83b7\u53d6\u5230\u7684\u6570\u91cf\u548c\u6307\u5b9a\u6570\u91cf\u4e0d\u4e00\u81f4\uff0c \u6307\u5b9a\u83b7\u53d6\u6570\u91cf[" + quantity + "],\u83b7\u53d6\u5230\u7684\u6570\u636e:[" + Optional.ofNullable(resourceMaps).orElse(Collections.emptyList()).size() + "], [type:" + type + ",tag:" + tag + "]");
        }
        return resourceMaps;
    }

    @Override
    public List<Resource> randomGetResource(String type, String tag, Integer quantity) {
        List<Resource> resources = this.resourceStore.randomGetResourceByTypeAndTag(type, tag, quantity);
        if (CollectionUtils.isEmpty(resources) || resources.size() != quantity.intValue()) {
            throw new IllegalStateException("\u968f\u673a\u83b7\u53d6**\u8d44\u6e90**\u9519\u8bef\uff0c\u83b7\u53d6\u5230\u7684\u6570\u91cf\u548c\u6307\u5b9a\u6570\u91cf\u4e0d\u4e00\u81f4\uff0c \u6307\u5b9a\u83b7\u53d6\u6570\u91cf[" + quantity + "],\u83b7\u53d6\u5230\u7684\u6570\u636e:[" + Optional.ofNullable(resources).orElse(Collections.emptyList()).size() + "], [type:" + type + ",tag:" + tag + "]");
        }
        return resources;
    }

    @Override
    public InputStream getResourceInputStream(Resource resource) {
        return this.resourceProviders.getResourceInputStream(resource);
    }

    @Override
    public List<ResourceProvider> listResourceProviders() {
        return this.resourceProviders.listResourceProviders();
    }

    @Override
    public void registerResourceProvider(ResourceProvider resourceProvider) {
        this.resourceProviders.registerResourceProvider(resourceProvider);
    }

    @Override
    public boolean deleteResourceProviderByName(String name) {
        return this.resourceProviders.deleteResourceProviderByName(name);
    }

    @Override
    public void setResourceStore(ResourceStore resourceStore) {
        this.resourceStore = resourceStore;
    }

    @Override
    public ResourceStore getResourceStore() {
        return this.resourceStore;
    }

    public ResourceProviders getResourceProviders() {
        return this.resourceProviders;
    }
}

