/*
 * Decompiled with CFR 0.152.
 */
package cn.bingoogolapple.swipebacklayout;

import android.app.Activity;
import android.app.Dialog;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.view.MotionEvent;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;

public class BGAKeyboardUtil {
    private BGAKeyboardUtil() {
    }

    public static void closeKeyboard(Activity activity) {
        View view = activity.getWindow().peekDecorView();
        if (view != null) {
            InputMethodManager inputMethodManager = (InputMethodManager)activity.getSystemService("input_method");
            inputMethodManager.hideSoftInputFromWindow(view.getWindowToken(), 0);
        }
    }

    public static void closeKeyboard(Dialog dialog) {
        View view = dialog.getWindow().peekDecorView();
        if (view != null) {
            InputMethodManager inputMethodManager = (InputMethodManager)dialog.getContext().getSystemService("input_method");
            inputMethodManager.hideSoftInputFromWindow(view.getWindowToken(), 0);
        }
    }

    public static void openKeyboard(final Context context, final EditText editText) {
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                editText.requestFocus();
                editText.setSelection(editText.getText().toString().length());
                InputMethodManager imm = (InputMethodManager)context.getSystemService("input_method");
                imm.showSoftInput((View)editText, 2);
            }
        }, 300L);
    }

    public static void clip(Context context, String text) {
        if (Build.VERSION.SDK_INT < 11) {
            android.text.ClipboardManager clipboardManager = (android.text.ClipboardManager)context.getSystemService("clipboard");
            clipboardManager.setText((CharSequence)text);
        } else {
            ClipboardManager clipboardManager = (ClipboardManager)context.getSystemService("clipboard");
            clipboardManager.setPrimaryClip(ClipData.newPlainText((CharSequence)"content", (CharSequence)text));
        }
    }

    public static void toggleKeyboard(Activity activity) {
        InputMethodManager inputMethodManager = (InputMethodManager)activity.getSystemService("input_method");
        if (inputMethodManager.isActive()) {
            inputMethodManager.toggleSoftInput(0, 2);
        }
    }

    public static void handleAutoCloseKeyboard(boolean isAutoCloseKeyboard, View currentFocusView, MotionEvent motionEvent, Object dialogOrActivity) {
        if (isAutoCloseKeyboard && motionEvent.getAction() == 0 && currentFocusView != null && currentFocusView instanceof EditText && dialogOrActivity != null) {
            int[] leftTop = new int[]{0, 0};
            currentFocusView.getLocationInWindow(leftTop);
            int left = leftTop[0];
            int top = leftTop[1];
            int bottom = top + currentFocusView.getHeight();
            int right = left + currentFocusView.getWidth();
            if (!(motionEvent.getX() > (float)left && motionEvent.getX() < (float)right && motionEvent.getY() > (float)top && motionEvent.getY() < (float)bottom)) {
                if (dialogOrActivity instanceof Dialog) {
                    BGAKeyboardUtil.closeKeyboard((Dialog)dialogOrActivity);
                } else if (dialogOrActivity instanceof Activity) {
                    BGAKeyboardUtil.closeKeyboard((Activity)dialogOrActivity);
                }
            }
        }
    }
}

