/*
 * Decompiled with CFR 0.152.
 */
package cn.bingoogolapple.swipebacklayout;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.DrawableRes;
import android.support.annotation.FloatRange;
import android.view.View;
import cn.bingoogolapple.swipebacklayout.BGAKeyboardUtil;
import cn.bingoogolapple.swipebacklayout.BGASwipeBackLayout;
import cn.bingoogolapple.swipebacklayout.BGASwipeBackManager;
import cn.bingoogolapple.swipebacklayout.R;
import java.util.List;

public class BGASwipeBackHelper {
    private Activity mActivity;
    private Delegate mDelegate;
    private BGASwipeBackLayout mSwipeBackLayout;

    public static void init(Application application, List<Class<? extends View>> problemViewClassList) {
        BGASwipeBackManager.getInstance().init(application, problemViewClassList);
    }

    public BGASwipeBackHelper(Activity activity, Delegate delegate) {
        this.mActivity = activity;
        this.mDelegate = delegate;
        this.initSwipeBackFinish();
    }

    private void initSwipeBackFinish() {
        if (this.mDelegate.isSupportSwipeBack()) {
            this.mSwipeBackLayout = new BGASwipeBackLayout((Context)this.mActivity);
            this.mSwipeBackLayout.attachToActivity(this.mActivity);
            this.mSwipeBackLayout.setPanelSlideListener(new BGASwipeBackLayout.PanelSlideListener(){

                @Override
                public void onPanelSlide(View panel, float slideOffset) {
                    if ((double)slideOffset < 0.03) {
                        BGAKeyboardUtil.closeKeyboard(BGASwipeBackHelper.this.mActivity);
                    }
                    BGASwipeBackHelper.this.mDelegate.onSwipeBackLayoutSlide(slideOffset);
                }

                @Override
                public void onPanelOpened(View panel) {
                    BGASwipeBackHelper.this.mDelegate.onSwipeBackLayoutExecuted();
                }

                @Override
                public void onPanelClosed(View panel) {
                    BGASwipeBackHelper.this.mDelegate.onSwipeBackLayoutCancel();
                }
            });
        }
    }

    public BGASwipeBackHelper setSwipeBackEnable(boolean swipeBackEnable) {
        if (this.mSwipeBackLayout != null) {
            this.mSwipeBackLayout.setSwipeBackEnable(swipeBackEnable);
        }
        return this;
    }

    public BGASwipeBackHelper setIsOnlyTrackingLeftEdge(boolean isOnlyTrackingLeftEdge) {
        if (this.mSwipeBackLayout != null) {
            this.mSwipeBackLayout.setIsOnlyTrackingLeftEdge(isOnlyTrackingLeftEdge);
        }
        return this;
    }

    public BGASwipeBackHelper setIsWeChatStyle(boolean isWeChatStyle) {
        if (this.mSwipeBackLayout != null) {
            this.mSwipeBackLayout.setIsWeChatStyle(isWeChatStyle);
        }
        return this;
    }

    public BGASwipeBackHelper setShadowResId(@DrawableRes int shadowResId) {
        if (this.mSwipeBackLayout != null) {
            this.mSwipeBackLayout.setShadowResId(shadowResId);
        }
        return this;
    }

    public BGASwipeBackHelper setIsNeedShowShadow(boolean isNeedShowShadow) {
        if (this.mSwipeBackLayout != null) {
            this.mSwipeBackLayout.setIsNeedShowShadow(isNeedShowShadow);
        }
        return this;
    }

    public BGASwipeBackHelper setIsShadowAlphaGradient(boolean isShadowAlphaGradient) {
        if (this.mSwipeBackLayout != null) {
            this.mSwipeBackLayout.setIsShadowAlphaGradient(isShadowAlphaGradient);
        }
        return this;
    }

    public BGASwipeBackHelper setSwipeBackThreshold(@FloatRange(from=0.0, to=1.0) float threshold) {
        if (this.mSwipeBackLayout != null) {
            this.mSwipeBackLayout.setSwipeBackThreshold(threshold);
        }
        return this;
    }

    public BGASwipeBackHelper setIsNavigationBarOverlap(boolean overlap) {
        if (this.mSwipeBackLayout != null) {
            this.mSwipeBackLayout.setIsNavigationBarOverlap(overlap);
        }
        return this;
    }

    public boolean isSliding() {
        if (this.mSwipeBackLayout != null) {
            return this.mSwipeBackLayout.isSliding();
        }
        return false;
    }

    public void executeForwardAnim() {
        BGASwipeBackHelper.executeForwardAnim(this.mActivity);
    }

    public void executeBackwardAnim() {
        BGASwipeBackHelper.executeBackwardAnim(this.mActivity);
    }

    public void executeSwipeBackAnim() {
        BGASwipeBackHelper.executeSwipeBackAnim(this.mActivity);
    }

    public static void executeForwardAnim(Activity activity) {
        activity.overridePendingTransition(R.anim.bga_sbl_activity_forward_enter, R.anim.bga_sbl_activity_forward_exit);
    }

    public static void executeBackwardAnim(Activity activity) {
        activity.overridePendingTransition(R.anim.bga_sbl_activity_backward_enter, R.anim.bga_sbl_activity_backward_exit);
    }

    public static void executeSwipeBackAnim(Activity activity) {
        activity.overridePendingTransition(R.anim.bga_sbl_activity_swipeback_enter, R.anim.bga_sbl_activity_swipeback_exit);
    }

    public void forwardAndFinish(Class<?> cls) {
        this.forward(cls);
        this.mActivity.finish();
    }

    public void forward(Class<?> cls) {
        BGAKeyboardUtil.closeKeyboard(this.mActivity);
        this.mActivity.startActivity(new Intent((Context)this.mActivity, cls));
        this.executeForwardAnim();
    }

    public void forward(Class<?> cls, int requestCode) {
        this.forward(new Intent((Context)this.mActivity, cls), requestCode);
    }

    public void forwardAndFinish(Intent intent) {
        this.forward(intent);
        this.mActivity.finish();
    }

    public void forward(Intent intent) {
        BGAKeyboardUtil.closeKeyboard(this.mActivity);
        this.mActivity.startActivity(intent);
        this.executeForwardAnim();
    }

    public void forward(Intent intent, int requestCode) {
        BGAKeyboardUtil.closeKeyboard(this.mActivity);
        this.mActivity.startActivityForResult(intent, requestCode);
        this.executeForwardAnim();
    }

    public void backward() {
        BGAKeyboardUtil.closeKeyboard(this.mActivity);
        this.mActivity.finish();
        this.executeBackwardAnim();
    }

    public void swipeBackward() {
        BGAKeyboardUtil.closeKeyboard(this.mActivity);
        this.mActivity.finish();
        this.executeSwipeBackAnim();
    }

    public void backwardAndFinish(Class<?> cls) {
        BGAKeyboardUtil.closeKeyboard(this.mActivity);
        this.mActivity.startActivity(new Intent((Context)this.mActivity, cls));
        this.mActivity.finish();
        this.executeBackwardAnim();
    }

    public static interface Delegate {
        public boolean isSupportSwipeBack();

        public void onSwipeBackLayoutSlide(float var1);

        public void onSwipeBackLayoutCancel();

        public void onSwipeBackLayoutExecuted();
    }
}

