/*
 * Decompiled with CFR 0.152.
 */
package cn.carbs.android.indicatorview.library;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.Rect;
import android.support.v4.view.ViewPager;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.Transformation;
import cn.carbs.android.indicatorview.library.R;
import java.lang.reflect.Field;

public class IndicatorView
extends View {
    private static final String TAG = "IndicatorView";
    private static final int DEFAULT_INDICATOR_COLOR = -13399809;
    private static final int DEFAULT_INDICATOR_DURATION = 200;
    private static final int DEFAULT_INDICATOR_SELECTED_INDEX = 0;
    private static final int DEFAULT_INDICATOR_TEXT_COLOR_NORMAL = 0x55555555;
    private static final int DEFAULT_INDICATOR_TEXT_COLOR_SELECTED = -13399809;
    private static final int DEFAULT_INDICATOR_TEXT_SIZE_SP = 14;
    private static final int DEFAULT_INDICATOR_HEIGHT_DP = 3;
    private static final int DEFAULT_INDICATOR_GAP_DP = 24;
    private static final int DEFAULT_INDICATOR_EXTRA_DP = 4;
    private static final int DEFAULT_INDICATOR_BG_TOUCHED_COLOR = 0x22666666;
    private static final boolean DEFAULT_INDICATOR_COLOR_GRADIENT = false;
    private static final boolean DEFAULT_EVEN = false;
    private static final boolean DEFAULT_VIEW_PAGER_ANIM = true;
    private int mIndicatorColor = -13399809;
    private int mIndicatorColorStart = -13399809;
    private int mIndicatorColorEnd = -13399809;
    private int mIndicatorDuration = 200;
    private int mIndicatorSelectedIndex = 0;
    private int mTextColorNormal = 0x55555555;
    private int mTextColorSelected = -13399809;
    private int mBgTouchedColor = 0x22666666;
    private boolean mEven = false;
    private boolean mIndicatorColorGradient = false;
    private boolean mViewPagerAnim = true;
    private int mIndicatorTextSize;
    private float mIndicatorSelectedIndexOffsetRation;
    private float textCenterYOffset;
    private CharSequence[] mIndicatorTextArray;
    private int[] mIndicatorTextArrayWidths;
    private Point[] mIndicatorTextArrayCenterPoints;
    private Paint mPaintIndicator = new Paint();
    private Paint mPaintText = new Paint();
    private Paint mPaintTouch = new Paint();
    private Rect mRectFIndicator = new Rect();
    private Rect mRectFTouchEffect = new Rect();
    private Point mDestP = new Point();
    private Point mOrigP = new Point();
    private Point mCurrP = new Point();
    private ValueGeneratorAnim mAnim = new ValueGeneratorAnim();
    private ViewPager mViewPager;
    private int mIndicatorGap;
    private int mIndicatorExtra;
    private int mIndicatorHeight;
    private int mWidth = 0;
    private int mHeight = 0;
    private int mNetWidth = 0;
    private int mPreTouchedIndex = -1;
    private int mCurTouchedIndex = -1;
    private OnIndicatorChangedListener mOnIndicatorChangedListener;

    public IndicatorView(Context context) {
        super(context);
        this.init();
    }

    public IndicatorView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initAttr(context, attrs);
        this.init();
    }

    public IndicatorView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initAttr(context, attrs);
        this.init();
    }

    private void initAttr(Context context, AttributeSet attrs) {
        if (attrs == null) {
            return;
        }
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.IndicatorView);
        int n = a.getIndexCount();
        for (int i = 0; i < n; ++i) {
            int attr = a.getIndex(i);
            if (attr == R.styleable.IndicatorView_iv_IndicatorColor) {
                this.mIndicatorColor = a.getColor(attr, -13399809);
                continue;
            }
            if (attr == R.styleable.IndicatorView_iv_IndicatorDuration) {
                this.mIndicatorDuration = a.getInt(attr, 200);
                continue;
            }
            if (attr == R.styleable.IndicatorView_iv_IndicatorSelectedIndex) {
                this.mIndicatorSelectedIndex = a.getInt(attr, 0);
                continue;
            }
            if (attr == R.styleable.IndicatorView_iv_IndicatorColorStart) {
                this.mIndicatorColorStart = a.getColor(attr, -13399809);
                continue;
            }
            if (attr == R.styleable.IndicatorView_iv_IndicatorColorEnd) {
                this.mIndicatorColorEnd = a.getColor(attr, -13399809);
                continue;
            }
            if (attr == R.styleable.IndicatorView_iv_IndicatorColorGradient) {
                this.mIndicatorColorGradient = a.getBoolean(attr, false);
                continue;
            }
            if (attr == R.styleable.IndicatorView_iv_IndicatorTextColorNormal) {
                this.mTextColorNormal = a.getColor(attr, 0x55555555);
                continue;
            }
            if (attr == R.styleable.IndicatorView_iv_IndicatorTextColorSelected) {
                this.mTextColorSelected = a.getColor(attr, -13399809);
                continue;
            }
            if (attr == R.styleable.IndicatorView_iv_IndicatorTextSize) {
                this.mIndicatorTextSize = a.getDimensionPixelSize(attr, this.sp2px(this.getContext(), 14.0f));
                continue;
            }
            if (attr == R.styleable.IndicatorView_iv_IndicatorTextArray) {
                this.mIndicatorTextArray = a.getTextArray(attr);
                continue;
            }
            if (attr == R.styleable.IndicatorView_iv_IndicatorHeight) {
                this.mIndicatorHeight = a.getDimensionPixelSize(attr, this.dp2px(this.getContext(), 3.0f));
                continue;
            }
            if (attr == R.styleable.IndicatorView_iv_IndicatorTextGap) {
                this.mIndicatorGap = a.getDimensionPixelSize(attr, this.dp2px(this.getContext(), 24.0f));
                continue;
            }
            if (attr == R.styleable.IndicatorView_iv_IndicatorLengthExtra) {
                this.mIndicatorExtra = a.getDimensionPixelSize(attr, this.dp2px(this.getContext(), 4.0f));
                continue;
            }
            if (attr == R.styleable.IndicatorView_iv_IndicatorEven) {
                this.mEven = a.getBoolean(attr, false);
                continue;
            }
            if (attr == R.styleable.IndicatorView_iv_IndicatorBgTouchedColor) {
                this.mBgTouchedColor = a.getColor(attr, 0x22666666);
                continue;
            }
            if (attr != R.styleable.IndicatorView_iv_IndicatorViewPagerAnim) continue;
            this.mViewPagerAnim = a.getBoolean(attr, true);
        }
        a.recycle();
    }

    private void init() {
        if (this.mIndicatorTextSize == 0) {
            this.mIndicatorTextSize = this.sp2px(this.getContext(), 14.0f);
        }
        if (this.mIndicatorHeight == 0) {
            this.mIndicatorHeight = this.dp2px(this.getContext(), 3.0f);
        }
        if (this.mIndicatorGap == 0) {
            this.mIndicatorGap = this.dp2px(this.getContext(), 24.0f);
        }
        this.mPaintIndicator.setAntiAlias(true);
        this.mPaintIndicator.setColor(this.mIndicatorColor);
        this.mPaintIndicator.setStyle(Paint.Style.FILL);
        this.mPaintTouch.setAntiAlias(true);
        this.mPaintTouch.setColor(this.mBgTouchedColor);
        this.mPaintTouch.setStyle(Paint.Style.FILL);
        this.mPaintText.setAntiAlias(true);
        this.mPaintText.setTextAlign(Paint.Align.CENTER);
        this.mPaintText.setTextSize((float)this.mIndicatorTextSize);
        this.textCenterYOffset = this.getTextCenterYOffset(this.mPaintText.getFontMetrics());
        this.setClickable(true);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mWidth = w;
        this.mHeight = h;
        this.mNetWidth = this.mWidth - this.getPaddingLeft() - this.getPaddingRight();
        this.refreshTextArrayWidthsAndCenterPoints();
        this.refreshCurrPointByIndexAndOffsetRation(this.mIndicatorSelectedIndex, 0.0f);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (!this.refresh()) {
            return;
        }
        this.drawTouchedEffect(canvas);
        this.drawIndicator(canvas);
        this.drawText(canvas);
    }

    public void setPadding(int left, int top, int right, int bottom) {
        super.setPadding(left, top, right, bottom);
        this.mNetWidth = this.mWidth - left - right;
    }

    public boolean onTouchEvent(MotionEvent event) {
        this.mPreTouchedIndex = this.mCurTouchedIndex;
        switch (event.getAction()) {
            case 0: {
                this.mCurTouchedIndex = this.getTouchedIndex(event.getX(), event.getY());
                if (this.mPreTouchedIndex == this.mCurTouchedIndex) break;
                this.invalidate();
                break;
            }
            case 2: {
                this.mCurTouchedIndex = this.getTouchedIndex(event.getX(), event.getY());
                if (this.mPreTouchedIndex == this.mCurTouchedIndex) break;
                this.invalidate();
                break;
            }
            case 1: {
                this.mCurTouchedIndex = this.getTouchedIndex(event.getX(), event.getY());
                if (this.mCurTouchedIndex != -1 && this.mOnIndicatorChangedListener != null && this.mIndicatorSelectedIndex != this.mCurTouchedIndex) {
                    this.mOnIndicatorChangedListener.onIndicatorChanged(this.mIndicatorSelectedIndex, this.mCurTouchedIndex);
                }
                if (this.checkViewPagerOnPageChangeListener(this.mViewPager)) {
                    this.mViewPager.setCurrentItem(this.mCurTouchedIndex, this.mViewPagerAnim);
                } else {
                    this.setIndex(this.mCurTouchedIndex);
                }
                this.invalidate();
                this.mCurTouchedIndex = -1;
                break;
            }
            case 3: {
                this.mCurTouchedIndex = -1;
                this.invalidate();
            }
        }
        return super.onTouchEvent(event);
    }

    private void refreshCurrColorByCurrPoint() {
        if (this.mIndicatorColorGradient && this.mIndicatorTextArrayCenterPoints != null && this.mIndicatorTextArrayCenterPoints.length > 1) {
            float fraction = (float)(this.mCurrP.x - this.mIndicatorTextArrayCenterPoints[0].x) / (float)(this.mIndicatorTextArrayCenterPoints[this.mIndicatorTextArrayCenterPoints.length - 1].x - this.mIndicatorTextArrayCenterPoints[0].x);
            this.mIndicatorColor = this.getEvaluateColor(fraction, this.mIndicatorColorStart, this.mIndicatorColorEnd);
        }
    }

    private float getTextCenterYOffset(Paint.FontMetrics fontMetrics) {
        if (fontMetrics == null) {
            return 0.0f;
        }
        return Math.abs(fontMetrics.top + fontMetrics.bottom) / 2.0f;
    }

    private void refreshTextArrayWidthsAndCenterPoints() {
        if (this.mIndicatorTextArray == null) {
            this.mIndicatorTextArrayWidths = null;
            this.mIndicatorTextArrayCenterPoints = null;
        } else {
            this.mIndicatorTextArrayWidths = new int[this.mIndicatorTextArray.length];
            this.mIndicatorTextArrayCenterPoints = new Point[this.mIndicatorTextArray.length];
            int centerY = (this.mHeight - this.mIndicatorHeight) / 2;
            if (this.mEven) {
                for (int i = 0; i < this.mIndicatorTextArray.length; ++i) {
                    this.mIndicatorTextArrayWidths[i] = (this.mNetWidth - 2 * this.mIndicatorExtra) / this.mIndicatorTextArray.length;
                    this.mIndicatorTextArrayCenterPoints[i] = new Point((int)((float)(this.getPaddingLeft() + this.mIndicatorExtra) + (float)(this.mNetWidth - 2 * this.mIndicatorExtra) * ((float)i + 0.5f) / (float)this.mIndicatorTextArray.length), centerY);
                }
            } else {
                for (int i = 0; i < this.mIndicatorTextArray.length; ++i) {
                    this.mIndicatorTextArrayWidths[i] = this.getTextWidth(this.mIndicatorTextArray[i].toString(), this.mPaintText);
                    this.mIndicatorTextArrayCenterPoints[i] = i == 0 ? new Point((int)((float)this.getPaddingLeft() + (float)this.mIndicatorTextArrayWidths[i] / 2.0f + (float)(this.mIndicatorExtra > 0 ? this.mIndicatorExtra : 0)), centerY) : new Point(this.mIndicatorTextArrayCenterPoints[i - 1].x + this.mIndicatorTextArrayWidths[i - 1] / 2 + this.mIndicatorGap + this.mIndicatorTextArrayWidths[i] / 2, centerY);
                }
            }
        }
    }

    private void refreshCurrPointByIndexAndOffsetRation(int index, float offsetRation) {
        if (this.mIndicatorTextArray == null) {
            return;
        }
        if (index < 0 || index > this.mIndicatorTextArray.length - 1) {
            throw new IllegalArgumentException("index should be larger than -1 and less than (mIndicatorTextArray.length), now index is " + index);
        }
        if (offsetRation < 0.0f || offsetRation >= 1.0f) {
            throw new IllegalArgumentException("offsetRation should be in [0,1), now offsetRation is " + index);
        }
        if (index != this.mIndicatorTextArray.length - 1) {
            this.mCurrP.x = (int)((float)this.mIndicatorTextArrayCenterPoints[index].x + offsetRation * (float)(this.mIndicatorTextArrayCenterPoints[index + 1].x - this.mIndicatorTextArrayCenterPoints[index].x));
            this.mCurrP.y = this.mIndicatorTextArrayCenterPoints[index].y;
        } else {
            this.mCurrP.x = this.mIndicatorTextArrayCenterPoints[index].x;
            this.mCurrP.y = this.mIndicatorTextArrayCenterPoints[index].y;
            offsetRation = 0.0f;
        }
        this.mIndicatorSelectedIndex = index;
        this.mIndicatorSelectedIndexOffsetRation = offsetRation;
    }

    private boolean refresh() {
        if (this.mIndicatorTextArray == null || this.mIndicatorTextArray.length == 0 || this.mIndicatorTextArrayCenterPoints == null || this.mIndicatorTextArrayCenterPoints.length == 0) {
            return false;
        }
        this.refreshCurrColorByCurrPoint();
        this.refreshSpringIndicatorRectByCurrPoint();
        return true;
    }

    private void drawIndicator(Canvas canvas) {
        this.mPaintIndicator.setColor(this.mIndicatorColor);
        canvas.drawRect(this.mRectFIndicator, this.mPaintIndicator);
    }

    private void drawText(Canvas canvas) {
        for (int i = 0; i < this.mIndicatorTextArray.length; ++i) {
            if (this.mIndicatorSelectedIndex == i) {
                this.mPaintText.setColor(this.getEvaluateColor(this.mIndicatorSelectedIndexOffsetRation, this.mIndicatorColorGradient ? this.mIndicatorColor : this.mTextColorSelected, this.mTextColorNormal));
            } else if (this.mIndicatorSelectedIndex == i - 1) {
                this.mPaintText.setColor(this.getEvaluateColor(this.mIndicatorSelectedIndexOffsetRation, this.mTextColorNormal, this.mIndicatorColorGradient ? this.mIndicatorColor : this.mTextColorSelected));
            } else {
                this.mPaintText.setColor(this.mTextColorNormal);
            }
            canvas.drawText(this.mIndicatorTextArray[i].toString(), (float)this.mIndicatorTextArrayCenterPoints[i].x, (float)this.mIndicatorTextArrayCenterPoints[i].y + this.textCenterYOffset, this.mPaintText);
        }
    }

    private void drawTouchedEffect(Canvas canvas) {
        if (this.mCurTouchedIndex > -1 && this.mCurTouchedIndex < this.mIndicatorTextArrayCenterPoints.length) {
            this.mRectFTouchEffect.left = this.mIndicatorTextArrayCenterPoints[this.mCurTouchedIndex].x - (this.mIndicatorTextArrayWidths[this.mCurTouchedIndex] / 2 + this.mIndicatorExtra);
            this.mRectFTouchEffect.right = this.mIndicatorTextArrayCenterPoints[this.mCurTouchedIndex].x + (this.mIndicatorTextArrayWidths[this.mCurTouchedIndex] / 2 + this.mIndicatorExtra);
            this.mRectFTouchEffect.top = 0;
            this.mRectFTouchEffect.bottom = this.mHeight;
            canvas.drawRect(this.mRectFTouchEffect, this.mPaintTouch);
        }
    }

    private void refreshSpringIndicatorRectByCurrPoint() {
        if (this.mIndicatorTextArrayCenterPoints == null) {
            return;
        }
        for (int i = 0; i < this.mIndicatorTextArrayCenterPoints.length - 1; ++i) {
            if (this.mIndicatorTextArrayCenterPoints[i].x > this.mCurrP.x || this.mCurrP.x > this.mIndicatorTextArrayCenterPoints[i + 1].x) continue;
            float offsetRation = (float)(this.mCurrP.x - this.mIndicatorTextArrayCenterPoints[i].x) / (float)(this.mIndicatorTextArrayCenterPoints[i + 1].x - this.mIndicatorTextArrayCenterPoints[i].x);
            int springHalfWidth = (int)((float)this.mIndicatorExtra + (float)this.mIndicatorTextArrayWidths[i] / 2.0f + (float)(this.mIndicatorTextArrayWidths[i + 1] - this.mIndicatorTextArrayWidths[i]) * offsetRation / 2.0f);
            this.mRectFIndicator.left = this.mCurrP.x - springHalfWidth;
            this.mRectFIndicator.right = this.mCurrP.x + springHalfWidth;
            this.mRectFIndicator.top = this.mHeight - this.mIndicatorHeight;
            this.mRectFIndicator.bottom = this.mHeight;
            if (offsetRation < 1.0f) {
                this.mIndicatorSelectedIndex = i;
                this.mIndicatorSelectedIndexOffsetRation = offsetRation;
            } else {
                this.mIndicatorSelectedIndex = i + 1;
                this.mIndicatorSelectedIndexOffsetRation = 0.0f;
            }
            return;
        }
        Log.d((String)TAG, (String)"refreshSpringIndicatorRectByCurrPoint() wrong");
    }

    public int getItemCount() {
        if (this.mIndicatorTextArray == null) {
            return 0;
        }
        return this.mIndicatorTextArray.length;
    }

    public void increaseSelectedIndex() {
        Object[] currState = this.getCurrIndexAndOffset();
        if (currState == null) {
            throw new IllegalArgumentException("increaseSelectedIndex wrong! currState == null");
        }
        this.setIndex(((Integer)currState[0] + 1) % this.mIndicatorTextArray.length);
    }

    public void increaseSelectedIndexWithViewPager() {
        Object[] currState = this.getCurrIndexAndOffset();
        if (currState == null) {
            throw new IllegalArgumentException("increaseSelectedIndex wrong! currState == null");
        }
        this.setIndexWithViewPager(((Integer)currState[0] + 1) % this.mIndicatorTextArray.length);
    }

    public void decreaseSelectedIndex() {
        Object[] currState = this.getCurrIndexAndOffset();
        if (currState == null) {
            throw new IllegalArgumentException("decreaseSelectedIndex wrong! currState == null");
        }
        this.setIndex(((Integer)currState[0] - 1) % this.mIndicatorTextArray.length);
    }

    public void decreaseSelectedIndexWithViewPager() {
        Object[] currState = this.getCurrIndexAndOffset();
        if (currState == null) {
            throw new IllegalArgumentException("decreaseSelectedIndex wrong! currState == null");
        }
        this.setIndexWithViewPager(((Integer)currState[0] - 1) % this.mIndicatorTextArray.length);
    }

    public void setIndexWithViewPager(int indexDest) {
        if (this.checkViewPagerOnPageChangeListener(this.mViewPager)) {
            this.mViewPager.setCurrentItem(indexDest, this.mViewPagerAnim);
        } else {
            this.setIndex(indexDest);
            this.invalidate();
        }
    }

    public void setIndex(int indexDest) {
        if (this.mIndicatorTextArrayCenterPoints == null) {
            throw new IllegalArgumentException("you should set textarray first");
        }
        if (indexDest < 0 || indexDest > this.mIndicatorTextArrayCenterPoints.length - 1) {
            throw new IllegalArgumentException("indexDest should less than (mIndicatorTextArrayCenterPoints.length - 1) and larger than -1, now indexDest is " + indexDest);
        }
        int destCenterX = this.mIndicatorTextArrayCenterPoints[indexDest].x;
        int destCenterY = this.mIndicatorTextArrayCenterPoints[indexDest].y;
        this.mAnim.cancel();
        this.mOrigP.set(this.mCurrP.x, this.mCurrP.y);
        this.mDestP.set(destCenterX, destCenterY);
        if (this.mOrigP.x == this.mDestP.x && this.mOrigP.y == this.mDestP.y) {
            return;
        }
        this.startAnim(this.mOrigP, this.mDestP, this.mCurrP);
    }

    public void setViewPager(ViewPager viewPager) {
        this.mViewPager = viewPager;
        if (viewPager != null) {
            viewPager.setOnPageChangeListener((ViewPager.OnPageChangeListener)new InternalViewPagerListener());
        }
    }

    private boolean checkViewPagerOnPageChangeListener(ViewPager viewPager) {
        if (viewPager == null) {
            return false;
        }
        try {
            Field field = ViewPager.class.getDeclaredField("mOnPageChangeListener");
            if (field == null) {
                return false;
            }
            field.setAccessible(true);
            Object o = field.get(viewPager);
            if (o != null && o instanceof InternalViewPagerListener) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public Object[] getCurrIndexAndOffset() {
        if (this.mIndicatorTextArray == null) {
            return null;
        }
        Object[] ret = new Object[2];
        for (int i = 0; i < this.mIndicatorTextArray.length - 1; ++i) {
            if (this.mIndicatorTextArrayCenterPoints[i].x <= this.mCurrP.x && this.mCurrP.x < this.mIndicatorTextArrayCenterPoints[i + 1].x) {
                float rationOffset = (this.mCurrP.x - this.mIndicatorTextArrayCenterPoints[i].x) / (this.mIndicatorTextArrayCenterPoints[i + 1].x - this.mIndicatorTextArrayCenterPoints[i].x);
                ret[0] = i;
                ret[1] = Float.valueOf(rationOffset);
                return ret;
            }
            if (this.mCurrP.x != this.mIndicatorTextArrayCenterPoints[i + 1].x) continue;
            ret[0] = i + 1;
            ret[1] = Float.valueOf(0.0f);
            return ret;
        }
        if (this.mCurrP.x < this.mIndicatorTextArrayCenterPoints[0].x) {
            ret[0] = 0;
            ret[1] = Float.valueOf(0.0f);
            return ret;
        }
        if (this.mCurrP.x > this.mIndicatorTextArrayCenterPoints[this.mIndicatorTextArray.length - 1].x) {
            ret[0] = this.mIndicatorTextArray.length - 1;
            ret[1] = Float.valueOf(0.0f);
            return ret;
        }
        return null;
    }

    private void startAnim(final Point origP, final Point destP, final Point currP) {
        this.mAnim.reset();
        this.mAnim.setInterpolator((Interpolator)new AccelerateDecelerateInterpolator());
        this.mAnim.setDuration(this.mIndicatorDuration);
        InterpolatedTimeCallback callback = new InterpolatedTimeCallback(){

            @Override
            public void onTimeUpdate(float interpolatedTime) {
                IndicatorView.this.getCurrPoint(interpolatedTime, origP, destP, currP);
                IndicatorView.this.invalidate();
            }
        };
        this.mAnim.setCallback(callback);
        this.startAnimation(this.mAnim);
    }

    private void getCurrPoint(float fraction, Point origP, Point destP, Point currP) {
        currP.x = (int)((float)origP.x + (float)(destP.x - origP.x) * fraction);
        currP.y = (int)((float)origP.y + (float)(destP.y - origP.y) * fraction);
    }

    private int getEvaluateColor(float fraction, int startColor, int endColor) {
        int sA = (startColor & 0xFF000000) >>> 24;
        int sR = (startColor & 0xFF0000) >>> 16;
        int sG = (startColor & 0xFF00) >>> 8;
        int sB = (startColor & 0xFF) >>> 0;
        int eA = (endColor & 0xFF000000) >>> 24;
        int eR = (endColor & 0xFF0000) >>> 16;
        int eG = (endColor & 0xFF00) >>> 8;
        int eB = (endColor & 0xFF) >>> 0;
        int a = (int)((float)sA + (float)(eA - sA) * fraction);
        int r = (int)((float)sR + (float)(eR - sR) * fraction);
        int g = (int)((float)sG + (float)(eG - sG) * fraction);
        int b = (int)((float)sB + (float)(eB - sB) * fraction);
        return a << 24 | r << 16 | g << 8 | b;
    }

    private int sp2px(Context context, float spValue) {
        float fontScale = context.getResources().getDisplayMetrics().scaledDensity;
        return (int)(spValue * fontScale + 0.5f);
    }

    private int dp2px(Context context, float spValue) {
        float fontScale = context.getResources().getDisplayMetrics().density;
        return (int)(spValue * fontScale + 0.5f);
    }

    private int getTextWidth(String text, Paint paint) {
        if (!TextUtils.isEmpty((CharSequence)text)) {
            return (int)(paint.measureText(text) + 0.5f);
        }
        return -1;
    }

    public void setOnIndicatorChangedListener(OnIndicatorChangedListener listener) {
        this.mOnIndicatorChangedListener = listener;
    }

    private int getTouchedIndex(float x, float y) {
        if (this.mIndicatorTextArrayCenterPoints != null) {
            for (int i = 0; i < this.mIndicatorTextArrayCenterPoints.length; ++i) {
                if (!((float)(this.mIndicatorTextArrayCenterPoints[i].x - (this.mIndicatorTextArrayWidths[i] + this.mIndicatorGap) / 2) <= x) || !(x < (float)(this.mIndicatorTextArrayCenterPoints[i].x + (this.mIndicatorTextArrayWidths[i] + this.mIndicatorGap) / 2))) continue;
                return i;
            }
        }
        return -1;
    }

    public static interface OnIndicatorChangedListener {
        public void onIndicatorChanged(int var1, int var2);
    }

    static interface InterpolatedTimeCallback {
        public void onTimeUpdate(float var1);
    }

    class ValueGeneratorAnim
    extends Animation {
        private InterpolatedTimeCallback interpolatedTimeCallback;

        ValueGeneratorAnim() {
        }

        protected void applyTransformation(float interpolatedTime, Transformation t) {
            if (this.interpolatedTimeCallback != null) {
                this.interpolatedTimeCallback.onTimeUpdate(interpolatedTime);
            }
        }

        public void setCallback(InterpolatedTimeCallback interpolatedTimeCallback) {
            this.interpolatedTimeCallback = interpolatedTimeCallback;
        }
    }

    private class InternalViewPagerListener
    implements ViewPager.OnPageChangeListener {
        private InternalViewPagerListener() {
        }

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            IndicatorView.this.refreshCurrPointByIndexAndOffsetRation(position, positionOffset);
            IndicatorView.this.invalidate();
        }

        public void onPageScrollStateChanged(int state) {
        }

        public void onPageSelected(int position) {
        }
    }
}

