/*
 * Decompiled with CFR 0.152.
 */
package cn.carbs.android.indicatorview.library;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.Transformation;
import cn.carbs.android.indicatorview.library.R;

public class SimpleIndicatorView
extends View {
    private static final int DEFAULT_INDICATOR_COLOR = -13399809;
    private static final int DEFAULT_INDICATOR_LINE_COLOR = -5592406;
    private static final int DEFAULT_INDICATOR_COUNT = 2;
    private static final int DEFAULT_INDICATOR_DURATION = 200;
    private static final int DEFAULT_INDICATOR_INDEX = 0;
    private static final float DEFAULT_INDICATOR_WIDTH_RATION = 1.0f;
    private static final boolean DEFAULT_INDICATOR_LINE_SHOW = true;
    private static final int DEFAULT_INDICATOR_LINE_THICKNESS_PX = 1;
    private static final boolean DEFAULT_INDICATOR_COLOR_GRADIENT = false;
    private static final int ORIENTATION_H = 0;
    private static final int ORIENTATION_V = 1;
    private static final int LINE_SHOW_POSITION_START = 0;
    private static final int LINE_SHOW_POSITION_END = 1;
    private int mIndicatorColor = -13399809;
    private int mIndicatorColorStart = -13399809;
    private int mIndicatorColorEnd = -13399809;
    private boolean mIndicatorColorGradient = false;
    private int mIndicatorCount = 2;
    private int mIndicatorOrientation = 0;
    private int mIndicatorDuration = 200;
    private int mIndicatorIndex = 0;
    private float mIndicatorWidthRation = 1.0f;
    private boolean mIndicatorLineShow = true;
    private int mIndicatorLineThickness = 1;
    private int mIndicatorLineShowPosition = 1;
    private int mIndicatorLineColor = -5592406;
    private Paint mPaintIndicator = new Paint();
    private Paint mPaintLine = new Paint();
    private ValueGeneratorAnim mAnim = new ValueGeneratorAnim();
    private float mWidth = 0.0f;
    private float mHeight = 0.0f;
    private float mItemWidth = 0.0f;
    private float mItemHeight = 0.0f;
    private RectF mRectFFrame = new RectF();
    private RectF mRectFIndicator = new RectF();
    private RectF mRectFLine = new RectF();
    private PointF mDestP = new PointF();
    private PointF mOrigP = new PointF();
    private PointF mCurrP = new PointF();

    public SimpleIndicatorView(Context context) {
        super(context);
        this.init();
    }

    public SimpleIndicatorView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initAttr(context, attrs);
        this.init();
    }

    public SimpleIndicatorView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initAttr(context, attrs);
        this.init();
    }

    private void initAttr(Context context, AttributeSet attrs) {
        if (attrs == null) {
            return;
        }
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.SimpleIndicatorView);
        int n = a.getIndexCount();
        for (int i = 0; i < n; ++i) {
            int attr = a.getIndex(i);
            if (attr == R.styleable.SimpleIndicatorView_iv_SimpleIndicatorColor) {
                this.mIndicatorColor = a.getColor(attr, -13399809);
                continue;
            }
            if (attr == R.styleable.SimpleIndicatorView_iv_SimpleIndicatorCount) {
                this.mIndicatorCount = a.getInt(attr, 2);
                continue;
            }
            if (attr == R.styleable.SimpleIndicatorView_iv_SimpleIndicatorWidthRation) {
                this.mIndicatorWidthRation = a.getFloat(attr, 1.0f);
                continue;
            }
            if (attr == R.styleable.SimpleIndicatorView_iv_SimpleIndicatorOrientation) {
                this.mIndicatorOrientation = a.getInt(attr, 0);
                continue;
            }
            if (attr == R.styleable.SimpleIndicatorView_iv_SimpleIndicatorDuration) {
                this.mIndicatorDuration = a.getInt(attr, 200);
                continue;
            }
            if (attr == R.styleable.SimpleIndicatorView_iv_SimpleIndicatorDefaultIndex) {
                this.mIndicatorIndex = a.getInt(attr, 0);
                continue;
            }
            if (attr == R.styleable.SimpleIndicatorView_iv_SimpleIndicatorLineShow) {
                this.mIndicatorLineShow = a.getBoolean(attr, true);
                continue;
            }
            if (attr == R.styleable.SimpleIndicatorView_iv_SimpleIndicatorLinePosition) {
                this.mIndicatorLineShowPosition = a.getInt(attr, 1);
                continue;
            }
            if (attr == R.styleable.SimpleIndicatorView_iv_SimpleIndicatorLineThickness) {
                this.mIndicatorLineThickness = a.getDimensionPixelSize(attr, 1);
                continue;
            }
            if (attr == R.styleable.SimpleIndicatorView_iv_SimpleIndicatorLineColor) {
                this.mIndicatorLineColor = a.getColor(attr, -5592406);
                continue;
            }
            if (attr == R.styleable.SimpleIndicatorView_iv_SimpleIndicatorColorStart) {
                this.mIndicatorColorStart = a.getColor(attr, -5592406);
                continue;
            }
            if (attr == R.styleable.SimpleIndicatorView_iv_SimpleIndicatorColorEnd) {
                this.mIndicatorColorEnd = a.getColor(attr, -5592406);
                continue;
            }
            if (attr != R.styleable.SimpleIndicatorView_iv_SimpleIndicatorColorGradient) continue;
            this.mIndicatorColorGradient = a.getBoolean(attr, false);
        }
        a.recycle();
    }

    public void setIndicatorColor(int color) {
        this.mIndicatorColorGradient = false;
        this.mIndicatorColor = color;
        this.mPaintIndicator.setColor(this.mIndicatorColor);
        this.invalidate();
    }

    public void setIndicatorColor(int colorStart, int colorEnd) {
        this.mIndicatorColorGradient = true;
        this.mIndicatorColorStart = colorStart;
        this.mIndicatorColorEnd = colorEnd;
        this.refreshCurrColor();
        this.mPaintIndicator.setColor(this.mIndicatorColor);
        this.invalidate();
    }

    private int refreshCurrColor() {
        if (this.mIndicatorColorGradient) {
            float fraction = this.mIndicatorOrientation == 0 ? this.mRectFIndicator.left / (this.mWidth - this.mRectFIndicator.width()) : this.mRectFIndicator.top / (this.mHeight - this.mRectFIndicator.height());
            this.mIndicatorColor = this.getEvaluateColor(fraction, this.mIndicatorColorStart, this.mIndicatorColorEnd);
        }
        return this.mIndicatorColor;
    }

    private void init() {
        if (this.mIndicatorWidthRation > 1.0f || this.mIndicatorWidthRation == 0.0f) {
            this.mIndicatorWidthRation = 1.0f;
        }
        this.mPaintIndicator.setAntiAlias(true);
        this.mPaintIndicator.setColor(this.mIndicatorColor);
        this.mPaintIndicator.setStyle(Paint.Style.FILL);
        this.mPaintLine.setAntiAlias(true);
        this.mPaintLine.setColor(this.mIndicatorLineColor);
        this.mPaintLine.setStyle(Paint.Style.FILL);
    }

    private float getTextCenterYOffset(Paint.FontMetrics fontMetrics) {
        if (fontMetrics == null) {
            return 0.0f;
        }
        return Math.abs(fontMetrics.top + fontMetrics.bottom) / 2.0f;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mWidth = w;
        this.mHeight = h;
        this.mRectFFrame.left = 0.0f;
        this.mRectFFrame.top = 0.0f;
        this.mRectFFrame.right = w;
        this.mRectFFrame.bottom = h;
        if (this.mIndicatorOrientation == 0) {
            this.mItemWidth = this.mWidth * this.mIndicatorWidthRation / (float)this.mIndicatorCount;
            float paddingH = this.mWidth * (1.0f - this.mIndicatorWidthRation) / (float)(2 * this.mIndicatorCount);
            this.mRectFIndicator.left = 0.0f;
            this.mRectFIndicator.top = 0.0f;
            this.mRectFIndicator.right = this.mItemWidth;
            this.mRectFIndicator.bottom = h;
            this.mCurrP.x = this.mWidth * (0.5f + (float)this.mIndicatorIndex) / (float)this.mIndicatorCount;
            this.mCurrP.y = this.mHeight / 2.0f;
            if (this.mIndicatorLineShowPosition == 0) {
                this.mRectFLine.left = paddingH;
                this.mRectFLine.top = 0.0f;
                this.mRectFLine.right = this.mWidth - paddingH;
                this.mRectFLine.bottom = this.mIndicatorLineThickness;
            } else {
                this.mRectFLine.left = paddingH;
                this.mRectFLine.top = this.mHeight - (float)this.mIndicatorLineThickness;
                this.mRectFLine.right = this.mWidth - paddingH;
                this.mRectFLine.bottom = this.mHeight;
            }
        } else {
            this.mItemHeight = this.mHeight * this.mIndicatorWidthRation / (float)this.mIndicatorCount;
            float paddingV = this.mHeight * (1.0f - this.mIndicatorWidthRation) / (float)(2 * this.mIndicatorCount);
            this.mRectFIndicator.left = 0.0f;
            this.mRectFIndicator.top = 0.0f;
            this.mRectFIndicator.right = w;
            this.mRectFIndicator.bottom = this.mItemHeight;
            this.mCurrP.x = this.mWidth / 2.0f;
            this.mCurrP.y = this.mHeight * (0.5f + (float)this.mIndicatorIndex) / (float)this.mIndicatorCount;
            if (this.mIndicatorLineShowPosition == 0) {
                this.mRectFLine.left = 0.0f;
                this.mRectFLine.top = paddingV;
                this.mRectFLine.right = this.mIndicatorLineThickness;
                this.mRectFLine.bottom = this.mHeight - paddingV;
            } else {
                this.mRectFLine.left = this.mWidth - (float)this.mIndicatorLineThickness;
                this.mRectFLine.top = paddingV;
                this.mRectFLine.right = this.mWidth;
                this.mRectFLine.bottom = this.mHeight - paddingV;
            }
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.drawIndicator(canvas);
        this.drawHintLine(canvas);
    }

    private void drawIndicator(Canvas canvas) {
        this.mRectFIndicator.offsetTo(this.mCurrP.x - this.mRectFIndicator.width() / 2.0f, this.mCurrP.y - this.mRectFIndicator.height() / 2.0f);
        this.mPaintIndicator.setColor(this.refreshCurrColor());
        canvas.drawRect(this.mRectFIndicator, this.mPaintIndicator);
    }

    private void drawHintLine(Canvas canvas) {
        if (this.mIndicatorLineShow) {
            canvas.drawRect(this.mRectFLine, this.mPaintLine);
        }
    }

    public void setIndex(int indexDest) {
        float destY;
        float destX;
        if (indexDest < 0 || indexDest > this.mIndicatorCount - 1) {
            throw new IllegalArgumentException("indexDest should less than (mIndicatorCount) and larger than -1, now indexDest is " + indexDest);
        }
        if (this.mIndicatorOrientation == 0) {
            destX = this.mWidth * (0.5f + (float)indexDest) / (float)this.mIndicatorCount;
            destY = this.mHeight / 2.0f;
        } else {
            destX = this.mWidth / 2.0f;
            destY = this.mHeight * (0.5f + (float)indexDest) / (float)this.mIndicatorCount;
        }
        this.mAnim.cancel();
        this.mOrigP.set(this.mCurrP);
        this.mDestP.set(destX, destY);
        if (this.mOrigP.x == this.mDestP.x && this.mOrigP.y == this.mDestP.y) {
            return;
        }
        this.startAnim(this.mOrigP, this.mDestP, this.mCurrP);
    }

    private void startAnim(final PointF origP, final PointF destP, final PointF currP) {
        this.mAnim.reset();
        this.mAnim.setInterpolator((Interpolator)new AccelerateDecelerateInterpolator());
        this.mAnim.setDuration(this.mIndicatorDuration);
        InterpolatedTimeCallback callback = new InterpolatedTimeCallback(){

            @Override
            public void onTimeUpdate(float interpolatedTime) {
                SimpleIndicatorView.this.getCurrPoint(interpolatedTime, origP, destP, currP);
                SimpleIndicatorView.this.invalidate();
            }
        };
        this.mAnim.setCallback(callback);
        this.startAnimation(this.mAnim);
    }

    private void getCurrPoint(float fraction, PointF origP, PointF destP, PointF currP) {
        currP.x = origP.x + (destP.x - origP.x) * fraction;
        currP.y = origP.y + (destP.y - origP.y) * fraction;
    }

    private int getEvaluateColor(float fraction, int startColor, int endColor) {
        int sA = (startColor & 0xFF000000) >>> 24;
        int sR = (startColor & 0xFF0000) >>> 16;
        int sG = (startColor & 0xFF00) >>> 8;
        int sB = (startColor & 0xFF) >>> 0;
        int eA = (endColor & 0xFF000000) >>> 24;
        int eR = (endColor & 0xFF0000) >>> 16;
        int eG = (endColor & 0xFF00) >>> 8;
        int eB = (endColor & 0xFF) >>> 0;
        int a = (int)((float)sA + (float)(eA - sA) * fraction);
        int r = (int)((float)sR + (float)(eR - sR) * fraction);
        int g = (int)((float)sG + (float)(eG - sG) * fraction);
        int b = (int)((float)sB + (float)(eB - sB) * fraction);
        return a << 24 | r << 16 | g << 8 | b;
    }

    public void setPosition() {
    }

    private void refreshCurrPointByIndexAndOffsetRation(int index, float offsetRation) {
        float destY;
        float destX;
        if (index < 0 || index > this.mIndicatorCount - 1) {
            throw new IllegalArgumentException("index should be larger than -1 and less than (mIndicatorCount - 1), now index is " + index);
        }
        if (offsetRation < 0.0f || offsetRation >= 1.0f) {
            throw new IllegalArgumentException("offsetRation should be in [0,1), now offsetRation is " + index);
        }
        if (index == this.mIndicatorCount - 1) {
            offsetRation = 0.0f;
        }
        if (this.mIndicatorOrientation == 0) {
            destX = this.mWidth * (0.5f + (float)index + offsetRation) / (float)this.mIndicatorCount;
            destY = this.mHeight / 2.0f;
        } else {
            destX = this.mWidth / 2.0f;
            destY = this.mHeight * (0.5f + (float)index + offsetRation) / (float)this.mIndicatorCount;
        }
        this.mCurrP.set(destX, destY);
    }

    static interface InterpolatedTimeCallback {
        public void onTimeUpdate(float var1);
    }

    class ValueGeneratorAnim
    extends Animation {
        private InterpolatedTimeCallback interpolatedTimeCallback;

        ValueGeneratorAnim() {
        }

        protected void applyTransformation(float interpolatedTime, Transformation t) {
            if (this.interpolatedTimeCallback != null) {
                this.interpolatedTimeCallback.onTimeUpdate(interpolatedTime);
            }
        }

        public void setCallback(InterpolatedTimeCallback interpolatedTimeCallback) {
            this.interpolatedTimeCallback = interpolatedTimeCallback;
        }
    }
}

