SELECT r.SECURITY_TYPE,
       r.DEFINER,
       r.ROUTINE_SCHEMA,
       r.SPECIFIC_NAME,
       r.ROUTINE_DEFINITION,
       p.PARAMETER_MODE,
       p.PARAMETER_NAME,
       p.DATA_TYPE,
       p.CHARACTER_MAXIMUM_LENGTH,
       p.NUMERIC_PRECISION,
       p.NUMERIC_SCALE,
       p.DATETIME_PRECISION,
       p.DTD_IDENTIFIER,
       p.CHARACTER_SET_NAME,
       p.COLLATION_NAME
FROM information_schema.ROUTINES r
         LEFT JOIN information_schema.PARAMETERS p
                   ON r.ROUTINE_SCHEMA = p.SPECIFIC_SCHEMA AND r.SPECIFIC_NAME = p.SPECIFIC_NAME
WHERE r.ROUTINE_SCHEMA = ?
  AND r.ROUTINE_TYPE = 'PROCEDURE'