/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.config;

import cn.dev33.satoken.config.SaTokenConfig;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class SaTokenConfigFactory {
    public static String configPath = "sa-token.properties";

    public static SaTokenConfig createConfig() {
        Map<String, String> map = SaTokenConfigFactory.readPropToMap(configPath);
        if (map == null) {
            // empty if block
        }
        return (SaTokenConfig)SaTokenConfigFactory.initPropByMap(map, new SaTokenConfig());
    }

    private static Map<String, String> readPropToMap(String propertiesPath) {
        HashMap<String, String> map = new HashMap<String, String>(16);
        try {
            InputStream is = SaTokenConfigFactory.class.getClassLoader().getResourceAsStream(propertiesPath);
            if (is == null) {
                return null;
            }
            Properties prop = new Properties();
            prop.load(is);
            for (String key : prop.stringPropertyNames()) {
                map.put(key, prop.getProperty(key));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("\u914d\u7f6e\u6587\u4ef6(" + propertiesPath + ")\u52a0\u8f7d\u5931\u8d25", e);
        }
        return map;
    }

    private static Object initPropByMap(Map<String, String> map, Object obj) {
        if (map == null) {
            map = new HashMap<String, String>(16);
        }
        Class<?> cs = null;
        if (obj instanceof Class) {
            cs = (Class<?>)obj;
            obj = null;
        } else {
            cs = obj.getClass();
        }
        for (Field field : cs.getDeclaredFields()) {
            String value = map.get(field.getName());
            if (value == null) continue;
            try {
                Object valueConvert = SaTokenConfigFactory.getObjectByClass(value, field.getType());
                field.setAccessible(true);
                field.set(obj, valueConvert);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new RuntimeException("\u5c5e\u6027\u8d4b\u503c\u51fa\u9519\uff1a" + field.getName(), e);
            }
        }
        return obj;
    }

    private static <T> T getObjectByClass(String str, Class<T> cs) {
        Object value;
        if (str == null) {
            value = null;
        } else if (cs.equals(String.class)) {
            value = str;
        } else if (cs.equals(Integer.TYPE) || cs.equals(Integer.class)) {
            value = Integer.valueOf(str);
        } else if (cs.equals(Long.TYPE) || cs.equals(Long.class)) {
            value = Long.valueOf(str);
        } else if (cs.equals(Short.TYPE) || cs.equals(Short.class)) {
            value = Short.valueOf(str);
        } else if (cs.equals(Float.TYPE) || cs.equals(Float.class)) {
            value = Float.valueOf(str);
        } else if (cs.equals(Double.TYPE) || cs.equals(Double.class)) {
            value = Double.valueOf(str);
        } else if (cs.equals(Boolean.TYPE) || cs.equals(Boolean.class)) {
            value = Boolean.valueOf(str);
        } else {
            throw new RuntimeException("\u672a\u80fd\u5c06\u503c\uff1a" + str + "\uff0c\u8f6c\u6362\u7c7b\u578b\u4e3a\uff1a" + cs, null);
        }
        return (T)value;
    }
}

