/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.strategy;

import cn.dev33.satoken.SaManager;
import cn.dev33.satoken.annotation.SaCheckBasic;
import cn.dev33.satoken.annotation.SaCheckLogin;
import cn.dev33.satoken.annotation.SaCheckPermission;
import cn.dev33.satoken.annotation.SaCheckRole;
import cn.dev33.satoken.annotation.SaCheckSafe;
import cn.dev33.satoken.basic.SaBasicUtil;
import cn.dev33.satoken.session.SaSession;
import cn.dev33.satoken.util.SaFoxUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.List;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;

public final class SaStrategy {
    public static final SaStrategy me = new SaStrategy();
    public BiFunction<Object, String, String> createToken = (loginId, loginType) -> {
        String tokenStyle = SaManager.getConfig().getTokenStyle();
        if ("uuid".equals(tokenStyle)) {
            return UUID.randomUUID().toString();
        }
        if ("simple-uuid".equals(tokenStyle)) {
            return UUID.randomUUID().toString().replaceAll("-", "");
        }
        if ("random-32".equals(tokenStyle)) {
            return SaFoxUtil.getRandomString(32);
        }
        if ("random-64".equals(tokenStyle)) {
            return SaFoxUtil.getRandomString(64);
        }
        if ("random-128".equals(tokenStyle)) {
            return SaFoxUtil.getRandomString(128);
        }
        if ("tik".equals(tokenStyle)) {
            return SaFoxUtil.getRandomString(2) + "_" + SaFoxUtil.getRandomString(14) + "_" + SaFoxUtil.getRandomString(16) + "__";
        }
        return UUID.randomUUID().toString();
    };
    public Function<String, SaSession> createSession = sessionId -> new SaSession((String)sessionId);
    public BiFunction<List<String>, String, Boolean> hasElement = (list, element) -> {
        if (list == null || list.size() == 0) {
            return false;
        }
        if (list.contains(element)) {
            return true;
        }
        for (String patt : list) {
            if (!SaFoxUtil.vagueMatch(patt, element)) continue;
            return true;
        }
        return false;
    };
    public Consumer<Method> checkMethodAnnotation = method -> {
        SaStrategy.me.checkElementAnnotation.accept(method.getDeclaringClass());
        SaStrategy.me.checkElementAnnotation.accept((AnnotatedElement)method);
    };
    public Consumer<AnnotatedElement> checkElementAnnotation = target -> {
        SaCheckBasic checkBasic;
        SaCheckSafe checkSafe;
        SaCheckPermission checkPermission;
        SaCheckRole checkRole;
        SaCheckLogin checkLogin = (SaCheckLogin)SaStrategy.me.getAnnotation.apply((AnnotatedElement)target, (Class<? extends Annotation>)SaCheckLogin.class);
        if (checkLogin != null) {
            SaManager.getStpLogic(checkLogin.type()).checkByAnnotation(checkLogin);
        }
        if ((checkRole = (SaCheckRole)SaStrategy.me.getAnnotation.apply((AnnotatedElement)target, (Class<? extends Annotation>)SaCheckRole.class)) != null) {
            SaManager.getStpLogic(checkRole.type()).checkByAnnotation(checkRole);
        }
        if ((checkPermission = (SaCheckPermission)SaStrategy.me.getAnnotation.apply((AnnotatedElement)target, (Class<? extends Annotation>)SaCheckPermission.class)) != null) {
            SaManager.getStpLogic(checkPermission.type()).checkByAnnotation(checkPermission);
        }
        if ((checkSafe = (SaCheckSafe)SaStrategy.me.getAnnotation.apply((AnnotatedElement)target, (Class<? extends Annotation>)SaCheckSafe.class)) != null) {
            SaManager.getStpLogic(checkSafe.type()).checkByAnnotation(checkSafe);
        }
        if ((checkBasic = (SaCheckBasic)SaStrategy.me.getAnnotation.apply((AnnotatedElement)target, (Class<? extends Annotation>)SaCheckBasic.class)) != null) {
            SaBasicUtil.check(checkBasic.realm(), checkBasic.account());
        }
    };
    public BiFunction<AnnotatedElement, Class<? extends Annotation>, Annotation> getAnnotation = (element, annotationClass) -> element.getAnnotation(annotationClass);

    private SaStrategy() {
    }

    public SaStrategy setCreateToken(BiFunction<Object, String, String> createToken) {
        this.createToken = createToken;
        return this;
    }

    public SaStrategy setCreateSession(Function<String, SaSession> createSession) {
        this.createSession = createSession;
        return this;
    }

    public SaStrategy setHasElement(BiFunction<List<String>, String, Boolean> hasElement) {
        this.hasElement = hasElement;
        return this;
    }

    public SaStrategy setCheckMethodAnnotation(Consumer<Method> checkMethodAnnotation) {
        this.checkMethodAnnotation = checkMethodAnnotation;
        return this;
    }

    public SaStrategy setCheckElementAnnotation(Consumer<AnnotatedElement> checkElementAnnotation) {
        this.checkElementAnnotation = checkElementAnnotation;
        return this;
    }

    public SaStrategy setGetAnnotation(BiFunction<AnnotatedElement, Class<? extends Annotation>, Annotation> getAnnotation) {
        this.getAnnotation = getAnnotation;
        return this;
    }
}

