/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing.tools.excel;

import cn.gjing.tools.excel.Excel;
import cn.gjing.tools.excel.exception.ExcelInitException;
import cn.gjing.tools.excel.exception.ExcelTemplateException;
import cn.gjing.tools.excel.metadata.ExcelType;
import cn.gjing.tools.excel.read.ExcelReaderContext;
import cn.gjing.tools.excel.read.resolver.ExcelBindReader;
import cn.gjing.tools.excel.util.BeanUtils;
import cn.gjing.tools.excel.util.ParamUtils;
import cn.gjing.tools.excel.write.ExcelWriterContext;
import cn.gjing.tools.excel.write.resolver.ExcelBindWriter;
import cn.gjing.tools.excel.write.resolver.ExcelSimpleWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import javax.servlet.http.HttpServletResponse;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

public final class ExcelFactory {
    private ExcelFactory() {
    }

    public static ExcelBindWriter createWriter(Class<?> excelClass, HttpServletResponse response, String ... ignores) {
        return ExcelFactory.createWriter(null, excelClass, response, true, ignores);
    }

    public static ExcelBindWriter createWriter(Class<?> excelClass, HttpServletResponse response, boolean initDefaultStyle, String ... ignores) {
        return ExcelFactory.createWriter(null, excelClass, response, initDefaultStyle, ignores);
    }

    public static ExcelBindWriter createWriter(String fileName, Class<?> excelClass, HttpServletResponse response, String ... ignores) {
        return ExcelFactory.createWriter(fileName, excelClass, response, true, ignores);
    }

    public static ExcelBindWriter createWriter(String fileName, Class<?> excelClass, HttpServletResponse response, boolean initDefaultStyle, String ... ignores) {
        ParamUtils.requireNonNull(excelClass, "Excel mapping class cannot be null");
        Excel excel = excelClass.getAnnotation(Excel.class);
        ParamUtils.requireNonNull(excel, "@Excel annotation was not found on the " + excelClass);
        ArrayList<String[]> headerArr = new ArrayList<String[]>();
        ExcelWriterContext context = ExcelWriterContext.builder().excelFields(BeanUtils.getExcelFields(excelClass, ignores, headerArr)).headNames(headerArr).excelType(excel.type()).fileName(StringUtils.isEmpty((Object)fileName) ? ("".equals(excel.value()) ? LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")) : excel.value()) : fileName).excelClass(excelClass).headerHeight(excel.headerHeight()).bodyHeight(excel.bodyHeight()).headerSeries(((String[])headerArr.get(0)).length).uniqueKey("".equals(excel.uniqueKey()) ? excelClass.getName() : excel.uniqueKey()).build();
        return new ExcelBindWriter(context, excel, response, initDefaultStyle);
    }

    public static ExcelSimpleWriter createSimpleWriter(String fileName, HttpServletResponse response, boolean initDefaultStyle) {
        return ExcelFactory.createSimpleWriter(fileName, response, ExcelType.XLS, 500, initDefaultStyle);
    }

    public static ExcelSimpleWriter createSimpleWriter(String fileName, HttpServletResponse response, ExcelType excelType) {
        return ExcelFactory.createSimpleWriter(fileName, response, excelType, 500, true);
    }

    public static ExcelSimpleWriter createSimpleWriter(String fileName, HttpServletResponse response, ExcelType excelType, int windowSize) {
        return ExcelFactory.createSimpleWriter(fileName, response, excelType, windowSize, true);
    }

    public static ExcelSimpleWriter createSimpleWriter(String fileName, HttpServletResponse response, ExcelType excelType, int windowSize, boolean initDefaultStyle) {
        ExcelWriterContext context = ExcelWriterContext.builder().fileName(StringUtils.isEmpty((Object)fileName) ? LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")) : fileName).excelType(excelType).excelClass(Void.class).bind(false).build();
        return new ExcelSimpleWriter(context, windowSize, response, initDefaultStyle);
    }

    public static <R> ExcelBindReader<R> createReader(MultipartFile file, Class<R> excelClass, String ... ignores) {
        try {
            if (!ParamUtils.isExcel(file.getOriginalFilename())) {
                throw new ExcelTemplateException("File type does not belong to Excel");
            }
            return ExcelFactory.createReader(file.getInputStream(), excelClass, ignores);
        }
        catch (IOException e) {
            throw new ExcelInitException("Create excel reader error," + e.getMessage());
        }
    }

    public static <R> ExcelBindReader<R> createReader(File file, Class<R> excelClass, String ... ignores) {
        try {
            if (!ParamUtils.isExcel(file.getName())) {
                throw new ExcelTemplateException("File type does not belong to Excel");
            }
            return ExcelFactory.createReader(new FileInputStream(file), excelClass, ignores);
        }
        catch (IOException e) {
            throw new ExcelInitException("Create excel reader error," + e.getMessage());
        }
    }

    public static <R> ExcelBindReader<R> createReader(InputStream inputStream, Class<R> excelClass, String ... ignores) {
        ParamUtils.requireNonNull(excelClass, "Excel mapping class cannot be null");
        Excel excel = excelClass.getAnnotation(Excel.class);
        ParamUtils.requireNonNull(excel, "@Excel annotation was not found on the " + excelClass);
        ExcelReaderContext<R> readerContext = new ExcelReaderContext<R>(excelClass, BeanUtils.getExcelFieldsMap(excelClass), ignores);
        readerContext.setUniqueKey("".equals(excel.uniqueKey()) ? excelClass.getName() : excel.uniqueKey());
        return new ExcelBindReader<R>(readerContext, inputStream, excel);
    }
}

