/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing.tools.excel.read.resolver;

import cn.gjing.tools.excel.Excel;
import cn.gjing.tools.excel.read.ExcelReaderContext;
import cn.gjing.tools.excel.read.listener.ExcelEmptyReadListener;
import cn.gjing.tools.excel.read.listener.ExcelReadListener;
import cn.gjing.tools.excel.read.listener.ExcelResultReadListener;
import cn.gjing.tools.excel.read.listener.ExcelRowReadListener;
import cn.gjing.tools.excel.read.resolver.ExcelBaseReader;
import cn.gjing.tools.excel.util.ParamUtils;
import java.io.InputStream;
import java.util.List;

public final class ExcelBindReader<R>
extends ExcelBaseReader<R> {
    public ExcelBindReader(ExcelReaderContext<R> context, InputStream inputStream, Excel excel) {
        super(context, inputStream, excel);
    }

    public ExcelBindReader<R> read() {
        this.getClass();
        this.readerResolver.read(0, "Sheet1");
        return this;
    }

    public ExcelBindReader<R> read(String sheetName) {
        this.readerResolver.read(0, sheetName);
        return this;
    }

    public ExcelBindReader<R> read(int headerIndex) {
        this.getClass();
        this.readerResolver.read(headerIndex, "Sheet1");
        return this;
    }

    public ExcelBindReader<R> read(int headerIndex, String sheetName) {
        this.readerResolver.read(headerIndex, sheetName);
        return this;
    }

    @Deprecated
    public ExcelBindReader<R> metaInfo(boolean need) {
        return this.headBefore(need);
    }

    public ExcelBindReader<R> headBefore(boolean need) {
        this.context.setHeadBefore(need);
        return this;
    }

    public ExcelBindReader<R> check(boolean enable) {
        this.context.setCheckTemplate(enable);
        return this;
    }

    public ExcelBindReader<R> addListener(List<ExcelReadListener> readListenerList) {
        if (readListenerList != null) {
            readListenerList.forEach(this.context::addListener);
        }
        return this;
    }

    public ExcelBindReader<R> addListener(ExcelReadListener readListener) {
        if (readListener != null) {
            this.context.addListener(readListener);
        }
        return this;
    }

    public ExcelBindReader<R> subscribe(ExcelResultReadListener<R> excelResultReadListener) {
        this.context.setResultReadListener(excelResultReadListener);
        return this;
    }

    public ExcelBindReader<R> removeEmptyListener() {
        ParamUtils.deleteMapKey(this.context.getReadListenersCache(), ExcelEmptyReadListener.class);
        return this;
    }

    public ExcelBindReader<R> removeRowListener() {
        ParamUtils.deleteMapKey(this.context.getReadListenersCache(), ExcelRowReadListener.class);
        return this;
    }

    public ExcelBindReader<R> removeResultListener() {
        this.context.setResultReadListener(null);
        return this;
    }
}

