/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing.tools.excel.write;

import cn.gjing.tools.excel.metadata.ExcelType;
import cn.gjing.tools.excel.util.ListenerChain;
import cn.gjing.tools.excel.write.listener.ExcelWriteListener;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public final class ExcelWriterContext {
    private Workbook workbook;
    private Sheet sheet;
    private String fileName;
    private boolean needValid;
    private boolean multiHead;
    private List<Field> excelFields;
    private List<String[]> headNames;
    private Class<?> excelClass;
    private boolean bind;
    private String uniqueKey;
    private ExcelType excelType;
    private Map<Class<? extends ExcelWriteListener>, List<ExcelWriteListener>> writeListenerCache;
    private short headerHeight;
    private short bodyHeight;
    private int headerSeries;

    public void addListener(ExcelWriteListener excelWriteListener) {
        ListenerChain.addWriteListener(this.writeListenerCache, excelWriteListener, this.workbook);
    }

    private static boolean $default$needValid() {
        return false;
    }

    private static boolean $default$multiHead() {
        return false;
    }

    private static List<Field> $default$excelFields() {
        return new ArrayList<Field>();
    }

    private static List<String[]> $default$headNames() {
        return new ArrayList<String[]>();
    }

    private static boolean $default$bind() {
        return true;
    }

    private static ExcelType $default$excelType() {
        return ExcelType.XLS;
    }

    private static Map<Class<? extends ExcelWriteListener>, List<ExcelWriteListener>> $default$writeListenerCache() {
        return new HashMap<Class<? extends ExcelWriteListener>, List<ExcelWriteListener>>(8);
    }

    private static short $default$headerHeight() {
        return 400;
    }

    private static short $default$bodyHeight() {
        return 370;
    }

    private static int $default$headerSeries() {
        return 1;
    }

    public static ExcelWriterContextBuilder builder() {
        return new ExcelWriterContextBuilder();
    }

    public Workbook getWorkbook() {
        return this.workbook;
    }

    public Sheet getSheet() {
        return this.sheet;
    }

    public String getFileName() {
        return this.fileName;
    }

    public boolean isNeedValid() {
        return this.needValid;
    }

    public boolean isMultiHead() {
        return this.multiHead;
    }

    public List<Field> getExcelFields() {
        return this.excelFields;
    }

    public List<String[]> getHeadNames() {
        return this.headNames;
    }

    public Class<?> getExcelClass() {
        return this.excelClass;
    }

    public boolean isBind() {
        return this.bind;
    }

    public String getUniqueKey() {
        return this.uniqueKey;
    }

    public ExcelType getExcelType() {
        return this.excelType;
    }

    public Map<Class<? extends ExcelWriteListener>, List<ExcelWriteListener>> getWriteListenerCache() {
        return this.writeListenerCache;
    }

    public short getHeaderHeight() {
        return this.headerHeight;
    }

    public short getBodyHeight() {
        return this.bodyHeight;
    }

    public int getHeaderSeries() {
        return this.headerSeries;
    }

    public void setWorkbook(Workbook workbook) {
        this.workbook = workbook;
    }

    public void setSheet(Sheet sheet) {
        this.sheet = sheet;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setNeedValid(boolean needValid) {
        this.needValid = needValid;
    }

    public void setMultiHead(boolean multiHead) {
        this.multiHead = multiHead;
    }

    public void setExcelFields(List<Field> excelFields) {
        this.excelFields = excelFields;
    }

    public void setHeadNames(List<String[]> headNames) {
        this.headNames = headNames;
    }

    public void setExcelClass(Class<?> excelClass) {
        this.excelClass = excelClass;
    }

    public void setBind(boolean bind) {
        this.bind = bind;
    }

    public void setUniqueKey(String uniqueKey) {
        this.uniqueKey = uniqueKey;
    }

    public void setExcelType(ExcelType excelType) {
        this.excelType = excelType;
    }

    public void setWriteListenerCache(Map<Class<? extends ExcelWriteListener>, List<ExcelWriteListener>> writeListenerCache) {
        this.writeListenerCache = writeListenerCache;
    }

    public void setHeaderHeight(short headerHeight) {
        this.headerHeight = headerHeight;
    }

    public void setBodyHeight(short bodyHeight) {
        this.bodyHeight = bodyHeight;
    }

    public void setHeaderSeries(int headerSeries) {
        this.headerSeries = headerSeries;
    }

    public ExcelWriterContext() {
        this.needValid = ExcelWriterContext.$default$needValid();
        this.multiHead = ExcelWriterContext.$default$multiHead();
        this.excelFields = ExcelWriterContext.$default$excelFields();
        this.headNames = ExcelWriterContext.$default$headNames();
        this.bind = ExcelWriterContext.$default$bind();
        this.excelType = ExcelWriterContext.$default$excelType();
        this.writeListenerCache = ExcelWriterContext.$default$writeListenerCache();
        this.headerHeight = ExcelWriterContext.$default$headerHeight();
        this.bodyHeight = ExcelWriterContext.$default$bodyHeight();
        this.headerSeries = ExcelWriterContext.$default$headerSeries();
    }

    public ExcelWriterContext(Workbook workbook, Sheet sheet, String fileName, boolean needValid, boolean multiHead, List<Field> excelFields, List<String[]> headNames, Class<?> excelClass, boolean bind, String uniqueKey, ExcelType excelType, Map<Class<? extends ExcelWriteListener>, List<ExcelWriteListener>> writeListenerCache, short headerHeight, short bodyHeight, int headerSeries) {
        this.workbook = workbook;
        this.sheet = sheet;
        this.fileName = fileName;
        this.needValid = needValid;
        this.multiHead = multiHead;
        this.excelFields = excelFields;
        this.headNames = headNames;
        this.excelClass = excelClass;
        this.bind = bind;
        this.uniqueKey = uniqueKey;
        this.excelType = excelType;
        this.writeListenerCache = writeListenerCache;
        this.headerHeight = headerHeight;
        this.bodyHeight = bodyHeight;
        this.headerSeries = headerSeries;
    }

    public static class ExcelWriterContextBuilder {
        private Workbook workbook;
        private Sheet sheet;
        private String fileName;
        private boolean needValid$set;
        private boolean needValid$value;
        private boolean multiHead$set;
        private boolean multiHead$value;
        private boolean excelFields$set;
        private List<Field> excelFields$value;
        private boolean headNames$set;
        private List<String[]> headNames$value;
        private Class<?> excelClass;
        private boolean bind$set;
        private boolean bind$value;
        private String uniqueKey;
        private boolean excelType$set;
        private ExcelType excelType$value;
        private boolean writeListenerCache$set;
        private Map<Class<? extends ExcelWriteListener>, List<ExcelWriteListener>> writeListenerCache$value;
        private boolean headerHeight$set;
        private short headerHeight$value;
        private boolean bodyHeight$set;
        private short bodyHeight$value;
        private boolean headerSeries$set;
        private int headerSeries$value;

        ExcelWriterContextBuilder() {
        }

        public ExcelWriterContextBuilder workbook(Workbook workbook) {
            this.workbook = workbook;
            return this;
        }

        public ExcelWriterContextBuilder sheet(Sheet sheet) {
            this.sheet = sheet;
            return this;
        }

        public ExcelWriterContextBuilder fileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public ExcelWriterContextBuilder needValid(boolean needValid) {
            this.needValid$value = needValid;
            this.needValid$set = true;
            return this;
        }

        public ExcelWriterContextBuilder multiHead(boolean multiHead) {
            this.multiHead$value = multiHead;
            this.multiHead$set = true;
            return this;
        }

        public ExcelWriterContextBuilder excelFields(List<Field> excelFields) {
            this.excelFields$value = excelFields;
            this.excelFields$set = true;
            return this;
        }

        public ExcelWriterContextBuilder headNames(List<String[]> headNames) {
            this.headNames$value = headNames;
            this.headNames$set = true;
            return this;
        }

        public ExcelWriterContextBuilder excelClass(Class<?> excelClass) {
            this.excelClass = excelClass;
            return this;
        }

        public ExcelWriterContextBuilder bind(boolean bind) {
            this.bind$value = bind;
            this.bind$set = true;
            return this;
        }

        public ExcelWriterContextBuilder uniqueKey(String uniqueKey) {
            this.uniqueKey = uniqueKey;
            return this;
        }

        public ExcelWriterContextBuilder excelType(ExcelType excelType) {
            this.excelType$value = excelType;
            this.excelType$set = true;
            return this;
        }

        public ExcelWriterContextBuilder writeListenerCache(Map<Class<? extends ExcelWriteListener>, List<ExcelWriteListener>> writeListenerCache) {
            this.writeListenerCache$value = writeListenerCache;
            this.writeListenerCache$set = true;
            return this;
        }

        public ExcelWriterContextBuilder headerHeight(short headerHeight) {
            this.headerHeight$value = headerHeight;
            this.headerHeight$set = true;
            return this;
        }

        public ExcelWriterContextBuilder bodyHeight(short bodyHeight) {
            this.bodyHeight$value = bodyHeight;
            this.bodyHeight$set = true;
            return this;
        }

        public ExcelWriterContextBuilder headerSeries(int headerSeries) {
            this.headerSeries$value = headerSeries;
            this.headerSeries$set = true;
            return this;
        }

        public ExcelWriterContext build() {
            boolean needValid$value = this.needValid$value;
            if (!this.needValid$set) {
                needValid$value = ExcelWriterContext.$default$needValid();
            }
            boolean multiHead$value = this.multiHead$value;
            if (!this.multiHead$set) {
                multiHead$value = ExcelWriterContext.$default$multiHead();
            }
            List excelFields$value = this.excelFields$value;
            if (!this.excelFields$set) {
                excelFields$value = ExcelWriterContext.$default$excelFields();
            }
            List headNames$value = this.headNames$value;
            if (!this.headNames$set) {
                headNames$value = ExcelWriterContext.$default$headNames();
            }
            boolean bind$value = this.bind$value;
            if (!this.bind$set) {
                bind$value = ExcelWriterContext.$default$bind();
            }
            ExcelType excelType$value = this.excelType$value;
            if (!this.excelType$set) {
                excelType$value = ExcelWriterContext.$default$excelType();
            }
            Map writeListenerCache$value = this.writeListenerCache$value;
            if (!this.writeListenerCache$set) {
                writeListenerCache$value = ExcelWriterContext.$default$writeListenerCache();
            }
            short headerHeight$value = this.headerHeight$value;
            if (!this.headerHeight$set) {
                headerHeight$value = ExcelWriterContext.$default$headerHeight();
            }
            short bodyHeight$value = this.bodyHeight$value;
            if (!this.bodyHeight$set) {
                bodyHeight$value = ExcelWriterContext.$default$bodyHeight();
            }
            int headerSeries$value = this.headerSeries$value;
            if (!this.headerSeries$set) {
                headerSeries$value = ExcelWriterContext.$default$headerSeries();
            }
            return new ExcelWriterContext(this.workbook, this.sheet, this.fileName, needValid$value, multiHead$value, excelFields$value, headNames$value, this.excelClass, bind$value, this.uniqueKey, excelType$value, writeListenerCache$value, headerHeight$value, bodyHeight$value, headerSeries$value);
        }

        public String toString() {
            return "ExcelWriterContext.ExcelWriterContextBuilder(workbook=" + this.workbook + ", sheet=" + this.sheet + ", fileName=" + this.fileName + ", needValid$value=" + this.needValid$value + ", multiHead$value=" + this.multiHead$value + ", excelFields$value=" + this.excelFields$value + ", headNames$value=" + this.headNames$value + ", excelClass=" + this.excelClass + ", bind$value=" + this.bind$value + ", uniqueKey=" + this.uniqueKey + ", excelType$value=" + (Object)((Object)this.excelType$value) + ", writeListenerCache$value=" + this.writeListenerCache$value + ", headerHeight$value=" + this.headerHeight$value + ", bodyHeight$value=" + this.bodyHeight$value + ", headerSeries$value=" + this.headerSeries$value + ")";
        }
    }
}

