/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.util;

import cn.hutool.core.exceptions.UtilException;
import cn.hutool.core.io.FastByteArrayOutputStream;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ZipUtil {
    private static final int DEFAULT_BYTE_ARRAY_LENGTH = 32;
    private static final Charset DEFAULT_CHARSET = CharsetUtil.defaultCharset();

    public static File zip(String srcPath) throws UtilException {
        return ZipUtil.zip(srcPath, DEFAULT_CHARSET);
    }

    public static File zip(String srcPath, Charset charset) throws UtilException {
        return ZipUtil.zip(FileUtil.file(srcPath), charset);
    }

    public static File zip(File srcFile) throws UtilException {
        return ZipUtil.zip(srcFile, DEFAULT_CHARSET);
    }

    public static File zip(File srcFile, Charset charset) throws UtilException {
        File zipFile = FileUtil.file(srcFile.getParentFile(), FileUtil.mainName(srcFile) + ".zip");
        ZipUtil.zip(zipFile, charset, false, srcFile);
        return zipFile;
    }

    public static File zip(String srcPath, String zipPath) throws UtilException {
        return ZipUtil.zip(srcPath, zipPath, false);
    }

    public static File zip(String srcPath, String zipPath, boolean withSrcDir) throws UtilException {
        return ZipUtil.zip(srcPath, zipPath, DEFAULT_CHARSET, withSrcDir);
    }

    public static File zip(String srcPath, String zipPath, Charset charset, boolean withSrcDir) throws UtilException {
        File srcFile = FileUtil.file(srcPath);
        File zipFile = FileUtil.file(zipPath);
        ZipUtil.zip(zipFile, charset, withSrcDir, srcFile);
        return zipFile;
    }

    public static File zip(File zipFile, boolean withSrcDir, File ... srcFiles) throws UtilException {
        return ZipUtil.zip(zipFile, DEFAULT_CHARSET, withSrcDir, srcFiles);
    }

    public static File zip(File zipFile, Charset charset, boolean withSrcDir, File ... srcFiles) throws UtilException {
        return ZipUtil.zip(zipFile, charset, withSrcDir, null, srcFiles);
    }

    public static File zip(File zipFile, Charset charset, boolean withSrcDir, FileFilter filter, File ... srcFiles) throws UtilException {
        ZipUtil.validateFiles(zipFile, srcFiles);
        try (ZipOutputStream out = ZipUtil.getZipOutputStream(zipFile, charset);){
            for (File srcFile : srcFiles) {
                if (null == srcFile) continue;
                String srcRootDir = srcFile.getCanonicalPath();
                if (srcFile.isFile() || withSrcDir) {
                    srcRootDir = srcFile.getCanonicalFile().getParentFile().getCanonicalPath();
                }
                ZipUtil.zip(srcFile, srcRootDir, out, filter);
                out.flush();
            }
        }
        catch (IOException e) {
            throw new UtilException(e);
        }
        return zipFile;
    }

    public static File zip(File zipFile, String path, String data) throws UtilException {
        return ZipUtil.zip(zipFile, path, data, DEFAULT_CHARSET);
    }

    public static File zip(File zipFile, String path, String data, Charset charset) throws UtilException {
        return ZipUtil.zip(zipFile, path, IoUtil.toStream(data, charset), charset);
    }

    public static File zip(File zipFile, String path, InputStream in) throws UtilException {
        return ZipUtil.zip(zipFile, path, in, DEFAULT_CHARSET);
    }

    public static File zip(File zipFile, String path, InputStream in, Charset charset) throws UtilException {
        return ZipUtil.zip(zipFile, new String[]{path}, new InputStream[]{in}, charset);
    }

    public static File zip(File zipFile, String[] paths, InputStream[] ins) throws UtilException {
        return ZipUtil.zip(zipFile, paths, ins, DEFAULT_CHARSET);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File zip(File zipFile, String[] paths, InputStream[] ins, Charset charset) throws UtilException {
        if (ArrayUtil.isEmpty(paths) || ArrayUtil.isEmpty(ins)) {
            throw new IllegalArgumentException("Paths or ins is empty !");
        }
        if (paths.length != ins.length) {
            throw new IllegalArgumentException("Paths length is not equals to ins length !");
        }
        ZipOutputStream out = null;
        try {
            out = ZipUtil.getZipOutputStream(zipFile, charset);
            for (int i = 0; i < paths.length; ++i) {
                ZipUtil.addFile(ins[i], paths[i], out);
            }
        }
        finally {
            IoUtil.close(out);
        }
        return zipFile;
    }

    public static File unzip(String zipFilePath) throws UtilException {
        return ZipUtil.unzip(zipFilePath, DEFAULT_CHARSET);
    }

    public static File unzip(String zipFilePath, Charset charset) throws UtilException {
        return ZipUtil.unzip(FileUtil.file(zipFilePath), charset);
    }

    public static File unzip(File zipFile) throws UtilException {
        return ZipUtil.unzip(zipFile, DEFAULT_CHARSET);
    }

    public static File unzip(File zipFile, Charset charset) throws UtilException {
        return ZipUtil.unzip(zipFile, FileUtil.file(zipFile.getParentFile(), FileUtil.mainName(zipFile)), charset);
    }

    public static File unzip(String zipFilePath, String outFileDir) throws UtilException {
        return ZipUtil.unzip(zipFilePath, outFileDir, DEFAULT_CHARSET);
    }

    public static File unzip(String zipFilePath, String outFileDir, Charset charset) throws UtilException {
        return ZipUtil.unzip(FileUtil.file(zipFilePath), FileUtil.mkdir(outFileDir), charset);
    }

    public static File unzip(File zipFile, File outFile) throws UtilException {
        return ZipUtil.unzip(zipFile, outFile, DEFAULT_CHARSET);
    }

    public static File unzip(File zipFile, File outFile, Charset charset) throws UtilException {
        ZipFile zip;
        try {
            zip = new ZipFile(zipFile, charset);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return ZipUtil.unzip(zip, outFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File unzip(ZipFile zipFile, File outFile) throws IORuntimeException {
        try {
            Enumeration<? extends ZipEntry> em = zipFile.entries();
            while (em.hasMoreElements()) {
                ZipEntry zipEntry = em.nextElement();
                File outItemFile = ZipUtil.buildFile(outFile, zipEntry.getName());
                if (zipEntry.isDirectory()) {
                    outItemFile.mkdirs();
                    continue;
                }
                ZipUtil.write(zipFile, zipEntry, outItemFile);
            }
        }
        finally {
            IoUtil.close(zipFile);
        }
        return outFile;
    }

    public static File unzip(InputStream in, File outFile, Charset charset) throws UtilException {
        if (null == charset) {
            charset = DEFAULT_CHARSET;
        }
        return ZipUtil.unzip(new ZipInputStream(in, charset), outFile);
    }

    public static File unzip(ZipInputStream zipStream, File outFile) throws UtilException {
        try {
            ZipEntry zipEntry;
            while (null != (zipEntry = zipStream.getNextEntry())) {
                File outItemFile = FileUtil.file(outFile, zipEntry.getName());
                if (zipEntry.isDirectory()) {
                    outItemFile.mkdirs();
                    continue;
                }
                FileUtil.writeFromStream((InputStream)zipStream, outItemFile);
            }
        }
        catch (IOException e) {
            throw new UtilException(e);
        }
        finally {
            IoUtil.close(zipStream);
        }
        return outFile;
    }

    public static byte[] unzipFileBytes(String zipFilePath, String name) {
        return ZipUtil.unzipFileBytes(zipFilePath, DEFAULT_CHARSET, name);
    }

    public static byte[] unzipFileBytes(String zipFilePath, Charset charset, String name) {
        return ZipUtil.unzipFileBytes(FileUtil.file(zipFilePath), charset, name);
    }

    public static byte[] unzipFileBytes(File zipFile, String name) {
        return ZipUtil.unzipFileBytes(zipFile, DEFAULT_CHARSET, name);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] unzipFileBytes(File zipFile, Charset charset, String name) {
        ZipFile zipFileObj;
        block6: {
            byte[] byArray;
            block5: {
                zipFileObj = null;
                try {
                    zipFileObj = new ZipFile(zipFile, charset);
                    Enumeration<? extends ZipEntry> em = zipFileObj.entries();
                    while (em.hasMoreElements()) {
                        ZipEntry zipEntry = em.nextElement();
                        if (zipEntry.isDirectory() || !name.equals(zipEntry.getName())) continue;
                        byArray = IoUtil.readBytes(zipFileObj.getInputStream(zipEntry));
                        break block5;
                    }
                    break block6;
                }
                catch (IOException e) {
                    try {
                        throw new UtilException(e);
                    }
                    catch (Throwable throwable) {
                        IoUtil.close(zipFileObj);
                        throw throwable;
                    }
                }
            }
            IoUtil.close(zipFileObj);
            return byArray;
        }
        IoUtil.close(zipFileObj);
        return null;
    }

    public static byte[] gzip(String content, String charset) throws UtilException {
        return ZipUtil.gzip(StrUtil.bytes((CharSequence)content, charset));
    }

    public static byte[] gzip(byte[] buf) throws UtilException {
        return ZipUtil.gzip(new ByteArrayInputStream(buf), buf.length);
    }

    public static byte[] gzip(File file) throws UtilException {
        BufferedInputStream in = null;
        try {
            in = FileUtil.getInputStream(file);
            byte[] byArray = ZipUtil.gzip(in, (int)file.length());
            return byArray;
        }
        finally {
            IoUtil.close(in);
        }
    }

    public static byte[] gzip(InputStream in) throws UtilException {
        return ZipUtil.gzip(in, 32);
    }

    public static byte[] gzip(InputStream in, int length) throws UtilException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(length);
        GZIPOutputStream gos = null;
        try {
            gos = new GZIPOutputStream(bos);
            IoUtil.copy(in, gos);
        }
        catch (IOException e) {
            try {
                throw new UtilException(e);
            }
            catch (Throwable throwable) {
                IoUtil.close(gos);
                throw throwable;
            }
        }
        IoUtil.close(gos);
        return bos.toByteArray();
    }

    public static String unGzip(byte[] buf, String charset) throws UtilException {
        return StrUtil.str(ZipUtil.unGzip(buf), charset);
    }

    public static byte[] unGzip(byte[] buf) throws UtilException {
        return ZipUtil.unGzip(new ByteArrayInputStream(buf), buf.length);
    }

    public static byte[] unGzip(InputStream in) throws UtilException {
        return ZipUtil.unGzip(in, 32);
    }

    public static byte[] unGzip(InputStream in, int length) throws UtilException {
        FastByteArrayOutputStream bos;
        GZIPInputStream gzi = null;
        try {
            gzi = in instanceof GZIPInputStream ? (GZIPInputStream)in : new GZIPInputStream(in);
            bos = new FastByteArrayOutputStream(length);
            IoUtil.copy(gzi, bos);
        }
        catch (IOException e) {
            try {
                throw new UtilException(e);
            }
            catch (Throwable throwable) {
                IoUtil.close(gzi);
                throw throwable;
            }
        }
        IoUtil.close(gzi);
        return bos.toByteArray();
    }

    public static byte[] zlib(String content, String charset, int level) {
        return ZipUtil.zlib(StrUtil.bytes((CharSequence)content, charset), level);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] zlib(File file, int level) {
        BufferedInputStream in = null;
        try {
            in = FileUtil.getInputStream(file);
            byte[] byArray = ZipUtil.zlib(in, level, (int)file.length());
            return byArray;
        }
        finally {
            IoUtil.close(in);
        }
    }

    public static byte[] zlib(byte[] buf, int level) {
        return ZipUtil.zlib(new ByteArrayInputStream(buf), level, buf.length);
    }

    public static byte[] zlib(InputStream in, int level) {
        return ZipUtil.zlib(in, level, 32);
    }

    public static byte[] zlib(InputStream in, int level, int length) {
        ByteArrayOutputStream out = new ByteArrayOutputStream(length);
        ZipUtil.deflater(in, out, level, false);
        return out.toByteArray();
    }

    public static String unZlib(byte[] buf, String charset) {
        return StrUtil.str(ZipUtil.unZlib(buf), charset);
    }

    public static byte[] unZlib(byte[] buf) {
        return ZipUtil.unZlib(new ByteArrayInputStream(buf), buf.length);
    }

    public static byte[] unZlib(InputStream in) {
        return ZipUtil.unZlib(in, 32);
    }

    public static byte[] unZlib(InputStream in, int length) {
        ByteArrayOutputStream out = new ByteArrayOutputStream(length);
        ZipUtil.inflater(in, out, false);
        return out.toByteArray();
    }

    public static List<String> listFileNames(ZipFile zipFile, String dir) {
        if (StrUtil.isNotBlank(dir)) {
            dir = StrUtil.addSuffixIfNot(dir, "/");
        }
        ArrayList<String> fileNames = new ArrayList<String>();
        for (ZipEntry zipEntry : Collections.list(zipFile.entries())) {
            String nameSuffix;
            String name = zipEntry.getName();
            if (!StrUtil.isEmpty(dir) && !name.startsWith(dir) || !StrUtil.isNotEmpty(nameSuffix = StrUtil.removePrefix(name, dir)) || StrUtil.contains(nameSuffix, '/')) continue;
            fileNames.add(nameSuffix);
        }
        return fileNames;
    }

    private static ZipOutputStream getZipOutputStream(File zipFile, Charset charset) {
        return ZipUtil.getZipOutputStream(FileUtil.getOutputStream(zipFile), charset);
    }

    private static ZipOutputStream getZipOutputStream(OutputStream out, Charset charset) {
        return new ZipOutputStream(out, ObjectUtil.defaultIfNull(charset, DEFAULT_CHARSET));
    }

    private static void zip(File file, String srcRootDir, ZipOutputStream out, FileFilter filter) throws UtilException {
        if (null == file || null != filter && !filter.accept(file)) {
            return;
        }
        String subPath = FileUtil.subPath(srcRootDir, file);
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (ArrayUtil.isEmpty(files) && StrUtil.isNotEmpty(subPath)) {
                ZipUtil.addDir(subPath, out);
            }
            for (File childFile : files) {
                ZipUtil.zip(childFile, srcRootDir, out, filter);
            }
        } else {
            ZipUtil.addFile(file, subPath, out);
        }
    }

    private static void addFile(File file, String path, ZipOutputStream out) throws UtilException {
        ZipUtil.addFile(FileUtil.getInputStream(file), path, out);
    }

    private static void addFile(InputStream in, String path, ZipOutputStream out) throws UtilException {
        if (null == in) {
            return;
        }
        try {
            out.putNextEntry(new ZipEntry(path));
            IoUtil.copy(in, out);
        }
        catch (IOException e) {
            throw new UtilException(e);
        }
        finally {
            IoUtil.close(in);
            ZipUtil.closeEntry(out);
        }
    }

    private static void addDir(String path, ZipOutputStream out) throws UtilException {
        path = StrUtil.addSuffixIfNot(path, "/");
        try {
            out.putNextEntry(new ZipEntry(path));
        }
        catch (IOException e) {
            throw new UtilException(e);
        }
        finally {
            ZipUtil.closeEntry(out);
        }
    }

    private static void validateFiles(File zipFile, File ... srcFiles) throws UtilException {
        if (zipFile.isDirectory()) {
            throw new UtilException("Zip file [{}] must not be a directory !", zipFile.getAbsoluteFile());
        }
        for (File srcFile : srcFiles) {
            if (null == srcFile) continue;
            if (!srcFile.exists()) {
                throw new UtilException(StrUtil.format((CharSequence)"File [{}] not exist!", srcFile.getAbsolutePath()));
            }
            try {
                File parentFile = zipFile.getCanonicalFile().getParentFile();
                if (!srcFile.isDirectory() || !parentFile.getCanonicalPath().contains(srcFile.getCanonicalPath())) continue;
                throw new UtilException("Zip file path [{}] must not be the child directory of [{}] !", zipFile.getCanonicalPath(), srcFile.getCanonicalPath());
            }
            catch (IOException e) {
                throw new UtilException(e);
            }
        }
    }

    private static void closeEntry(ZipOutputStream out) {
        try {
            out.closeEntry();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void write(ZipFile zipFile, ZipEntry zipEntry, File outItemFile) throws IORuntimeException {
        InputStream in = null;
        try {
            in = zipFile.getInputStream(zipEntry);
            FileUtil.writeFromStream(in, outItemFile);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        finally {
            IoUtil.close(in);
        }
    }

    private static void inflater(InputStream in, OutputStream out, boolean nowrap) {
        InflaterOutputStream ios = out instanceof InflaterOutputStream ? (InflaterOutputStream)out : new InflaterOutputStream(out, new Inflater(nowrap));
        IoUtil.copy(in, ios);
        try {
            ios.finish();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    private static void deflater(InputStream in, OutputStream out, int level, boolean nowrap) {
        DeflaterOutputStream ios = out instanceof DeflaterOutputStream ? (DeflaterOutputStream)out : new DeflaterOutputStream(out, new Deflater(level, nowrap));
        IoUtil.copy(in, ios);
        try {
            ios.finish();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    private static File buildFile(File outFile, String fileName) {
        if (!FileUtil.isWindows() && StrUtil.contains(fileName, '/')) {
            String[] pathParts = StrUtil.splitToArray(fileName, '/');
            return FileUtil.file(pathParts);
        }
        return FileUtil.file(outFile, fileName);
    }
}

