/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.poi.excel;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.poi.excel.StyleSet;
import cn.hutool.poi.excel.cell.CellEditor;
import cn.hutool.poi.excel.cell.CellUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

public class RowUtil {
    public static Row getOrCreateRow(Sheet sheet, int rowIndex) {
        Row row = sheet.getRow(rowIndex);
        if (null == row) {
            row = sheet.createRow(rowIndex);
        }
        return row;
    }

    public static List<Object> readRow(Row row, CellEditor cellEditor) {
        return RowUtil.readRow(row, 0, Short.MAX_VALUE, cellEditor);
    }

    public static List<Object> readRow(Row row, int startCellNumInclude, int endCellNumInclude, CellEditor cellEditor) {
        if (null == row) {
            return new ArrayList<Object>(0);
        }
        short rowLength = row.getLastCellNum();
        if (rowLength < 0) {
            return ListUtil.empty();
        }
        int size = Math.min(endCellNumInclude + 1, rowLength);
        ArrayList<Object> cellValues = new ArrayList<Object>(size);
        boolean isAllNull = true;
        for (int i = startCellNumInclude; i < size; ++i) {
            Object cellValue = CellUtil.getCellValue(row.getCell(i), cellEditor);
            isAllNull &= StrUtil.isEmptyIfStr(cellValue);
            cellValues.add(cellValue);
        }
        if (isAllNull) {
            return ListUtil.empty();
        }
        return cellValues;
    }

    public static void writeRow(Row row, Iterable<?> rowData, StyleSet styleSet, boolean isHeader) {
        int i = 0;
        for (Object value : rowData) {
            Cell cell = row.createCell(i);
            CellUtil.setCellValue(cell, value, styleSet, isHeader);
            ++i;
        }
    }
}

