/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.collection;

import java.util.AbstractList;
import java.util.List;

public class Partition<T>
extends AbstractList<List<T>> {
    protected final List<T> list;
    protected final int size;

    public Partition(List<T> list, int size) {
        this.list = list;
        this.size = size;
    }

    @Override
    public List<T> get(int index) {
        int start = index * this.size;
        int end = Math.min(start + this.size, this.list.size());
        return this.list.subList(start, end);
    }

    @Override
    public int size() {
        int length;
        int total = this.list.size();
        if (total % (length = total / this.size) > 0) {
            ++length;
        }
        return length;
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }
}

