/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.extra.ftp;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.ftp.AbstractFtp;
import cn.hutool.extra.ftp.FtpException;
import cn.hutool.extra.ftp.FtpMode;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;

public class Ftp
extends AbstractFtp {
    public static final int DEFAULT_PORT = 21;
    private FTPClient client;
    private Charset charset;

    public Ftp(String host) {
        this(host, 21);
    }

    public Ftp(String host, int port) {
        this(host, port, "anonymous", "");
    }

    public Ftp(String host, int port, String user, String password) {
        this(host, port, user, password, CharsetUtil.CHARSET_UTF_8);
    }

    public Ftp(String host, int port, String user, String password, Charset charset) {
        this.charset = charset;
        this.init(host, port, user, password);
    }

    public Ftp init(String host, int port, String user, String password) {
        FTPClient client = new FTPClient();
        client.setControlEncoding(this.charset.toString());
        try {
            client.connect(host, port);
            client.login(user, password);
        }
        catch (IOException e) {
            throw new FtpException(e);
        }
        int replyCode = client.getReplyCode();
        if (!FTPReply.isPositiveCompletion((int)replyCode)) {
            try {
                client.disconnect();
            }
            catch (IOException e) {
                // empty catch block
            }
            throw new FtpException("Login failed for user [{}], reply code is: [{}]", user, replyCode);
        }
        this.client = client;
        return this;
    }

    public Ftp setMode(FtpMode mode) {
        switch (mode) {
            case Active: {
                this.client.enterLocalActiveMode();
                break;
            }
            case Passive: {
                this.client.enterLocalPassiveMode();
            }
        }
        return this;
    }

    @Override
    public boolean cd(String directory) {
        boolean flag = true;
        try {
            flag = this.client.changeWorkingDirectory(directory);
        }
        catch (IOException e) {
            throw new FtpException(e);
        }
        return flag;
    }

    @Override
    public String pwd() {
        try {
            return this.client.printWorkingDirectory();
        }
        catch (IOException e) {
            throw new FtpException(e);
        }
    }

    @Override
    public List<String> ls(String path) {
        FTPFile[] ftpFiles;
        try {
            ftpFiles = this.client.listFiles();
        }
        catch (IOException e) {
            throw new FtpException(e);
        }
        ArrayList<String> fileNames = new ArrayList<String>();
        for (FTPFile ftpFile : ftpFiles) {
            fileNames.add(ftpFile.getName());
        }
        return fileNames;
    }

    @Override
    public boolean mkdir(String dir) {
        boolean flag = true;
        try {
            flag = this.client.makeDirectory(dir);
        }
        catch (IOException e) {
            throw new FtpException(e);
        }
        return flag;
    }

    public boolean existFile(String path) {
        Object[] ftpFileArr;
        try {
            ftpFileArr = this.client.listFiles(path);
        }
        catch (IOException e) {
            throw new FtpException(e);
        }
        return ArrayUtil.isNotEmpty((Object[])ftpFileArr);
    }

    @Override
    public boolean delFile(String path) {
        boolean isSuccess;
        String pwd = this.pwd();
        String fileName = FileUtil.getName((String)path);
        String dir = StrUtil.removeSuffix((CharSequence)path, (CharSequence)fileName);
        this.cd(dir);
        try {
            isSuccess = this.client.deleteFile(fileName);
        }
        catch (IOException e) {
            throw new FtpException(e);
        }
        this.cd(pwd);
        return isSuccess;
    }

    @Override
    public boolean delDir(String dirPath) {
        FTPFile[] dirs;
        try {
            dirs = this.client.listFiles(dirPath);
        }
        catch (IOException e) {
            throw new FtpException(e);
        }
        for (FTPFile ftpFile : dirs) {
            String name = ftpFile.getName();
            String childPath = StrUtil.format((CharSequence)"{}/{}", (Object[])new Object[]{dirPath, name});
            if (ftpFile.isDirectory()) {
                if (name.equals(".") || name.equals("..")) continue;
                this.delDir(childPath);
                continue;
            }
            this.delFile(childPath);
        }
        try {
            return this.client.removeDirectory(dirPath);
        }
        catch (IOException e) {
            throw new FtpException(e);
        }
    }

    @Override
    public boolean upload(String path, File file) {
        Assert.notNull((Object)file, (String)"file to upload is null !", (Object[])new Object[0]);
        return this.upload(path, file.getName(), file);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean upload(String path, String fileName, File file) {
        try (BufferedInputStream in = FileUtil.getInputStream((File)file);){
            boolean bl = this.upload(path, fileName, in);
            return bl;
        }
        catch (IOException e) {
            throw new FtpException(e);
        }
    }

    public boolean upload(String path, String fileName, InputStream fileStream) {
        try {
            this.client.setFileType(2);
        }
        catch (IOException e) {
            throw new FtpException(e);
        }
        this.mkDirs(path);
        this.cd(path);
        try {
            return this.client.storeFile(fileName, fileStream);
        }
        catch (IOException e) {
            throw new FtpException(e);
        }
    }

    @Override
    public void download(String path, File outFile) {
        String fileName = FileUtil.getName((String)path);
        String dir = StrUtil.removeSuffix((CharSequence)path, (CharSequence)fileName);
        this.download(dir, fileName, outFile);
    }

    public void download(String path, String fileName, File outFile) {
        if (outFile.isDirectory()) {
            outFile = new File(outFile, fileName);
        }
        if (!outFile.exists()) {
            FileUtil.touch((File)outFile);
        }
        try (BufferedOutputStream out = FileUtil.getOutputStream((File)outFile);){
            this.download(path, fileName, out);
        }
        catch (IOException e) {
            throw new FtpException(e);
        }
    }

    public void download(String path, String fileName, OutputStream out) {
        this.cd(path);
        try {
            this.client.setFileType(2);
            this.client.retrieveFile(fileName, out);
        }
        catch (IOException e) {
            throw new FtpException(e);
        }
    }

    public FTPClient getClient() {
        return this.client;
    }

    @Override
    public void close() throws IOException {
        this.client.logout();
        if (this.client.isConnected()) {
            this.client.disconnect();
        }
    }
}

