/*
 * Decompiled with CFR 0.152.
 */
package cn.jpush.android.ups;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.text.TextUtils;
import cn.jpush.android.helper.JCoreHelper;
import cn.jpush.android.helper.Logger;
import cn.jpush.android.ups.ICallbackResult;
import cn.jpush.android.ups.TokenResult;
import cn.jpush.android.ups.UPSRegisterCallBack;
import cn.jpush.android.ups.UPSUnRegisterCallBack;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class UPSPushHelper {
    private static final String TAG = "UPSPushHelper";
    public static final String ACTION_UPS = ".ups.receiver";
    public static final String KEY_RID = "ups.rid";
    public static final String KEY_CODE = "ups.code";
    public static final String KEY_TOKEN = "ups.token";
    public static final String KEY_ACTION = "ups.action";
    private static Map<Long, Object> cacheMap = new ConcurrentHashMap<Long, Object>();
    private static AtomicInteger rid = new AtomicInteger(0);
    private static a upsReceiver;

    public static void init(Context context) {
        if (upsReceiver == null) {
            upsReceiver = new a();
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction(context.getPackageName() + ACTION_UPS);
            context.getApplicationContext().registerReceiver((BroadcastReceiver)upsReceiver, intentFilter, UPSPushHelper.getReceiverPermission(context), null);
        }
    }

    public static String getReceiverPermission(Context context) {
        return context.getPackageName() + ".permission.JPUSH_MESSAGE";
    }

    public static void callResult(Context context, String string, Bundle bundle, ICallbackResult iCallbackResult) {
        int n2 = UPSPushHelper.getNextRid();
        UPSPushHelper.createMapping(context, n2, iCallbackResult);
        if (bundle == null) {
            bundle = new Bundle();
        }
        bundle.putInt(KEY_RID, n2);
        JCoreHelper.runActionWithService(context, "JPUSH", string, bundle);
    }

    public static void createMapping(Context context, long l2, ICallbackResult iCallbackResult) {
        UPSPushHelper.init(context);
        if (iCallbackResult == null) {
            Logger.e(TAG, "requestParams is null");
            return;
        }
        if (cacheMap.containsKey(l2)) {
            Logger.v(TAG, "rid " + l2 + " has exist.");
            return;
        }
        if (iCallbackResult instanceof Activity) {
            WeakReference<ICallbackResult> weakReference = new WeakReference<ICallbackResult>(iCallbackResult);
            cacheMap.put(l2, weakReference);
        } else {
            cacheMap.put(l2, iCallbackResult);
        }
    }

    public static ICallbackResult removeMapping(long l2) {
        return UPSPushHelper.objectToCallBack(cacheMap.remove(l2));
    }

    private static ICallbackResult objectToCallBack(Object object) {
        if (object != null) {
            if (object instanceof WeakReference) {
                return (ICallbackResult)((WeakReference)object).get();
            }
            if (object instanceof ICallbackResult) {
                return (ICallbackResult)object;
            }
        }
        return null;
    }

    public static int getNextRid() {
        int n2 = rid.incrementAndGet();
        if (n2 == Integer.MAX_VALUE) {
            rid.set(0);
        }
        return n2;
    }

    public static void upsCallBack(Context context, int n2, String string, int n3, String string2) {
        try {
            Intent intent = new Intent();
            intent.setAction(context.getPackageName() + ACTION_UPS);
            intent.setPackage(context.getPackageName());
            intent.putExtra(KEY_RID, n2);
            intent.putExtra(KEY_CODE, n3);
            intent.putExtra(KEY_TOKEN, string2);
            intent.putExtra(KEY_ACTION, string);
            context.sendBroadcast(intent, UPSPushHelper.getReceiverPermission(context));
        }
        catch (Throwable throwable) {
            Logger.ee(TAG, "[upsCallBack] failed:" + throwable.getMessage());
        }
    }

    static class a
    extends BroadcastReceiver {
        a() {
        }

        public void onReceive(Context context, Intent intent) {
            try {
                String string = intent.getAction();
                if (string.equals(context.getPackageName() + UPSPushHelper.ACTION_UPS)) {
                    int n2 = intent.getIntExtra(UPSPushHelper.KEY_RID, 0);
                    int n3 = intent.getIntExtra(UPSPushHelper.KEY_CODE, -1);
                    String string2 = intent.getStringExtra(UPSPushHelper.KEY_TOKEN);
                    String string3 = intent.getStringExtra(UPSPushHelper.KEY_ACTION);
                    Logger.dd(UPSPushHelper.TAG, "intenalAction:" + string3 + ",rid:" + n2 + ",code:" + n3 + ",token:" + string2);
                    if (n2 > 0) {
                        ICallbackResult iCallbackResult = UPSPushHelper.removeMapping(n2);
                        if (iCallbackResult != null) {
                            iCallbackResult.onResult(new TokenResult(string2, n3, string3));
                        }
                    } else if (!TextUtils.isEmpty((CharSequence)string3) && (string3.equals("ups.register") || string3.equals("ups.unregister"))) {
                        Iterator iterator = cacheMap.values().iterator();
                        while (iterator.hasNext()) {
                            Object v = iterator.next();
                            ICallbackResult iCallbackResult = UPSPushHelper.objectToCallBack(v);
                            if (iCallbackResult == null) continue;
                            if (v instanceof UPSRegisterCallBack && string3.equals("ups.register")) {
                                iterator.remove();
                                iCallbackResult.onResult(new TokenResult(string2, n3, string3));
                                continue;
                            }
                            if (!(v instanceof UPSUnRegisterCallBack) || !string3.equals("ups.unregister")) continue;
                            iterator.remove();
                            iCallbackResult.onResult(new TokenResult(string2, n3, string3));
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }
}

