/*
 * Decompiled with CFR 0.152.
 */
package kotyox.statedrawable.state;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.TextView;
import family.widget.com.roundwidget.R;
import java.lang.ref.WeakReference;

public class XStateRadioButtonDrawable
extends StateListDrawable {
    private final int[] STATE_SELECTED = new int[]{0x10100A1};
    private final int[] STATE_PRESSED = new int[]{16842919};
    private final int[] STATE_DISABLED = new int[]{-16842910};
    private final int[] STATE_CHECK = new int[]{0x10100A0};
    private final int[] STATE_UNCHECK = new int[]{-16842912};
    private WeakReference<View> mReference;

    public XStateRadioButtonDrawable(View view) {
        this.mReference = new WeakReference<View>(view);
    }

    public void fromAttributeSet(Context context, AttributeSet attrs, int defStyleAttr) {
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.XStateRadioButton, defStyleAttr, 0);
        Drawable disabledDa = ta.getDrawable(R.styleable.XStateRadioButton_x_stateDisabled);
        Drawable selectDa = ta.getDrawable(R.styleable.XStateRadioButton_x_stateSelect);
        int pressedDaC = ta.getColor(R.styleable.XStateRadioButton_x_statePressedC, 0);
        int enabledDaC = ta.getColor(R.styleable.XStateRadioButton_x_stateEnabledC, 0);
        int disableDaC = ta.getColor(R.styleable.XStateRadioButton_x_stateDisableC, 0);
        int checkDaC = ta.getColor(R.styleable.XStateRadioButton_x_stateCheckC, 0);
        Drawable pressedDa = ta.getDrawable(R.styleable.XStateRadioButton_x_statePressed);
        Drawable checkDa = ta.getDrawable(R.styleable.XStateRadioButton_x_stateCheck);
        Drawable unCheckDa = ta.getDrawable(R.styleable.XStateRadioButton_x_stateUnCheck);
        int drawableDirection = ta.getInt(R.styleable.XStateRadioButton_x_stateDirection, 1);
        if (selectDa != null) {
            this.addState(this.STATE_SELECTED, selectDa);
        }
        if (pressedDa != null) {
            this.addState(this.STATE_PRESSED, pressedDa);
        }
        if (checkDa != null) {
            this.addState(this.STATE_CHECK, checkDa);
        }
        if (unCheckDa != null) {
            this.addState(this.STATE_UNCHECK, unCheckDa);
        }
        if (disabledDa != null) {
            this.addState(this.STATE_DISABLED, disabledDa);
        }
        View view = (View)this.mReference.get();
        this.setBounds(0, 0, this.getMinimumWidth(), this.getMinimumHeight());
        ((TextView)view).setTextColor(this.createColorStateList(enabledDaC, pressedDaC, disableDaC, checkDaC));
        if (drawableDirection == 1) {
            ((TextView)view).setCompoundDrawables((Drawable)this, null, null, null);
        } else if (drawableDirection == 2) {
            ((TextView)view).setCompoundDrawables(null, (Drawable)this, null, null);
        } else if (drawableDirection == 3) {
            ((TextView)view).setCompoundDrawables(null, null, (Drawable)this, null);
        } else if (drawableDirection == 4) {
            ((TextView)view).setCompoundDrawables(null, null, null, (Drawable)this);
        }
    }

    private ColorStateList createColorStateList(int normal, int pressed, int unable, int check) {
        int[] colors = new int[]{check, check, pressed, unable, normal, normal};
        int[][] states = new int[colors.length][];
        states[0] = new int[]{0x10100A0};
        states[1] = new int[]{0x10100A1};
        states[2] = new int[]{16842919};
        states[3] = new int[]{-16842910};
        states[4] = new int[]{16842910};
        states[5] = new int[0];
        ColorStateList colorList = new ColorStateList((int[][])states, colors);
        return colorList;
    }
}

