/*
 * Decompiled with CFR 0.152.
 */
package kotyox.widget.roundrawable;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import family.widget.com.roundwidget.R;

public class XEditTextDrawable
extends GradientDrawable {
    private boolean mRadiusAdjustBounds = false;
    private ColorStateList mFillColors;
    private int mStrokeWidth = 0;
    private ColorStateList mStrokeColors;

    public void setBgData(@Nullable ColorStateList colors) {
        if (this.hasNativeStateListAPI()) {
            super.setColor(colors);
        } else {
            this.mFillColors = colors;
            int currentColor = colors == null ? 0 : colors.getColorForState(this.getState(), 0);
            this.setColor(currentColor);
        }
    }

    public void setStrokeData(int width, @Nullable ColorStateList colors) {
        if (this.hasNativeStateListAPI()) {
            super.setStroke(width, colors);
        } else {
            this.mStrokeWidth = width;
            this.mStrokeColors = colors;
            int currentColors = colors == null ? 0 : colors.getColorForState(this.getState(), 0);
            this.setStroke(width, currentColors);
        }
    }

    private boolean hasNativeStateListAPI() {
        return Build.VERSION.SDK_INT >= 21;
    }

    protected boolean onStateChange(int[] stateSet) {
        int color2;
        boolean superRet = super.onStateChange(stateSet);
        if (this.mFillColors != null) {
            color2 = this.mFillColors.getColorForState(stateSet, 0);
            this.setColor(color2);
            superRet = true;
        }
        if (this.mStrokeColors != null) {
            color2 = this.mStrokeColors.getColorForState(stateSet, 0);
            this.setStroke(this.mStrokeWidth, color2);
            superRet = true;
        }
        return superRet;
    }

    public boolean isStateful() {
        return this.mFillColors != null && this.mFillColors.isStateful() || this.mStrokeColors != null && this.mStrokeColors.isStateful() || super.isStateful();
    }

    public void setIsRadiusAdjustBounds(boolean isRadiusAdjustBounds) {
        this.mRadiusAdjustBounds = isRadiusAdjustBounds;
    }

    protected void onBoundsChange(Rect r) {
        super.onBoundsChange(r);
        if (this.mRadiusAdjustBounds) {
            this.setCornerRadius(Math.min(r.width(), r.height()) / 2);
        }
    }

    public void fromAttributeSet(Context context, AttributeSet attrs, int defStyleAttr) {
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.XRoundEditText, defStyleAttr, 0);
        ColorStateList colorBg = ta.getColorStateList(R.styleable.XRoundEditText_x_backgroundColor);
        ColorStateList colorBorder = ta.getColorStateList(R.styleable.XRoundEditText_x_borderColor);
        int borderWidth = ta.getDimensionPixelSize(R.styleable.XRoundEditText_x_borderWidth, 0);
        int mRadius = ta.getDimensionPixelSize(R.styleable.XRoundEditText_x_radius, 0);
        int mRadiusTopLeft = ta.getDimensionPixelSize(R.styleable.XRoundEditText_x_radiusTopLeft, 0);
        int mRadiusTopRight = ta.getDimensionPixelSize(R.styleable.XRoundEditText_x_radiusTopRight, 0);
        int mRadiusBottomLeft = ta.getDimensionPixelSize(R.styleable.XRoundEditText_x_radiusBottomLeft, 0);
        int mRadiusBottomRight = ta.getDimensionPixelSize(R.styleable.XRoundEditText_x_radiusBottomRight, 0);
        this.mRadiusAdjustBounds = ta.getBoolean(R.styleable.XRoundEditText_x_isRadiusAdjustBounds, false);
        ta.recycle();
        this.setBgData(colorBg);
        this.setStrokeData(borderWidth, colorBorder);
        if (mRadiusTopLeft > 0 || mRadiusTopRight > 0 || mRadiusBottomLeft > 0 || mRadiusBottomRight > 0) {
            float[] radii = new float[]{mRadiusTopLeft, mRadiusTopLeft, mRadiusTopRight, mRadiusTopRight, mRadiusBottomRight, mRadiusBottomRight, mRadiusBottomLeft, mRadiusBottomLeft};
            this.setCornerRadii(radii);
        } else {
            this.setCornerRadius(mRadius);
        }
        this.setIsRadiusAdjustBounds(this.mRadiusAdjustBounds);
    }
}

