/*
 * Decompiled with CFR 0.152.
 */
package kotyox.widget.roundrawable;

import android.content.res.ColorStateList;
import android.graphics.Rect;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.support.annotation.Nullable;

public class XRoundLayoutDrawable
extends GradientDrawable {
    private boolean mRadiusAdjustBounds = true;
    private ColorStateList mFillColors;
    private int mStrokeWidth = 0;
    private ColorStateList mStrokeColors;

    public void setBgData(@Nullable ColorStateList colors) {
        if (this.hasNativeStateListAPI()) {
            super.setColor(colors);
        } else {
            this.mFillColors = colors;
            int currentColor = colors == null ? 0 : colors.getColorForState(this.getState(), 0);
            this.setColor(currentColor);
        }
    }

    public void setStrokeData(int width, @Nullable ColorStateList colors) {
        if (this.hasNativeStateListAPI()) {
            super.setStroke(width, colors);
        } else {
            this.mStrokeWidth = width;
            this.mStrokeColors = colors;
            int currentColors = colors == null ? 0 : colors.getColorForState(this.getState(), 0);
            this.setStroke(width, currentColors);
        }
    }

    private boolean hasNativeStateListAPI() {
        return Build.VERSION.SDK_INT >= 21;
    }

    public void setIsRadiusAdjustBounds(boolean isRadiusAdjustBounds) {
        this.mRadiusAdjustBounds = isRadiusAdjustBounds;
    }

    protected boolean onStateChange(int[] stateSet) {
        int color2;
        boolean superRet = super.onStateChange(stateSet);
        if (this.mFillColors != null) {
            color2 = this.mFillColors.getColorForState(stateSet, 0);
            this.setColor(color2);
            superRet = true;
        }
        if (this.mStrokeColors != null) {
            color2 = this.mStrokeColors.getColorForState(stateSet, 0);
            this.setStroke(this.mStrokeWidth, color2);
            superRet = true;
        }
        return superRet;
    }

    public boolean isStateful() {
        return this.mFillColors != null && this.mFillColors.isStateful() || this.mStrokeColors != null && this.mStrokeColors.isStateful() || super.isStateful();
    }

    protected void onBoundsChange(Rect r) {
        super.onBoundsChange(r);
        if (this.mRadiusAdjustBounds) {
            this.setCornerRadius(Math.min(r.width(), r.height()) / 2);
        }
    }

    public void fromAttributeSet(ColorStateList colorBg, ColorStateList colorBorder, int borderWidth, int mRadiusTopLeft, int mRadiusTopRight, int mRadiusBottomLeft, int mRadiusBottomRight, boolean isRadiusAdjustBounds, int mRadius) {
        this.setBgData(colorBg);
        this.setStrokeData(borderWidth, colorBorder);
        if (mRadiusTopLeft > 0 || mRadiusTopRight > 0 || mRadiusBottomLeft > 0 || mRadiusBottomRight > 0) {
            float[] radii = new float[]{mRadiusTopLeft, mRadiusTopLeft, mRadiusTopRight, mRadiusTopRight, mRadiusBottomRight, mRadiusBottomRight, mRadiusBottomLeft, mRadiusBottomLeft};
            this.setCornerRadii(radii);
            isRadiusAdjustBounds = false;
        } else {
            this.setCornerRadius(mRadius);
            if (mRadius > 0) {
                isRadiusAdjustBounds = false;
            }
        }
        this.setIsRadiusAdjustBounds(isRadiusAdjustBounds);
    }
}

