/*
 * Decompiled with CFR 0.152.
 */
package kotyox.widget.state;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.View;
import android.widget.TextView;
import family.widget.com.roundwidget.R;
import java.lang.ref.WeakReference;
import kotyox.widget.roundrawable.XRoundDrawable;
import kotyoxutils.Px2DpUtil;
import kotyoxutils.XDrawableHelper;
import kotyoxutils.XViewHelper;

public class XRoundTextViewState {
    private Context mContext;
    private WeakReference<View> mReference;
    private ColorStateList mColorBg;
    private ColorStateList mColorBorder;
    private int mBorderWidth;
    private boolean mIsRadiusAdjustBounds;
    private boolean mGradientPressClick = true;
    private int mRadius;
    private int mRadiusTopLeft;
    private int mRadiusTopRight;
    private int mRadiusBottomLeft;
    private int mRadiusBottomRight;
    private ColorStateList mDisableColor;
    private ColorStateList mPressColor;
    private ColorStateList mSelectColor;
    private ColorStateList mUnSelectColor;
    private int mSelectTextColor;
    private int mUnSelectTextColor;
    private int mFontEnableColor;
    private int mFontPressColor;
    private int mFontDisableColor;
    private int mStartColor;
    private int mMiddleColor;
    private int mEndColor;
    private XRoundDrawable mEnableDrawable;
    private XRoundDrawable mPressDrawable;
    private XRoundDrawable mDisableDrawable;
    private XRoundDrawable mSelectDrawable;
    private XRoundDrawable mUnSelectDrawable;
    private View mView;
    private StateListDrawable mStateListDrawable;
    private int mGradientOrientation;

    public XRoundTextViewState(View view) {
        this.mReference = new WeakReference<View>(view);
        this.mEnableDrawable = new XRoundDrawable();
        this.mPressDrawable = new XRoundDrawable();
        this.mDisableDrawable = new XRoundDrawable();
        this.mSelectDrawable = new XRoundDrawable();
        this.mUnSelectDrawable = new XRoundDrawable();
        this.mView = (View)this.mReference.get();
        this.mContext = this.mView.getContext();
    }

    public void fromAttributeSet(Context context, AttributeSet set, int defStyleAttr) {
        TypedArray ta = context.obtainStyledAttributes(set, R.styleable.XRoundTextView, defStyleAttr, 0);
        this.mColorBg = ta.getColorStateList(R.styleable.XRoundTextView_x_backgroundColor);
        this.mColorBorder = ta.getColorStateList(R.styleable.XRoundTextView_x_borderColor);
        this.mBorderWidth = ta.getDimensionPixelSize(R.styleable.XRoundTextView_x_borderWidth, 0);
        this.mIsRadiusAdjustBounds = ta.getBoolean(R.styleable.XRoundTextView_x_isRadiusAdjustBounds, false);
        this.mGradientPressClick = ta.getBoolean(R.styleable.XRoundTextView_x_gradient_press_click, true);
        this.mRadius = ta.getDimensionPixelSize(R.styleable.XRoundTextView_x_radius, 0);
        this.mRadiusTopLeft = ta.getDimensionPixelSize(R.styleable.XRoundTextView_x_radiusTopLeft, 0);
        this.mRadiusTopRight = ta.getDimensionPixelSize(R.styleable.XRoundTextView_x_radiusTopRight, 0);
        this.mRadiusBottomLeft = ta.getDimensionPixelSize(R.styleable.XRoundTextView_x_radiusBottomLeft, 0);
        this.mRadiusBottomRight = ta.getDimensionPixelSize(R.styleable.XRoundTextView_x_radiusBottomRight, 0);
        this.mDisableColor = ta.getColorStateList(R.styleable.XRoundTextView_x_disableColor);
        this.mPressColor = ta.getColorStateList(R.styleable.XRoundTextView_x_pressColor);
        this.mSelectColor = ta.getColorStateList(R.styleable.XRoundTextView_x_selectColor);
        this.mUnSelectColor = ta.getColorStateList(R.styleable.XRoundTextView_x_unselectColor);
        this.mSelectTextColor = ta.getColor(R.styleable.XRoundTextView_x_selectTextColor, 0);
        this.mUnSelectTextColor = ta.getColor(R.styleable.XRoundTextView_x_unselectTextColor, 0);
        this.mFontEnableColor = ta.getColor(R.styleable.XRoundTextView_x_fontEnableColor, 0);
        this.mFontPressColor = ta.getColor(R.styleable.XRoundTextView_x_fontPressColor, 0);
        this.mFontDisableColor = ta.getColor(R.styleable.XRoundTextView_x_fontDisableColor, 0);
        this.mStartColor = ta.getColor(R.styleable.XRoundTextView_x_startColor, 0);
        this.mMiddleColor = ta.getColor(R.styleable.XRoundTextView_x_middleColor, 0);
        this.mEndColor = ta.getColor(R.styleable.XRoundTextView_x_endColor, 0);
        this.mGradientOrientation = ta.getInt(R.styleable.XRoundRelativeLayout_x_gradientOrientation, -1);
        this.build();
    }

    private void setDefaultColor() {
        if (this.mStartColor != 0) {
            if (this.mMiddleColor == 0) {
                this.mMiddleColor = this.mStartColor;
            }
            int[] colors = new int[]{this.mStartColor, this.mMiddleColor, this.mEndColor};
            this.mEnableDrawable.setColors(colors);
            this.mPressDrawable.setColors(colors);
            if (this.mRadius == 0) {
                float[] radii = new float[]{this.mRadiusTopLeft, this.mRadiusTopLeft, this.mRadiusTopRight, this.mRadiusTopRight, this.mRadiusBottomLeft, this.mRadiusBottomLeft, this.mRadiusBottomRight, this.mRadiusBottomRight};
                this.mEnableDrawable.setCornerRadii(radii);
                this.mPressDrawable.setCornerRadii(radii);
            } else {
                this.mEnableDrawable.setCornerRadius(this.mRadius);
                this.mPressDrawable.setCornerRadius(this.mRadius);
            }
            this.mEnableDrawable.setOrientation(XDrawableHelper.getOrientation(this.mGradientOrientation));
            this.mPressDrawable.setOrientation(XDrawableHelper.getOrientation(this.mGradientOrientation));
        }
        if (this.mUnSelectColor == null) {
            this.mUnSelectColor = this.mColorBg;
        }
        if (this.mFontPressColor == 0) {
            this.mFontPressColor = this.mFontEnableColor;
        }
        if (this.mPressColor == null) {
            this.mPressColor = this.mColorBg;
        }
        if (!this.mGradientPressClick && this.mStartColor != 0) {
            this.mView.setEnabled(false);
            this.mFontDisableColor = this.mFontEnableColor;
            this.mDisableDrawable = this.mEnableDrawable;
        }
    }

    public XRoundTextViewState build() {
        this.setDefaultColor();
        this.mEnableDrawable.fromAttributeSet(this.mColorBg, this.mColorBorder, this.mBorderWidth, this.mRadiusTopLeft, this.mRadiusTopRight, this.mRadiusBottomLeft, this.mRadiusBottomRight, this.mIsRadiusAdjustBounds, this.mRadius);
        this.mPressDrawable.fromAttributeSet(this.mPressColor, this.mColorBorder, this.mBorderWidth, this.mRadiusTopLeft, this.mRadiusTopRight, this.mRadiusBottomLeft, this.mRadiusBottomRight, this.mIsRadiusAdjustBounds, this.mRadius);
        this.mDisableDrawable.fromAttributeSet(this.mDisableColor, this.mColorBorder, this.mBorderWidth, this.mRadiusTopLeft, this.mRadiusTopRight, this.mRadiusBottomLeft, this.mRadiusBottomRight, this.mIsRadiusAdjustBounds, this.mRadius);
        this.mSelectDrawable.fromAttributeSet(this.mSelectColor, this.mColorBorder, this.mBorderWidth, this.mRadiusTopLeft, this.mRadiusTopRight, this.mRadiusBottomLeft, this.mRadiusBottomRight, this.mIsRadiusAdjustBounds, this.mRadius);
        this.mUnSelectDrawable.fromAttributeSet(this.mUnSelectColor, this.mColorBorder, this.mBorderWidth, this.mRadiusTopLeft, this.mRadiusTopRight, this.mRadiusBottomLeft, this.mRadiusBottomRight, this.mIsRadiusAdjustBounds, this.mRadius);
        this.mStateListDrawable = this.mSelectColor != null || this.mUnSelectColor != null ? XDrawableHelper.createStateListDrawable(this.mEnableDrawable, this.mPressDrawable, this.mDisableDrawable, this.mSelectDrawable, this.mUnSelectDrawable) : XDrawableHelper.createStateListDrawable(this.mEnableDrawable, this.mPressDrawable, this.mDisableDrawable);
        XViewHelper.setBackgroundKeepingPadding(this.mView, (Drawable)this.mStateListDrawable);
        if (this.mView instanceof TextView) {
            if (this.mSelectTextColor != 0) {
                ((TextView)this.mView).setTextColor(XDrawableHelper.createColorStateList(this.mFontEnableColor, this.mFontPressColor, this.mFontEnableColor, this.mFontDisableColor, this.mSelectTextColor, this.mUnSelectTextColor));
            } else {
                ((TextView)this.mView).setTextColor(XDrawableHelper.createColorStateList(this.mFontEnableColor, this.mFontPressColor, this.mFontEnableColor, this.mFontDisableColor));
            }
        }
        return this;
    }

    public XRoundTextViewState setBg(int colorBg) {
        this.mColorBg = XDrawableHelper.colorStateList(ContextCompat.getColor((Context)this.mContext, (int)colorBg));
        return this;
    }

    public XRoundTextViewState setColorBorder(int colorBorder) {
        this.mColorBorder = XDrawableHelper.colorStateList(ContextCompat.getColor((Context)this.mContext, (int)colorBorder));
        return this;
    }

    public XRoundTextViewState setBorderWidth(int borderWidth) {
        this.mBorderWidth = Px2DpUtil.dp2px(this.mContext, borderWidth);
        return this;
    }

    public XRoundTextViewState setIsRadiusAdjustBounds(boolean isRadiusAdjustBounds) {
        this.mIsRadiusAdjustBounds = isRadiusAdjustBounds;
        return this;
    }

    public XRoundTextViewState setRadius(int radius) {
        this.mRadius = Px2DpUtil.dp2px(this.mContext, radius);
        return this;
    }

    public XRoundTextViewState setTopLeft(int topLeft) {
        this.mRadiusTopLeft = Px2DpUtil.dp2px(this.mContext, topLeft);
        return this;
    }

    public XRoundTextViewState setTopRight(int topRight) {
        this.mRadiusTopRight = Px2DpUtil.dp2px(this.mContext, topRight);
        return this;
    }

    public XRoundTextViewState setBottomLeft(int bottomLeft) {
        this.mRadiusBottomLeft = Px2DpUtil.dp2px(this.mContext, bottomLeft);
        return this;
    }

    public XRoundTextViewState setBottomRight(int bottomRight) {
        this.mRadiusBottomRight = Px2DpUtil.dp2px(this.mContext, bottomRight);
        return this;
    }

    public XRoundTextViewState setPressColor(int pressColor) {
        this.mPressColor = XDrawableHelper.colorStateList(ContextCompat.getColor((Context)this.mContext, (int)pressColor));
        return this;
    }

    public XRoundTextViewState setDisableColor(int disableColor) {
        this.mDisableColor = XDrawableHelper.colorStateList(ContextCompat.getColor((Context)this.mContext, (int)disableColor));
        return this;
    }

    public XRoundTextViewState setSelectColor(int selectColor) {
        this.mSelectColor = XDrawableHelper.colorStateList(ContextCompat.getColor((Context)this.mContext, (int)selectColor));
        return this;
    }

    public XRoundTextViewState setUnSelectColor(int unSelectColor) {
        this.mUnSelectColor = XDrawableHelper.colorStateList(ContextCompat.getColor((Context)this.mContext, (int)unSelectColor));
        return this;
    }

    public XRoundTextViewState setSelectTextColor(int selectTextColor) {
        this.mSelectTextColor = ContextCompat.getColor((Context)this.mContext, (int)selectTextColor);
        return this;
    }

    public XRoundTextViewState setUnSelectTextColor(int unSelectTextColor) {
        this.mUnSelectTextColor = ContextCompat.getColor((Context)this.mContext, (int)unSelectTextColor);
        return this;
    }

    public XRoundTextViewState setFontEnableColor(int fontEnableColor) {
        this.mFontEnableColor = ContextCompat.getColor((Context)this.mContext, (int)fontEnableColor);
        return this;
    }

    public XRoundTextViewState setFontPressColor(int fontPressColor) {
        this.mFontPressColor = ContextCompat.getColor((Context)this.mContext, (int)fontPressColor);
        return this;
    }

    public XRoundTextViewState setFontDisableColor(int fontDisableColor) {
        this.mFontDisableColor = ContextCompat.getColor((Context)this.mContext, (int)fontDisableColor);
        return this;
    }

    public XRoundTextViewState setStartColor(int startColor) {
        this.mStartColor = ContextCompat.getColor((Context)this.mContext, (int)startColor);
        return this;
    }

    public XRoundTextViewState setMiddleColor(int middleColor) {
        this.mMiddleColor = ContextCompat.getColor((Context)this.mContext, (int)middleColor);
        return this;
    }

    public XRoundTextViewState setEndColor(int endColor) {
        this.mEndColor = ContextCompat.getColor((Context)this.mContext, (int)endColor);
        return this;
    }

    public XRoundTextViewState setGradientOrientation(int orientation) {
        this.mGradientOrientation = orientation;
        return this;
    }
}

