/*
 * Decompiled with CFR 0.152.
 */
package kotyoxutils;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.StateListDrawable;
import android.support.v7.content.res.AppCompatResources;
import kotyoxutils.EzLog;

public class XDrawableHelper {
    private static final Canvas sCanvas = new Canvas();

    public static Drawable getVectorDrawable(Context context, int resVector) {
        try {
            return AppCompatResources.getDrawable((Context)context, (int)resVector);
        }
        catch (Exception e) {
            EzLog.d("Error in getVectorDrawable. resVector=" + resVector + ", resName=" + context.getResources().getResourceName(resVector) + e.getMessage());
            return null;
        }
    }

    public static StateListDrawable createStateListDrawable(GradientDrawable enableDrawable, GradientDrawable pressDrawable, GradientDrawable disableDrawable) {
        StateListDrawable stateListDrawable = new StateListDrawable();
        stateListDrawable.addState(new int[]{16842919}, (Drawable)pressDrawable);
        stateListDrawable.addState(new int[]{-16842910}, (Drawable)disableDrawable);
        stateListDrawable.addState(new int[]{16842910}, (Drawable)enableDrawable);
        stateListDrawable.addState(new int[0], (Drawable)enableDrawable);
        return stateListDrawable;
    }

    public static StateListDrawable createStateListDrawable(GradientDrawable enableDrawable, GradientDrawable pressDrawable, GradientDrawable disableDrawable, GradientDrawable selectedDrawable, GradientDrawable unSelectedDrawable) {
        StateListDrawable stateListDrawable = new StateListDrawable();
        stateListDrawable.addState(new int[]{16842919}, (Drawable)pressDrawable);
        stateListDrawable.addState(new int[]{0x10100A1}, (Drawable)selectedDrawable);
        stateListDrawable.addState(new int[]{-16842913}, (Drawable)unSelectedDrawable);
        stateListDrawable.addState(new int[]{-16842910}, (Drawable)disableDrawable);
        stateListDrawable.addState(new int[]{16842910}, (Drawable)enableDrawable);
        stateListDrawable.addState(new int[0], (Drawable)enableDrawable);
        return stateListDrawable;
    }

    public static ColorStateList createColorStateList(int normal, int pressed, int focused, int unable) {
        int[] colors = new int[]{pressed, focused, normal, focused, unable, normal};
        int[][] states = new int[colors.length][];
        states[0] = new int[]{16842919, 16842910};
        states[1] = new int[]{16842910, 16842908};
        states[2] = new int[]{16842910};
        states[3] = new int[]{16842908};
        states[4] = new int[]{16842909};
        states[5] = new int[0];
        return new ColorStateList((int[][])states, colors);
    }

    public static ColorStateList createColorStateList(int normal, int pressed, int focused, int unable, int select, int unselect) {
        int[] colors = new int[]{pressed, select, unselect, focused, normal, focused, unable, normal};
        int[][] states = new int[colors.length][];
        states[0] = new int[]{16842919, 16842910};
        states[1] = new int[]{0x10100A1};
        states[2] = new int[]{-16842913};
        states[3] = new int[]{16842910, 16842908};
        states[4] = new int[]{16842910};
        states[5] = new int[]{16842908};
        states[6] = new int[]{16842909};
        states[7] = new int[0];
        return new ColorStateList((int[][])states, colors);
    }

    public static GradientDrawable.Orientation getOrientation(int orientation) {
        switch (orientation) {
            case 0: {
                return GradientDrawable.Orientation.TOP_BOTTOM;
            }
            case 1: {
                return GradientDrawable.Orientation.TR_BL;
            }
            case 2: {
                return GradientDrawable.Orientation.RIGHT_LEFT;
            }
            case 3: {
                return GradientDrawable.Orientation.BR_TL;
            }
            case 4: {
                return GradientDrawable.Orientation.BOTTOM_TOP;
            }
            case 5: {
                return GradientDrawable.Orientation.BL_TR;
            }
            case 6: {
                return GradientDrawable.Orientation.LEFT_RIGHT;
            }
            case 7: {
                return GradientDrawable.Orientation.TL_BR;
            }
        }
        return GradientDrawable.Orientation.LEFT_RIGHT;
    }

    public static ColorStateList colorStateList(int color2) {
        int[] colors = new int[]{color2};
        int[][] states = new int[colors.length][];
        states[0] = new int[0];
        return new ColorStateList((int[][])states, colors);
    }
}

