/*
 * Decompiled with CFR 0.152.
 */
package kotyoxutils;

import android.support.annotation.Nullable;
import java.io.Closeable;
import java.io.IOException;
import java.util.Locale;

public class XLangHelper {
    public static int getNumberDigits(int number) {
        if (number <= 0) {
            return 0;
        }
        return (int)(Math.log10(number) + 1.0);
    }

    public static int getNumberDigits(long number) {
        if (number <= 0L) {
            return 0;
        }
        return (int)(Math.log10(number) + 1.0);
    }

    public static String regularizePrice(float price) {
        return String.format(Locale.CHINESE, "%.2f", Float.valueOf(price));
    }

    public static String regularizePrice(double price) {
        return String.format(Locale.CHINESE, "%.2f", price);
    }

    public static boolean isNullOrEmpty(@Nullable CharSequence string) {
        return string == null || string.length() == 0;
    }

    public static void close(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean objectEquals(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    public static int constrain(int amount, int low, int high) {
        return amount < low ? low : (amount > high ? high : amount);
    }

    public static float constrain(float amount, float low, float high) {
        return amount < low ? low : (amount > high ? high : amount);
    }
}

