/*
 * Decompiled with CFR 0.152.
 */
package kotyoxutils;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.graphics.Rect;
import android.os.Build;
import android.util.Log;
import android.view.Display;
import android.view.DisplayCutout;
import android.view.View;
import android.view.Window;
import android.view.WindowInsets;
import android.view.WindowManager;
import java.lang.reflect.Method;
import kotyoxutils.XDeviceHelper;
import kotyoxutils.XDisplayHelper;
import kotyoxutils.XStatusBarHelper;

public class XNotchHelper {
    private static final String TAG = "QMUINotchHelper";
    private static final int NOTCH_IN_SCREEN_VOIO = 32;
    private static final String MIUI_NOTCH = "ro.miui.notch";
    private static Boolean sHasNotch = null;
    private static Rect sRotation0SafeInset = null;
    private static Rect sRotation90SafeInset = null;
    private static Rect sRotation180SafeInset = null;
    private static Rect sRotation270SafeInset = null;
    private static int[] sNotchSizeInHawei = null;
    private static Boolean sHuaweiIsNotchSetToShow = null;

    public static boolean hasNotchInVivo(Context context) {
        boolean ret;
        block4: {
            ret = false;
            try {
                ClassLoader cl = context.getClassLoader();
                Class<?> ftFeature = cl.loadClass("android.util.FtFeature");
                Method[] methods = ftFeature.getDeclaredMethods();
                if (methods == null) break block4;
                for (int i = 0; i < methods.length; ++i) {
                    Method method = methods[i];
                    if (!method.getName().equalsIgnoreCase("isFeatureSupport")) continue;
                    ret = (Boolean)method.invoke(ftFeature, 32);
                    break;
                }
            }
            catch (ClassNotFoundException e) {
                Log.i((String)TAG, (String)"hasNotchInVivo ClassNotFoundException");
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"hasNotchInVivo Exception");
            }
        }
        return ret;
    }

    public static boolean hasNotchInHuawei(Context context) {
        boolean hasNotch = false;
        try {
            ClassLoader cl = context.getClassLoader();
            Class<?> HwNotchSizeUtil = cl.loadClass("com.huawei.android.util.HwNotchSizeUtil");
            Method get = HwNotchSizeUtil.getMethod("hasNotchInScreen", new Class[0]);
            hasNotch = (Boolean)get.invoke(HwNotchSizeUtil, new Object[0]);
        }
        catch (ClassNotFoundException e) {
            Log.i((String)TAG, (String)"hasNotchInHuawei ClassNotFoundException");
        }
        catch (NoSuchMethodException e) {
            Log.e((String)TAG, (String)"hasNotchInHuawei NoSuchMethodException");
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"hasNotchInHuawei Exception");
        }
        return hasNotch;
    }

    public static boolean hasNotchInOppo(Context context) {
        return context.getPackageManager().hasSystemFeature("com.oppo.feature.screen.heteromorphism");
    }

    @SuppressLint(value={"PrivateApi"})
    public static boolean hasNotchInXiaomi(Context context) {
        try {
            Class<?> spClass = Class.forName("android.os.SystemProperties");
            Method getMethod = spClass.getDeclaredMethod("getInt", String.class, Integer.TYPE);
            getMethod.setAccessible(true);
            int hasNotch = (Integer)getMethod.invoke(null, MIUI_NOTCH, 0);
            return hasNotch == 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean hasNotch(View view) {
        if (sHasNotch == null) {
            if (XNotchHelper.isNotchOfficialSupport()) {
                if (!XNotchHelper.attachHasOfficialNotch(view)) {
                    return false;
                }
            } else {
                sHasNotch = XNotchHelper.has3rdNotch(view.getContext());
            }
        }
        return sHasNotch;
    }

    public static boolean hasNotch(Activity activity) {
        if (sHasNotch == null) {
            if (XNotchHelper.isNotchOfficialSupport()) {
                Window window = activity.getWindow();
                if (window == null) {
                    return false;
                }
                View decorView = window.getDecorView();
                if (decorView == null) {
                    return false;
                }
                if (!XNotchHelper.attachHasOfficialNotch(decorView)) {
                    return false;
                }
            } else {
                sHasNotch = XNotchHelper.has3rdNotch((Context)activity);
            }
        }
        return sHasNotch;
    }

    @TargetApi(value=28)
    private static boolean attachHasOfficialNotch(View view) {
        WindowInsets windowInsets = view.getRootWindowInsets();
        if (windowInsets != null) {
            DisplayCutout displayCutout = windowInsets.getDisplayCutout();
            sHasNotch = displayCutout != null;
            return true;
        }
        return false;
    }

    public static boolean has3rdNotch(Context context) {
        if (XDeviceHelper.isHuawei()) {
            return XNotchHelper.hasNotchInHuawei(context);
        }
        if (XDeviceHelper.isVivo()) {
            return XNotchHelper.hasNotchInVivo(context);
        }
        if (XDeviceHelper.isOppo()) {
            return XNotchHelper.hasNotchInOppo(context);
        }
        if (XDeviceHelper.isXiaomi()) {
            return XNotchHelper.hasNotchInXiaomi(context);
        }
        return false;
    }

    public static int getSafeInsetTop(Activity activity) {
        if (!XNotchHelper.hasNotch(activity)) {
            return 0;
        }
        return XNotchHelper.getSafeInsetRect((Activity)activity).top;
    }

    public static int getSafeInsetBottom(Activity activity) {
        if (!XNotchHelper.hasNotch(activity)) {
            return 0;
        }
        return XNotchHelper.getSafeInsetRect((Activity)activity).bottom;
    }

    public static int getSafeInsetLeft(Activity activity) {
        if (!XNotchHelper.hasNotch(activity)) {
            return 0;
        }
        return XNotchHelper.getSafeInsetRect((Activity)activity).left;
    }

    public static int getSafeInsetRight(Activity activity) {
        if (!XNotchHelper.hasNotch(activity)) {
            return 0;
        }
        return XNotchHelper.getSafeInsetRect((Activity)activity).right;
    }

    public static int getSafeInsetTop(View view) {
        if (!XNotchHelper.hasNotch(view)) {
            return 0;
        }
        return XNotchHelper.getSafeInsetRect((View)view).top;
    }

    public static int getSafeInsetBottom(View view) {
        if (!XNotchHelper.hasNotch(view)) {
            return 0;
        }
        return XNotchHelper.getSafeInsetRect((View)view).bottom;
    }

    public static int getSafeInsetLeft(View view) {
        if (!XNotchHelper.hasNotch(view)) {
            return 0;
        }
        return XNotchHelper.getSafeInsetRect((View)view).left;
    }

    public static int getSafeInsetRight(View view) {
        if (!XNotchHelper.hasNotch(view)) {
            return 0;
        }
        return XNotchHelper.getSafeInsetRect((View)view).right;
    }

    private static void clearAllRectInfo() {
        sRotation0SafeInset = null;
        sRotation90SafeInset = null;
        sRotation180SafeInset = null;
        sRotation270SafeInset = null;
    }

    private static void clearPortraitRectInfo() {
        sRotation0SafeInset = null;
        sRotation180SafeInset = null;
    }

    private static void clearLandscapeRectInfo() {
        sRotation90SafeInset = null;
        sRotation270SafeInset = null;
    }

    private static Rect getSafeInsetRect(Activity activity) {
        if (XNotchHelper.isNotchOfficialSupport()) {
            Rect rect = new Rect();
            View decorView = activity.getWindow().getDecorView();
            XNotchHelper.getOfficialSafeInsetRect(decorView, rect);
            return rect;
        }
        return XNotchHelper.get3rdSafeInsetRect((Context)activity);
    }

    private static Rect getSafeInsetRect(View view) {
        if (XNotchHelper.isNotchOfficialSupport()) {
            Rect rect = new Rect();
            XNotchHelper.getOfficialSafeInsetRect(view, rect);
            return rect;
        }
        return XNotchHelper.get3rdSafeInsetRect(view.getContext());
    }

    @TargetApi(value=28)
    private static void getOfficialSafeInsetRect(View view, Rect out) {
        if (view == null) {
            return;
        }
        WindowInsets rootWindowInsets = view.getRootWindowInsets();
        if (rootWindowInsets == null) {
            return;
        }
        DisplayCutout displayCutout = rootWindowInsets.getDisplayCutout();
        if (displayCutout != null) {
            out.set(displayCutout.getSafeInsetLeft(), displayCutout.getSafeInsetTop(), displayCutout.getSafeInsetRight(), displayCutout.getSafeInsetBottom());
        }
    }

    private static Rect get3rdSafeInsetRect(Context context) {
        int screenRotation;
        if (XDeviceHelper.isHuawei()) {
            boolean isHuaweiNotchSetToShow = XDisplayHelper.huaweiIsNotchSetToShowInSetting(context);
            if (sHuaweiIsNotchSetToShow != null && sHuaweiIsNotchSetToShow != isHuaweiNotchSetToShow) {
                XNotchHelper.clearLandscapeRectInfo();
            }
            sHuaweiIsNotchSetToShow = isHuaweiNotchSetToShow;
        }
        if ((screenRotation = XNotchHelper.getScreenRotation(context)) == 1) {
            if (sRotation90SafeInset == null) {
                sRotation90SafeInset = XNotchHelper.getRectInfoRotation90(context);
            }
            return sRotation90SafeInset;
        }
        if (screenRotation == 2) {
            if (sRotation180SafeInset == null) {
                sRotation180SafeInset = XNotchHelper.getRectInfoRotation180(context);
            }
            return sRotation180SafeInset;
        }
        if (screenRotation == 3) {
            if (sRotation270SafeInset == null) {
                sRotation270SafeInset = XNotchHelper.getRectInfoRotation270(context);
            }
            return sRotation270SafeInset;
        }
        if (sRotation0SafeInset == null) {
            sRotation0SafeInset = XNotchHelper.getRectInfoRotation0(context);
        }
        return sRotation0SafeInset;
    }

    private static Rect getRectInfoRotation0(Context context) {
        Rect rect = new Rect();
        if (XDeviceHelper.isVivo()) {
            rect.top = XNotchHelper.getNotchHeightInVivo(context);
            rect.bottom = 0;
        } else if (XDeviceHelper.isOppo()) {
            rect.top = XStatusBarHelper.getStatusbarHeight(context);
            rect.bottom = 0;
        } else if (XDeviceHelper.isHuawei()) {
            int[] notchSize = XNotchHelper.getNotchSizeInHuawei(context);
            rect.top = notchSize[1];
            rect.bottom = 0;
        } else if (XDeviceHelper.isXiaomi()) {
            rect.top = XNotchHelper.getNotchHeightInXiaomi(context);
            rect.bottom = 0;
        }
        return rect;
    }

    private static Rect getRectInfoRotation90(Context context) {
        Rect rect = new Rect();
        if (XDeviceHelper.isVivo()) {
            rect.left = XNotchHelper.getNotchHeightInVivo(context);
            rect.right = 0;
        } else if (XDeviceHelper.isOppo()) {
            rect.left = XStatusBarHelper.getStatusbarHeight(context);
            rect.right = 0;
        } else if (XDeviceHelper.isHuawei()) {
            rect.left = sHuaweiIsNotchSetToShow != false ? XNotchHelper.getNotchSizeInHuawei(context)[1] : 0;
            rect.right = 0;
        } else if (XDeviceHelper.isXiaomi()) {
            rect.left = XNotchHelper.getNotchHeightInXiaomi(context);
            rect.right = 0;
        }
        return rect;
    }

    private static Rect getRectInfoRotation180(Context context) {
        Rect rect = new Rect();
        if (XDeviceHelper.isVivo()) {
            rect.top = 0;
            rect.bottom = XNotchHelper.getNotchHeightInVivo(context);
        } else if (XDeviceHelper.isOppo()) {
            rect.top = 0;
            rect.bottom = XStatusBarHelper.getStatusbarHeight(context);
        } else if (XDeviceHelper.isHuawei()) {
            int[] notchSize = XNotchHelper.getNotchSizeInHuawei(context);
            rect.top = 0;
            rect.bottom = notchSize[1];
        } else if (XDeviceHelper.isXiaomi()) {
            rect.top = 0;
            rect.bottom = XNotchHelper.getNotchHeightInXiaomi(context);
        }
        return rect;
    }

    private static Rect getRectInfoRotation270(Context context) {
        Rect rect = new Rect();
        if (XDeviceHelper.isVivo()) {
            rect.right = XNotchHelper.getNotchHeightInVivo(context);
            rect.left = 0;
        } else if (XDeviceHelper.isOppo()) {
            rect.right = XStatusBarHelper.getStatusbarHeight(context);
            rect.left = 0;
        } else if (XDeviceHelper.isHuawei()) {
            rect.right = sHuaweiIsNotchSetToShow != false ? XNotchHelper.getNotchSizeInHuawei(context)[1] : 0;
            rect.left = 0;
        } else if (XDeviceHelper.isXiaomi()) {
            rect.right = XNotchHelper.getNotchHeightInXiaomi(context);
            rect.left = 0;
        }
        return rect;
    }

    public static int[] getNotchSizeInHuawei(Context context) {
        if (sNotchSizeInHawei == null) {
            sNotchSizeInHawei = new int[]{0, 0};
            try {
                ClassLoader cl = context.getClassLoader();
                Class<?> HwNotchSizeUtil = cl.loadClass("com.huawei.android.util.HwNotchSizeUtil");
                Method get = HwNotchSizeUtil.getMethod("getNotchSize", new Class[0]);
                sNotchSizeInHawei = (int[])get.invoke(HwNotchSizeUtil, new Object[0]);
            }
            catch (ClassNotFoundException e) {
                Log.e((String)TAG, (String)"getNotchSizeInHuawei ClassNotFoundException");
            }
            catch (NoSuchMethodException e) {
                Log.e((String)TAG, (String)"getNotchSizeInHuawei NoSuchMethodException");
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"getNotchSizeInHuawei Exception");
            }
        }
        return sNotchSizeInHawei;
    }

    public static int getNotchWidthInXiaomi(Context context) {
        int resourceId = context.getResources().getIdentifier("notch_width", "dimen", "android");
        if (resourceId > 0) {
            return context.getResources().getDimensionPixelSize(resourceId);
        }
        return -1;
    }

    public static int getNotchHeightInXiaomi(Context context) {
        int resourceId = context.getResources().getIdentifier("notch_height", "dimen", "android");
        if (resourceId > 0) {
            return context.getResources().getDimensionPixelSize(resourceId);
        }
        return XDisplayHelper.getStatusBarHeight(context);
    }

    public static int getNotchWidthInVivo(Context context) {
        return XDisplayHelper.dp2px(context, 100);
    }

    public static int getNotchHeightInVivo(Context context) {
        return XDisplayHelper.dp2px(context, 27);
    }

    private static int getScreenRotation(Context context) {
        WindowManager w = (WindowManager)context.getSystemService("window");
        if (w == null) {
            return 0;
        }
        Display display = w.getDefaultDisplay();
        if (display == null) {
            return 0;
        }
        return display.getRotation();
    }

    public static boolean isNotchOfficialSupport() {
        return Build.VERSION.SDK_INT >= 28;
    }
}

