/*
 * Decompiled with CFR 0.152.
 */
package cn.zkdcloud.util;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.ClassFile;
import javassist.bytecode.annotation.Annotation;
import org.apache.commons.io.FileUtils;

public class FileUtil {
    private static ClassLoader classLoader = Thread.currentThread().getContextClassLoader();

    public static List<URL> getDefaultURL() {
        ArrayList<URL> rets = new ArrayList<URL>();
        String defaultPath = classLoader.getResource("").getPath();
        rets.addAll(FileUtil.getDirURL(defaultPath));
        rets.addAll(FileUtil.getJarUrl(defaultPath, ".class"));
        return rets;
    }

    public static List<URL> getDirURL(String defaultDirPath) {
        ArrayList<URL> rets = new ArrayList<URL>();
        File defaultDir = new File(defaultDirPath);
        if (defaultDir.isDirectory()) {
            Collection listFiles = FileUtils.listFiles((File)defaultDir, (String[])new String[]{"class"}, (boolean)true);
            for (File file : listFiles) {
                try {
                    rets.add(file.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }
            return rets;
        }
        return rets;
    }

    public static List<URL> getJarUrl(String defaultDirPath, String suffix) {
        ArrayList<URL> ret = new ArrayList<URL>();
        if (defaultDirPath.contains(".jar")) {
            if (defaultDirPath.startsWith("file:/")) {
                defaultDirPath = defaultDirPath.substring(5);
            }
            String originJarPath = defaultDirPath.substring(0, defaultDirPath.lastIndexOf(".jar") + 4);
            String commonPath = defaultDirPath.substring(originJarPath.length() + 2).replaceAll("!", "");
            defaultDirPath = originJarPath + "!/";
            defaultDirPath = !defaultDirPath.startsWith("/") ? "jar:file:/" + defaultDirPath : "jar:file:" + defaultDirPath;
            if (!defaultDirPath.endsWith("!/")) {
                defaultDirPath = defaultDirPath.substring(0, defaultDirPath.lastIndexOf(".jar4")) + "!/";
            }
            try {
                URL jarFileURL = URI.create(defaultDirPath).toURL();
                JarFile jarFile = new JarFile(originJarPath);
                Enumeration<JarEntry> entryEnumeration = jarFile.entries();
                while (entryEnumeration.hasMoreElements()) {
                    JarEntry jarEntry = entryEnumeration.nextElement();
                    if (!jarEntry.getName().startsWith(commonPath) || !jarEntry.getName().endsWith(suffix)) continue;
                    ret.add(new URL(jarFileURL, jarEntry.getName()));
                }
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public static List<Class> getDefaultClass() {
        ArrayList<Class> rets = new ArrayList<Class>();
        List<URL> urls = FileUtil.getDefaultURL();
        for (URL url : urls) {
            try {
                ClassFile classFile = new ClassFile(new DataInputStream(url.openStream()));
                String clazzName = classFile.getName();
                Class<?> clazz = classLoader.loadClass(clazzName);
                rets.add(clazz);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return rets;
    }

    public static List<Class> getClassByAnnotion(String annotationName) {
        ArrayList<Class> rets = new ArrayList<Class>();
        List<URL> urls = FileUtil.getDefaultURL();
        block3: for (URL url : urls) {
            try {
                ClassFile classFile = new ClassFile(new DataInputStream(url.openStream()));
                AnnotationsAttribute annotationsAttribute = (AnnotationsAttribute)classFile.getAttribute("RuntimeVisibleAnnotations");
                if (annotationsAttribute == null) continue;
                for (Annotation annotation : annotationsAttribute.getAnnotations()) {
                    if (!annotation.getTypeName().equals(annotationName)) continue;
                    String clazzName = classFile.getName();
                    Class<?> clazz = classLoader.loadClass(clazzName);
                    rets.add(clazz);
                    continue block3;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return rets;
    }
}

