/*
 * Decompiled with CFR 0.152.
 */
package com.wdullaer.materialdatetimepicker.date;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.AppCompatTextView;
import android.util.AttributeSet;
import com.wdullaer.materialdatetimepicker.R;

public class TextViewWithCircularIndicator
extends AppCompatTextView {
    private static final int SELECTED_CIRCLE_ALPHA = 255;
    Paint mCirclePaint = new Paint();
    private int mCircleColor;
    private final String mItemIsSelectedText;
    private boolean mDrawCircle;

    public TextViewWithCircularIndicator(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mCircleColor = ContextCompat.getColor((Context)context, (int)R.color.mdtp_accent_color);
        this.mItemIsSelectedText = context.getResources().getString(R.string.mdtp_item_is_selected);
        this.init();
    }

    private void init() {
        this.mCirclePaint.setFakeBoldText(true);
        this.mCirclePaint.setAntiAlias(true);
        this.mCirclePaint.setColor(this.mCircleColor);
        this.mCirclePaint.setTextAlign(Paint.Align.CENTER);
        this.mCirclePaint.setStyle(Paint.Style.FILL);
        this.mCirclePaint.setAlpha(255);
    }

    public void setAccentColor(int color2, boolean darkMode) {
        this.mCircleColor = color2;
        this.mCirclePaint.setColor(this.mCircleColor);
        this.setTextColor(this.createTextColor(color2, darkMode));
    }

    private ColorStateList createTextColor(int accentColor, boolean darkMode) {
        int[][] states = new int[][]{{16842919}, {0x10100A1}, new int[0]};
        int[] colors = new int[]{accentColor, -1, darkMode ? -1 : -16777216};
        return new ColorStateList((int[][])states, colors);
    }

    public void drawIndicator(boolean drawCircle) {
        this.mDrawCircle = drawCircle;
    }

    public void onDraw(@NonNull Canvas canvas) {
        if (this.mDrawCircle) {
            int width = this.getWidth();
            int height = this.getHeight();
            int radius = Math.min(width, height) / 2;
            canvas.drawCircle((float)(width / 2), (float)(height / 2), (float)radius, this.mCirclePaint);
        }
        this.setSelected(this.mDrawCircle);
        super.onDraw(canvas);
    }

    public CharSequence getContentDescription() {
        CharSequence itemText = this.getText();
        if (this.mDrawCircle) {
            return String.format(this.mItemIsSelectedText, itemText);
        }
        return itemText;
    }
}

