/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.animation.keyframe;

import com.airbnb.lottie.animation.keyframe.KeyframeAnimation;
import com.airbnb.lottie.utils.MiscUtils;
import com.airbnb.lottie.value.Keyframe;
import java.util.List;

public class FloatKeyframeAnimation
extends KeyframeAnimation<Float> {
    public FloatKeyframeAnimation(List<Keyframe<Float>> keyframes) {
        super(keyframes);
    }

    @Override
    Float getValue(Keyframe<Float> keyframe, float keyframeProgress) {
        return Float.valueOf(this.getFloatValue(keyframe, keyframeProgress));
    }

    float getFloatValue(Keyframe<Float> keyframe, float keyframeProgress) {
        Float value;
        if (keyframe.startValue == null || keyframe.endValue == null) {
            throw new IllegalStateException("Missing values for keyframe.");
        }
        if (this.valueCallback != null && (value = (Float)this.valueCallback.getValueInternal(keyframe.startFrame, keyframe.endFrame.floatValue(), keyframe.startValue, keyframe.endValue, keyframeProgress, this.getLinearCurrentKeyframeProgress(), this.getProgress())) != null) {
            return value.floatValue();
        }
        return MiscUtils.lerp(keyframe.getStartValueFloat(), keyframe.getEndValueFloat(), keyframeProgress);
    }

    public float getFloatValue() {
        return this.getFloatValue(this.getCurrentKeyframe(), this.getInterpolatedCurrentKeyframeProgress());
    }
}

