/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.parser;

import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.model.FontCharacter;
import com.airbnb.lottie.model.content.ShapeGroup;
import com.airbnb.lottie.parser.ContentModelParser;
import com.airbnb.lottie.parser.moshi.JsonReader;
import java.io.IOException;
import java.util.ArrayList;

class FontCharacterParser {
    private static final JsonReader.Options NAMES = JsonReader.Options.of("ch", "size", "w", "style", "fFamily", "data");
    private static final JsonReader.Options DATA_NAMES = JsonReader.Options.of("shapes");

    private FontCharacterParser() {
    }

    static FontCharacter parse(JsonReader reader, LottieComposition composition) throws IOException {
        char character = '\u0000';
        double size = 0.0;
        double width = 0.0;
        String style = null;
        String fontFamily = null;
        ArrayList<ShapeGroup> shapes = new ArrayList<ShapeGroup>();
        reader.beginObject();
        block11: while (reader.hasNext()) {
            switch (reader.selectName(NAMES)) {
                case 0: {
                    character = reader.nextString().charAt(0);
                    continue block11;
                }
                case 1: {
                    size = reader.nextDouble();
                    continue block11;
                }
                case 2: {
                    width = reader.nextDouble();
                    continue block11;
                }
                case 3: {
                    style = reader.nextString();
                    continue block11;
                }
                case 4: {
                    fontFamily = reader.nextString();
                    continue block11;
                }
                case 5: {
                    reader.beginObject();
                    block12: while (reader.hasNext()) {
                        switch (reader.selectName(DATA_NAMES)) {
                            case 0: {
                                reader.beginArray();
                                while (reader.hasNext()) {
                                    shapes.add((ShapeGroup)ContentModelParser.parse(reader, composition));
                                }
                                reader.endArray();
                                continue block12;
                            }
                        }
                        reader.skipName();
                        reader.skipValue();
                    }
                    reader.endObject();
                    continue block11;
                }
            }
            reader.skipName();
            reader.skipValue();
        }
        reader.endObject();
        return new FontCharacter(shapes, character, size, width, style, fontFamily);
    }
}

