/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.parser;

import com.airbnb.lottie.model.Font;
import com.airbnb.lottie.parser.moshi.JsonReader;
import java.io.IOException;

class FontParser {
    private static final JsonReader.Options NAMES = JsonReader.Options.of("fFamily", "fName", "fStyle", "ascent");

    private FontParser() {
    }

    static Font parse(JsonReader reader) throws IOException {
        String family = null;
        String name = null;
        String style = null;
        float ascent = 0.0f;
        reader.beginObject();
        block6: while (reader.hasNext()) {
            switch (reader.selectName(NAMES)) {
                case 0: {
                    family = reader.nextString();
                    continue block6;
                }
                case 1: {
                    name = reader.nextString();
                    continue block6;
                }
                case 2: {
                    style = reader.nextString();
                    continue block6;
                }
                case 3: {
                    ascent = (float)reader.nextDouble();
                    continue block6;
                }
            }
            reader.skipName();
            reader.skipValue();
        }
        reader.endObject();
        return new Font(family, name, style, ascent);
    }
}

