/*
 * Decompiled with CFR 0.152.
 */
package com.ql.util.express;

import com.ql.util.express.CallResult;
import com.ql.util.express.ExpressLoader;
import com.ql.util.express.ExpressRunner;
import com.ql.util.express.IExpressContext;
import com.ql.util.express.InstructionSet;
import com.ql.util.express.InstructionSetContext;
import com.ql.util.express.RunEnvironment;
import com.ql.util.express.config.QLExpressTimer;
import com.ql.util.express.instruction.OperateDataCacheManager;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InstructionSetRunner {
    private static final Log log = LogFactory.getLog(InstructionSetRunner.class);

    private InstructionSetRunner() {
        throw new IllegalStateException("Utility class");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object executeOuter(ExpressRunner runner, InstructionSet instructionSet, ExpressLoader loader, IExpressContext<String, Object> iExpressContext, List<String> errorList, boolean isTrace, boolean isCatchException, Log log, boolean isSupportDynamicFieldName) throws Exception {
        try {
            QLExpressTimer.startTimer();
            OperateDataCacheManager.push(runner);
            Object object = InstructionSetRunner.execute(runner, instructionSet, loader, iExpressContext, errorList, isTrace, isCatchException, true, log, isSupportDynamicFieldName);
            return object;
        }
        finally {
            OperateDataCacheManager.resetCache();
        }
    }

    public static Object execute(ExpressRunner runner, InstructionSet instructionSet, ExpressLoader loader, IExpressContext<String, Object> iExpressContext, List<String> errorList, boolean isTrace, boolean isCatchException, boolean isReturnLastData, Log log, boolean isSupportDynamicFieldName) throws Exception {
        InstructionSetContext context = OperateDataCacheManager.fetchInstructionSetContext(true, runner, iExpressContext, loader, isSupportDynamicFieldName);
        return InstructionSetRunner.execute(instructionSet, context, errorList, isTrace, isCatchException, isReturnLastData, log);
    }

    public static Object execute(InstructionSet set, InstructionSetContext context, List<String> errorList, boolean isTrace, boolean isCatchException, boolean isReturnLastData, Log log) throws Exception {
        Object result = null;
        RunEnvironment environment = OperateDataCacheManager.fetRunEnvironment(set, context, isTrace);
        try {
            CallResult tempResult = set.execute(environment, context, errorList, isReturnLastData, log);
            if (tempResult.isExit()) {
                result = tempResult.getReturnValue();
            }
        }
        catch (Exception e) {
            if (isCatchException) {
                if (log != null) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                } else {
                    InstructionSetRunner.log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            throw e;
        }
        return result;
    }
}

