/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.android.arouter.compiler.processor;

import com.alibaba.android.arouter.compiler.utils.Logger;
import com.alibaba.android.arouter.compiler.utils.TypeUtils;
import com.alibaba.android.arouter.facade.annotation.Autowired;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.android.arouter.facade.enums.RouteType;
import com.alibaba.android.arouter.facade.model.RouteMeta;
import com.google.auto.service.AutoService;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.WildcardTypeName;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

@SupportedOptions(value={"moduleName"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_7)
@SupportedAnnotationTypes(value={"com.alibaba.android.arouter.facade.annotation.Route", "com.alibaba.android.arouter.facade.annotation.Autowired"})
@AutoService(value=Processor.class)
public class RouteProcessor
extends AbstractProcessor {
    private Map<String, Set<RouteMeta>> groupMap = new HashMap<String, Set<RouteMeta>>();
    private Map<String, String> rootMap = new TreeMap<String, String>();
    private Filer mFiler;
    private Logger logger;
    private Types types;
    private Elements elements;
    private TypeUtils typeUtils;
    private String moduleName = null;
    private TypeMirror iProvider = null;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.mFiler = processingEnv.getFiler();
        this.types = processingEnv.getTypeUtils();
        this.elements = processingEnv.getElementUtils();
        this.typeUtils = new TypeUtils(this.types, this.elements);
        this.logger = new Logger(processingEnv.getMessager());
        Map<String, String> options = processingEnv.getOptions();
        if (MapUtils.isNotEmpty(options)) {
            this.moduleName = options.get("moduleName");
        }
        if (!StringUtils.isNotEmpty((CharSequence)this.moduleName)) {
            this.logger.error("These no module name, at 'build.gradle', like :\napt {\n    arguments {\n        moduleName project.getName();\n    }\n}\n");
            throw new RuntimeException("ARouter::Compiler >>> No module name, for more information, look at gradle log.");
        }
        this.moduleName = this.moduleName.replaceAll("[^0-9a-zA-Z_]+", "");
        this.logger.info("The user has configuration the module name, it was [" + this.moduleName + "]");
        this.iProvider = this.elements.getTypeElement("com.alibaba.android.arouter.facade.template.IProvider").asType();
        this.logger.info(">>> RouteProcessor init. <<<");
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (CollectionUtils.isNotEmpty(annotations)) {
            Set<? extends Element> routeElements = roundEnv.getElementsAnnotatedWith(Route.class);
            try {
                this.logger.info(">>> Found routes, start... <<<");
                this.parseRoutes(routeElements);
            }
            catch (Exception e) {
                this.logger.error(e);
            }
            return true;
        }
        return false;
    }

    private void parseRoutes(Set<? extends Element> routeElements) throws IOException {
        if (CollectionUtils.isNotEmpty(routeElements)) {
            this.logger.info(">>> Found routes, size is " + routeElements.size() + " <<<");
            this.rootMap.clear();
            TypeMirror type_Activity = this.elements.getTypeElement("android.app.Activity").asType();
            TypeMirror type_Service = this.elements.getTypeElement("android.app.Service").asType();
            TypeMirror fragmentTm = this.elements.getTypeElement("android.app.Fragment").asType();
            TypeMirror fragmentTmV4 = this.elements.getTypeElement("android.support.v4.app.Fragment").asType();
            TypeElement type_IRouteGroup = this.elements.getTypeElement("com.alibaba.android.arouter.facade.template.IRouteGroup");
            TypeElement type_IProviderGroup = this.elements.getTypeElement("com.alibaba.android.arouter.facade.template.IProviderGroup");
            ClassName routeMetaCn = ClassName.get(RouteMeta.class);
            ClassName routeTypeCn = ClassName.get(RouteType.class);
            ParameterizedTypeName inputMapTypeOfRoot = ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{ClassName.get(String.class), ParameterizedTypeName.get((ClassName)ClassName.get(Class.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf((TypeName)ClassName.get((TypeElement)type_IRouteGroup))})});
            ParameterizedTypeName inputMapTypeOfGroup = ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{ClassName.get(String.class), ClassName.get(RouteMeta.class)});
            ParameterSpec rootParamSpec = ParameterSpec.builder((TypeName)inputMapTypeOfRoot, (String)"routes", (Modifier[])new Modifier[0]).build();
            ParameterSpec groupParamSpec = ParameterSpec.builder((TypeName)inputMapTypeOfGroup, (String)"atlas", (Modifier[])new Modifier[0]).build();
            ParameterSpec providerParamSpec = ParameterSpec.builder((TypeName)inputMapTypeOfGroup, (String)"providers", (Modifier[])new Modifier[0]).build();
            MethodSpec.Builder loadIntoMethodOfRootBuilder = MethodSpec.methodBuilder((String)"loadInto").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(rootParamSpec);
            for (Element element : routeElements) {
                TypeMirror typeMirror = element.asType();
                Route route = element.getAnnotation(Route.class);
                RouteMeta routeMete = null;
                if (this.types.isSubtype(typeMirror, type_Activity)) {
                    this.logger.info(">>> Found activity route: " + typeMirror.toString() + " <<<");
                    HashMap<String, Integer> paramsType = new HashMap<String, Integer>();
                    for (Element element2 : element.getEnclosedElements()) {
                        if (!element2.getKind().isField() || element2.getAnnotation(Autowired.class) == null || this.types.isSubtype(element2.asType(), this.iProvider)) continue;
                        Autowired paramConfig = element2.getAnnotation(Autowired.class);
                        paramsType.put(StringUtils.isEmpty((CharSequence)paramConfig.name()) ? element2.getSimpleName().toString() : paramConfig.name(), this.typeUtils.typeExchange(element2));
                    }
                    routeMete = new RouteMeta(route, element, RouteType.ACTIVITY, paramsType);
                } else if (this.types.isSubtype(typeMirror, this.iProvider)) {
                    this.logger.info(">>> Found provider route: " + typeMirror.toString() + " <<<");
                    routeMete = new RouteMeta(route, element, RouteType.PROVIDER, null);
                } else if (this.types.isSubtype(typeMirror, type_Service)) {
                    this.logger.info(">>> Found service route: " + typeMirror.toString() + " <<<");
                    routeMete = new RouteMeta(route, element, RouteType.parse((String)"android.app.Service"), null);
                } else if (this.types.isSubtype(typeMirror, fragmentTm) || this.types.isSubtype(typeMirror, fragmentTmV4)) {
                    this.logger.info(">>> Found fragment route: " + typeMirror.toString() + " <<<");
                    routeMete = new RouteMeta(route, element, RouteType.parse((String)"android.app.Fragment"), null);
                }
                this.categories(routeMete);
            }
            MethodSpec.Builder loadIntoMethodOfProviderBuilder = MethodSpec.methodBuilder((String)"loadInto").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(providerParamSpec);
            for (Map.Entry<String, Set<RouteMeta>> entry : this.groupMap.entrySet()) {
                String groupName = entry.getKey();
                MethodSpec.Builder loadIntoMethodOfGroupBuilder = MethodSpec.methodBuilder((String)"loadInto").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(groupParamSpec);
                Set<RouteMeta> groupData = entry.getValue();
                for (RouteMeta routeMeta : groupData) {
                    switch (routeMeta.getType()) {
                        case PROVIDER: {
                            List<? extends TypeMirror> interfaces = ((TypeElement)routeMeta.getRawType()).getInterfaces();
                            for (TypeMirror typeMirror : interfaces) {
                                if (this.types.isSameType(typeMirror, this.iProvider)) {
                                    loadIntoMethodOfProviderBuilder.addStatement("providers.put($S, $T.build($T." + routeMeta.getType() + ", $T.class, $S, $S, null, " + routeMeta.getPriority() + ", " + routeMeta.getExtra() + "))", new Object[]{routeMeta.getRawType().toString(), routeMetaCn, routeTypeCn, ClassName.get((TypeElement)((TypeElement)routeMeta.getRawType())), routeMeta.getPath(), routeMeta.getGroup()});
                                    continue;
                                }
                                if (!this.types.isSubtype(typeMirror, this.iProvider)) continue;
                                loadIntoMethodOfProviderBuilder.addStatement("providers.put($S, $T.build($T." + routeMeta.getType() + ", $T.class, $S, $S, null, " + routeMeta.getPriority() + ", " + routeMeta.getExtra() + "))", new Object[]{typeMirror.toString(), routeMetaCn, routeTypeCn, ClassName.get((TypeElement)((TypeElement)routeMeta.getRawType())), routeMeta.getPath(), routeMeta.getGroup()});
                            }
                            break;
                        }
                    }
                    StringBuilder mapBodyBuilder = new StringBuilder();
                    Map paramsType = routeMeta.getParamsType();
                    if (MapUtils.isNotEmpty((Map)paramsType)) {
                        for (Map.Entry types : paramsType.entrySet()) {
                            mapBodyBuilder.append("put(\"").append((String)types.getKey()).append("\", ").append(types.getValue()).append("); ");
                        }
                    }
                    String string = mapBodyBuilder.toString();
                    loadIntoMethodOfGroupBuilder.addStatement("atlas.put($S, $T.build($T." + routeMeta.getType() + ", $T.class, $S, $S, " + (StringUtils.isEmpty((CharSequence)string) ? null : "new java.util.HashMap<String, Integer>(){{" + mapBodyBuilder.toString() + "}}") + ", " + routeMeta.getPriority() + ", " + routeMeta.getExtra() + "))", new Object[]{routeMeta.getPath(), routeMetaCn, routeTypeCn, ClassName.get((TypeElement)((TypeElement)routeMeta.getRawType())), routeMeta.getPath().toLowerCase(), routeMeta.getGroup().toLowerCase()});
                }
                String groupFileName = "ARouter$$Group$$" + groupName;
                JavaFile.builder((String)"com.alibaba.android.arouter.routes", (TypeSpec)TypeSpec.classBuilder((String)groupFileName).addJavadoc("DO NOT EDIT THIS FILE!!! IT WAS GENERATED BY AROUTER.", new Object[0]).addSuperinterface((TypeName)ClassName.get((TypeElement)type_IRouteGroup)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addMethod(loadIntoMethodOfGroupBuilder.build()).build()).build().writeTo(this.mFiler);
                this.logger.info(">>> Generated group: " + groupName + "<<<");
                this.rootMap.put(groupName, groupFileName);
            }
            if (MapUtils.isNotEmpty(this.rootMap)) {
                for (Map.Entry<String, String> entry : this.rootMap.entrySet()) {
                    loadIntoMethodOfRootBuilder.addStatement("routes.put($S, $T.class)", new Object[]{entry.getKey(), ClassName.get((String)"com.alibaba.android.arouter.routes", (String)entry.getValue(), (String[])new String[0])});
                }
            }
            String string = "ARouter$$Providers$$" + this.moduleName;
            JavaFile.builder((String)"com.alibaba.android.arouter.routes", (TypeSpec)TypeSpec.classBuilder((String)string).addJavadoc("DO NOT EDIT THIS FILE!!! IT WAS GENERATED BY AROUTER.", new Object[0]).addSuperinterface((TypeName)ClassName.get((TypeElement)type_IProviderGroup)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addMethod(loadIntoMethodOfProviderBuilder.build()).build()).build().writeTo(this.mFiler);
            this.logger.info(">>> Generated provider map, name is " + string + " <<<");
            String string2 = "ARouter$$Root$$" + this.moduleName;
            JavaFile.builder((String)"com.alibaba.android.arouter.routes", (TypeSpec)TypeSpec.classBuilder((String)string2).addJavadoc("DO NOT EDIT THIS FILE!!! IT WAS GENERATED BY AROUTER.", new Object[0]).addSuperinterface((TypeName)ClassName.get((TypeElement)this.elements.getTypeElement("com.alibaba.android.arouter.facade.template.IRouteRoot"))).addModifiers(new Modifier[]{Modifier.PUBLIC}).addMethod(loadIntoMethodOfRootBuilder.build()).build()).build().writeTo(this.mFiler);
            this.logger.info(">>> Generated root, name is " + string2 + " <<<");
        }
    }

    private void categories(RouteMeta routeMete) {
        if (this.routeVerify(routeMete)) {
            this.logger.info(">>> Start categories, group = " + routeMete.getGroup() + ", path = " + routeMete.getPath() + " <<<");
            Set<RouteMeta> routeMetas = this.groupMap.get(routeMete.getGroup());
            if (CollectionUtils.isEmpty(routeMetas)) {
                TreeSet<RouteMeta> routeMetaSet = new TreeSet<RouteMeta>(new Comparator<RouteMeta>(){

                    @Override
                    public int compare(RouteMeta r1, RouteMeta r2) {
                        try {
                            return r1.getPath().compareTo(r2.getPath());
                        }
                        catch (NullPointerException npe) {
                            RouteProcessor.this.logger.error(npe.getMessage());
                            return 0;
                        }
                    }
                });
                routeMetaSet.add(routeMete);
                this.groupMap.put(routeMete.getGroup(), routeMetaSet);
            } else {
                routeMetas.add(routeMete);
            }
        } else {
            this.logger.warning(">>> Route meta verify error, group is " + routeMete.getGroup() + " <<<");
        }
    }

    private boolean routeVerify(RouteMeta meta) {
        String path = meta.getPath();
        if (StringUtils.isEmpty((CharSequence)path) || !path.startsWith("/")) {
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)meta.getGroup())) {
            try {
                String defaultGroup = path.substring(1, path.indexOf("/", 1));
                if (StringUtils.isEmpty((CharSequence)defaultGroup)) {
                    return false;
                }
                meta.setGroup(defaultGroup);
                return true;
            }
            catch (Exception e) {
                this.logger.error("Failed to extract default group! " + e.getMessage());
                return false;
            }
        }
        return true;
    }
}

