/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.android.arouter.compiler.utils;

import com.alibaba.android.arouter.facade.enums.TypeKind;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public class TypeUtils {
    private Types types;
    private Elements elements;
    private TypeMirror parcelableType;

    public TypeUtils(Types types, Elements elements) {
        this.types = types;
        this.elements = elements;
        this.parcelableType = this.elements.getTypeElement("android.os.Parcelable").asType();
    }

    public int typeExchange(Element element) {
        TypeMirror typeMirror = element.asType();
        if (typeMirror.getKind().isPrimitive()) {
            return element.asType().getKind().ordinal();
        }
        switch (typeMirror.toString()) {
            case "java.lang.Byte": {
                return TypeKind.BYTE.ordinal();
            }
            case "java.lang.Short": {
                return TypeKind.SHORT.ordinal();
            }
            case "java.lang.Integer": {
                return TypeKind.INT.ordinal();
            }
            case "java.lang.Long": {
                return TypeKind.LONG.ordinal();
            }
            case "java.lang.Float": {
                return TypeKind.FLOAT.ordinal();
            }
            case "java.lang.Double": {
                return TypeKind.DOUBLE.ordinal();
            }
            case "java.lang.Boolean": {
                return TypeKind.BOOLEAN.ordinal();
            }
            case "java.lang.String": {
                return TypeKind.STRING.ordinal();
            }
        }
        if (this.types.isSubtype(typeMirror, this.parcelableType)) {
            return TypeKind.PARCELABLE.ordinal();
        }
        return TypeKind.OBJECT.ordinal();
    }
}

