/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.seata.feign;

import com.alibaba.cloud.seata.feign.SeataFeignContext;
import com.alibaba.cloud.seata.feign.SeataFeignObjectWrapper;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.cloud.openfeign.FeignContext;

public class SeataContextBeanPostProcessor
implements BeanPostProcessor {
    private final BeanFactory beanFactory;
    private SeataFeignObjectWrapper seataFeignObjectWrapper;

    SeataContextBeanPostProcessor(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof FeignContext && !(bean instanceof SeataFeignContext)) {
            return new SeataFeignContext(this.getSeataFeignObjectWrapper(), (FeignContext)bean);
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    private SeataFeignObjectWrapper getSeataFeignObjectWrapper() {
        if (this.seataFeignObjectWrapper == null) {
            this.seataFeignObjectWrapper = (SeataFeignObjectWrapper)this.beanFactory.getBean(SeataFeignObjectWrapper.class);
        }
        return this.seataFeignObjectWrapper;
    }
}

