/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.ast.statement;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLHint;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObjectImpl;
import com.alibaba.druid.sql.ast.SQLReplaceable;
import com.alibaba.druid.sql.ast.SQLStatementImpl;
import com.alibaba.druid.sql.ast.statement.SQLErrorLoggingClause;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUpdateSetItem;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class SQLMergeStatement
extends SQLStatementImpl {
    private final List<SQLHint> hints = new ArrayList<SQLHint>();
    private SQLTableSource into;
    private SQLTableSource using;
    private SQLExpr on;
    private List<When> whens = new ArrayList<When>();
    private SQLErrorLoggingClause errorLoggingClause;

    @Override
    public void accept0(SQLASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild(visitor, this.into);
            this.acceptChild(visitor, this.using);
            this.acceptChild(visitor, this.on);
            this.acceptChild(visitor, this.whens);
            this.acceptChild(visitor, this.errorLoggingClause);
        }
        visitor.endVisit(this);
    }

    public String getAlias() {
        return this.into.getAlias();
    }

    public SQLTableSource getInto() {
        return this.into;
    }

    public void setInto(SQLName into) {
        this.setInto(new SQLExprTableSource(into));
    }

    public void setInto(SQLTableSource into) {
        if (into != null) {
            into.setParent(this);
        }
        this.into = into;
    }

    public SQLTableSource getUsing() {
        return this.using;
    }

    public void setUsing(SQLTableSource using) {
        this.using = using;
    }

    public SQLExpr getOn() {
        return this.on;
    }

    public void setOn(SQLExpr on) {
        this.on = on;
    }

    public void addWhen(When when) {
        when.setParent(this);
        this.whens.add(when);
    }

    public List<When> getWhens() {
        return this.whens;
    }

    public SQLErrorLoggingClause getErrorLoggingClause() {
        return this.errorLoggingClause;
    }

    public void setErrorLoggingClause(SQLErrorLoggingClause errorLoggingClause) {
        this.errorLoggingClause = errorLoggingClause;
    }

    public List<SQLHint> getHints() {
        return this.hints;
    }

    public static abstract class When
    extends SQLObjectImpl
    implements SQLReplaceable {
        protected boolean not;
        protected SQLName by;
        protected SQLExpr where;

        public When() {
        }

        public When(boolean not, SQLName by, SQLExpr where) {
            this.not = not;
            this.by = by;
            this.where = where;
        }

        protected void cloneTo(When x) {
            x.not = this.not;
            if (this.by != null) {
                x.by = this.by.clone();
            }
            if (this.where != null) {
                x.where = this.where.clone();
            }
        }

        public boolean isNot() {
            return this.not;
        }

        public void setNot(boolean not) {
            this.not = not;
        }

        public SQLName getBy() {
            return this.by;
        }

        public void setBy(SQLName x) {
            if (x != null) {
                x.setParent(this);
            }
            this.by = x;
        }

        public SQLExpr getWhere() {
            return this.where;
        }

        public void setWhere(SQLExpr x) {
            if (x != null) {
                x.setParent(this);
            }
            this.where = x;
        }

        @Override
        public boolean replace(SQLExpr expr, SQLExpr target) {
            if (this.where == expr) {
                target.setParent(this);
                this.where = target;
                return true;
            }
            return false;
        }
    }

    public static class WhenDelete
    extends When {
        public WhenDelete() {
        }

        public WhenDelete(boolean not, SQLName by, SQLExpr where) {
            super(not, by, where);
        }

        @Override
        protected void accept0(SQLASTVisitor v) {
            if (v.visit(this)) {
                this.acceptChild(v, this.by);
                this.acceptChild(v, this.where);
            }
        }

        public WhenDelete cloneTo() {
            WhenDelete x = new WhenDelete();
            this.cloneTo(x);
            return x;
        }
    }

    public static class WhenInsert
    extends When {
        private boolean insertRow;
        private List<SQLExpr> columns = new ArrayList<SQLExpr>();
        private List<SQLExpr> values = new ArrayList<SQLExpr>();

        public WhenInsert() {
        }

        public WhenInsert(boolean not, SQLName by, SQLExpr where) {
            super(not, by, where);
        }

        @Override
        public void accept0(SQLASTVisitor v) {
            if (v.visit(this)) {
                this.acceptChild(v, this.by);
                this.acceptChild(v, this.where);
                this.acceptChild(v, this.columns);
                this.acceptChild(v, this.values);
            }
            v.endVisit(this);
        }

        public List<SQLExpr> getColumns() {
            return this.columns;
        }

        public void addColumn(SQLExpr column) {
            column.setParent(this);
            this.columns.add(column);
        }

        public void addValue(SQLExpr value) {
            value.setParent(this);
            this.values.add(value);
        }

        public void setColumns(List<SQLExpr> columns) {
            this.columns = columns;
        }

        public boolean isInsertRow() {
            return this.insertRow;
        }

        public void setInsertRow(boolean insertRow) {
            this.insertRow = insertRow;
        }

        public List<SQLExpr> getValues() {
            return this.values;
        }

        public void setValues(List<SQLExpr> values) {
            this.values = values;
        }

        protected void cloneTo(WhenInsert x) {
            super.cloneTo(x);
            for (SQLExpr column : this.columns) {
                x.addColumn(column.clone());
            }
            for (SQLExpr value : this.values) {
                x.addValue(value.clone());
            }
        }

        public WhenInsert cloneTo() {
            WhenInsert x = new WhenInsert();
            this.cloneTo(x);
            return x;
        }

        @Override
        public boolean replace(SQLExpr expr, SQLExpr target) {
            int i;
            boolean isSuccess = false;
            for (i = 0; i < this.columns.size(); ++i) {
                if (this.columns.get(i) != expr) continue;
                target.setParent(this);
                this.columns.set(i, target);
                isSuccess = true;
            }
            for (i = 0; i < this.values.size(); ++i) {
                if (this.values.get(i) != expr) continue;
                target.setParent(this);
                this.values.set(i, target);
                isSuccess = true;
            }
            return isSuccess || super.replace(expr, target);
        }
    }

    public static class WhenUpdate
    extends When {
        private final List<SQLUpdateSetItem> items = new ArrayList<SQLUpdateSetItem>();

        public List<SQLUpdateSetItem> getItems() {
            return this.items;
        }

        public WhenUpdate() {
        }

        public WhenUpdate(boolean not, SQLName by, SQLExpr where) {
            super(not, by, where);
        }

        public void addItem(SQLUpdateSetItem item) {
            if (item != null) {
                item.setParent(this);
            }
            this.items.add(item);
        }

        public SQLUpdateSetItem findItemByColumn(SQLExpr column) {
            if (column == null) {
                return null;
            }
            for (SQLUpdateSetItem item : this.items) {
                if (!item.getColumn().equals(column)) continue;
                return item;
            }
            return null;
        }

        @Override
        public void accept0(SQLASTVisitor v) {
            if (v.visit(this)) {
                this.acceptChild(v, this.items);
                this.acceptChild(v, this.where);
            }
            v.endVisit(this);
        }

        protected void cloneTo(WhenUpdate x) {
            super.cloneTo(x);
            for (SQLUpdateSetItem item : this.items) {
                x.addItem(item.clone());
            }
        }

        public WhenUpdate cloneTo() {
            WhenUpdate x = new WhenUpdate();
            this.cloneTo(x);
            return x;
        }

        @Override
        public boolean replace(SQLExpr expr, SQLExpr target) {
            boolean isSuccess = false;
            if (expr instanceof SQLUpdateSetItem && target instanceof SQLUpdateSetItem) {
                for (int i = 0; i < this.items.size(); ++i) {
                    if (this.items.get(i) != expr) continue;
                    target.setParent(this);
                    this.items.set(i, (SQLUpdateSetItem)((Object)target));
                    isSuccess = true;
                }
            }
            return isSuccess || super.replace(expr, target);
        }
    }
}

