/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.starrocks.parser;

import com.alibaba.druid.sql.ast.DistributedByType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLOrderBy;
import com.alibaba.druid.sql.ast.SQLPartitionBy;
import com.alibaba.druid.sql.ast.SQLPartitionByList;
import com.alibaba.druid.sql.ast.SQLPartitionByRange;
import com.alibaba.druid.sql.ast.SQLPartitionByValue;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLPrimaryKeyImpl;
import com.alibaba.druid.sql.ast.statement.SQLUnique;
import com.alibaba.druid.sql.dialect.starrocks.ast.StarRocksAggregateKey;
import com.alibaba.druid.sql.dialect.starrocks.ast.StarRocksDuplicateKey;
import com.alibaba.druid.sql.dialect.starrocks.ast.StarRocksIndexDefinition;
import com.alibaba.druid.sql.dialect.starrocks.ast.statement.StarRocksCreateTableStatement;
import com.alibaba.druid.sql.dialect.starrocks.parser.StarRocksExprParser;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.SQLCreateTableParser;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.Token;
import com.alibaba.druid.util.FnvHash;

public class StarRocksCreateTableParser
extends SQLCreateTableParser {
    public StarRocksCreateTableParser(Lexer lexer) {
        super(new StarRocksExprParser(lexer));
    }

    public StarRocksCreateTableParser(String sql) {
        super(new StarRocksExprParser(sql));
    }

    public StarRocksCreateTableParser(SQLExprParser exprParser) {
        super(exprParser);
    }

    @Override
    public StarRocksExprParser getExprParser() {
        return (StarRocksExprParser)this.exprParser;
    }

    @Override
    protected void createTableBefore(SQLCreateTableStatement createTable) {
        if (this.lexer.nextIfIdentifier(FnvHash.Constants.EXTERNAL)) {
            createTable.setExternal(true);
        }
        if (this.lexer.nextIfIdentifier(FnvHash.Constants.TEMPORARY)) {
            createTable.setTemporary(true);
        }
    }

    public void parseUniqueKey(SQLCreateTableStatement stmt) {
        SQLUnique sqlUnique;
        if (this.lexer.nextIfIdentifier(FnvHash.Constants.DUPLICATE)) {
            sqlUnique = new StarRocksDuplicateKey();
        } else if (this.lexer.nextIfIdentifier(FnvHash.Constants.AGGREGATE)) {
            sqlUnique = new StarRocksAggregateKey();
        } else if (this.lexer.nextIf(Token.PRIMARY)) {
            sqlUnique = new SQLPrimaryKeyImpl();
        } else if (this.lexer.nextIf(Token.UNIQUE)) {
            sqlUnique = new SQLUnique();
        } else {
            return;
        }
        this.accept(Token.KEY);
        this.accept(Token.LPAREN);
        this.exprParser.orderBy(sqlUnique.getColumns(), sqlUnique);
        this.accept(Token.RPAREN);
        stmt.setUnique(sqlUnique);
    }

    @Override
    protected void parseIndex(SQLCreateTableStatement createTable) {
        if (this.lexer.token() == Token.INDEX) {
            StarRocksIndexDefinition index = new StarRocksIndexDefinition();
            this.lexer.nextToken();
            index.setIndexName(this.exprParser.name());
            this.accept(Token.LPAREN);
            while (true) {
                index.getColumns().add(this.exprParser.name());
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            this.accept(Token.RPAREN);
            if (this.lexer.token() == Token.USING) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.BITMAP) {
                    this.lexer.nextToken();
                    index.setIndexType("BITMAP");
                } else if (this.lexer.token() == Token.NGRAMBF) {
                    this.lexer.nextToken();
                    index.setIndexType("NGRAMBF");
                    if (this.lexer.token() == Token.LPAREN) {
                        this.accept(Token.LPAREN);
                        this.parseAssignItems(index.getIndexOption(), createTable, false);
                        this.accept(Token.RPAREN);
                    }
                } else if (this.lexer.token() == Token.INVERTED) {
                    this.lexer.nextToken();
                    index.setIndexType("INVERTED");
                }
            }
            if (this.lexer.token() == Token.COMMENT) {
                this.lexer.nextToken();
                index.setComment(this.exprParser.expr());
            }
            index.setParent(createTable);
            createTable.getTableElementList().add(index);
        }
    }

    @Override
    public void parseCreateTableRest(SQLCreateTableStatement stmt) {
        StarRocksCreateTableStatement srStmt = (StarRocksCreateTableStatement)stmt;
        if (this.lexer.nextIfIdentifier(FnvHash.Constants.ENGINE)) {
            this.accept(Token.EQ);
            srStmt.setEngine(this.exprParser.expr());
        }
        this.parseUniqueKey(stmt);
        if (this.lexer.token() == Token.COMMENT) {
            this.lexer.nextToken();
            SQLExpr comment = this.exprParser.expr();
            srStmt.setComment(comment);
        }
        if (this.lexer.nextIfIdentifier("AUTO")) {
            SQLPartitionBy partitionBy = this.parsePartitionBy();
            if (partitionBy != null) {
                partitionBy.setAuto(true);
            }
            stmt.setPartitionBy(partitionBy);
        } else {
            stmt.setPartitionBy(this.parsePartitionBy());
        }
        if (this.lexer.nextIfIdentifier(FnvHash.Constants.DISTRIBUTED)) {
            this.accept(Token.BY);
            if (this.lexer.nextIfIdentifier(FnvHash.Constants.HASH)) {
                srStmt.setDistributedByType(DistributedByType.Hash);
                this.accept(Token.LPAREN);
                this.exprParser.orderBy(srStmt.getDistributedBy(), srStmt);
                this.accept(Token.RPAREN);
            } else if (this.lexer.nextIfIdentifier(FnvHash.Constants.RANDOM)) {
                srStmt.setDistributedByType(DistributedByType.Random);
            }
        }
        if (this.lexer.nextIfIdentifier(FnvHash.Constants.BUCKETS)) {
            if (this.lexer.token() == Token.LITERAL_INT) {
                stmt.setBuckets(this.lexer.integerValue().intValue());
                this.lexer.nextToken();
            } else if (this.lexer.nextIfIdentifier("AUTO")) {
                stmt.setAutoBucket(true);
            }
        }
        if (this.lexer.token() == Token.ORDER) {
            SQLOrderBy orderBy = this.exprParser.parseOrderBy();
            srStmt.setOrderBy(orderBy);
        }
        if (this.lexer.nextIfIdentifier(FnvHash.Constants.PROPERTIES)) {
            this.accept(Token.LPAREN);
            this.parseAssignItems(srStmt.getTableOptions(), srStmt, false);
            this.accept(Token.RPAREN);
        }
        if (this.lexer.nextIfIdentifier(FnvHash.Constants.BROKER)) {
            this.acceptIdentifier(FnvHash.Constants.PROPERTIES);
            this.accept(Token.LPAREN);
            this.parseAssignItems(srStmt.getBrokerProperties(), srStmt, false);
            this.accept(Token.RPAREN);
        }
    }

    @Override
    public SQLPartitionBy parsePartitionBy() {
        if (this.lexer.nextIf(Token.PARTITION)) {
            SQLPartitionBy partitionClause;
            this.accept(Token.BY);
            boolean hasLparen = false;
            if (this.lexer.nextIfIdentifier(FnvHash.Constants.RANGE)) {
                partitionClause = new SQLPartitionByRange();
                this.accept(Token.LPAREN);
                hasLparen = true;
            } else if (this.lexer.nextIfIdentifier(FnvHash.Constants.LIST)) {
                partitionClause = new SQLPartitionByList();
                ((SQLPartitionByList)partitionClause).setType(SQLPartitionByList.PartitionByListType.LIST_EXPRESSION);
                this.accept(Token.LPAREN);
                hasLparen = true;
            } else if (this.lexer.nextIf(Token.LPAREN)) {
                partitionClause = new SQLPartitionByValue();
                hasLparen = true;
            } else {
                partitionClause = new SQLPartitionByValue();
            }
            do {
                partitionClause.addColumn(this.exprParser.expr());
            } while (this.lexer.nextIf(Token.COMMA));
            if (hasLparen) {
                this.accept(Token.RPAREN);
            }
            this.accept(Token.LPAREN);
            while (this.lexer.token() != Token.RPAREN) {
                partitionClause.addPartition(this.getExprParser().parsePartition());
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            this.accept(Token.RPAREN);
            return partitionClause;
        }
        return null;
    }

    @Override
    protected StarRocksCreateTableStatement newCreateStatement() {
        return new StarRocksCreateTableStatement();
    }
}

