/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.simpleimage;

import com.alibaba.simpleimage.ImageFormat;
import com.alibaba.simpleimage.MetadataRenderedImage;
import com.alibaba.simpleimage.util.NodeUtils;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRenderedImage;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedImageAdapter;
import javax.media.jai.WritableRenderedImageAdapter;
import org.w3c.dom.Node;

public class ImageWrapper
extends MetadataRenderedImage {
    public static final int DEFAULT_QUALITY = 93;
    protected RenderedImage[] images;
    protected boolean broken;

    public ImageWrapper(BufferedImage bi) {
        this(bi, 93, false);
    }

    public ImageWrapper(PlanarImage img) {
        this(img, 93, false);
    }

    public ImageWrapper(BufferedImage bi, boolean isBroken) {
        this(bi, 93, isBroken);
    }

    public ImageWrapper(PlanarImage img, boolean isBroken) {
        this(img, 93, isBroken);
    }

    public ImageWrapper(BufferedImage bi, int quality) {
        this(bi, quality, false);
    }

    public ImageWrapper(BufferedImage bi, int quality, boolean isBroken) {
        this.quality = quality;
        this.images = new RenderedImage[1];
        this.images[0] = PlanarImage.wrapRenderedImage((RenderedImage)bi);
        this.broken = isBroken;
    }

    public ImageWrapper(PlanarImage image, int quality) {
        this(image, quality, false);
    }

    public ImageWrapper(PlanarImage image, int quality, boolean isBroken) {
        this.images = new RenderedImage[1];
        this.images[0] = image;
        this.quality = quality;
        this.broken = isBroken;
    }

    public ImageWrapper(BufferedImage[] imgs) {
        this.setImages(imgs);
        this.quality = 93;
    }

    public ImageWrapper(PlanarImage[] imgs) {
        this.setImages(imgs);
        this.quality = 93;
    }

    public BufferedImage getAsBufferedImage(int index) {
        if (this.images[index] instanceof BufferedImage) {
            return (BufferedImage)this.images[index];
        }
        if (this.images[index] instanceof PlanarImage) {
            return ((PlanarImage)this.images[index]).getAsBufferedImage();
        }
        if (this.images[index] instanceof WritableRenderedImage) {
            return new WritableRenderedImageAdapter((WritableRenderedImage)this.images[index]).getAsBufferedImage();
        }
        return new RenderedImageAdapter(this.images[index]).getAsBufferedImage();
    }

    public BufferedImage getAsBufferedImage() {
        return this.getAsBufferedImage(0);
    }

    public PlanarImage getAsPlanarImage(int index) {
        if (this.images[index] instanceof PlanarImage) {
            return (PlanarImage)this.images[index];
        }
        if (this.images[index] instanceof BufferedImage) {
            return PlanarImage.wrapRenderedImage((RenderedImage)this.images[index]);
        }
        return new RenderedImageAdapter(this.images[index]);
    }

    public PlanarImage getAsPlanarImage() {
        return this.getAsPlanarImage(0);
    }

    public BufferedImage[] getAsBufferedImages() {
        BufferedImage[] imgs = new BufferedImage[this.images.length];
        for (int i = 0; i < imgs.length; ++i) {
            imgs[i] = this.getAsBufferedImage(i);
        }
        return imgs;
    }

    public PlanarImage[] getAsPlanarImages() {
        PlanarImage[] imgs = new PlanarImage[this.images.length];
        for (int i = 0; i < imgs.length; ++i) {
            imgs[i] = this.getAsPlanarImage(i);
        }
        return imgs;
    }

    public void setImages(BufferedImage[] imgs) {
        this.images = new RenderedImage[imgs.length];
        for (int i = 0; i < imgs.length; ++i) {
            this.images[i] = imgs[i];
        }
    }

    public void setImages(PlanarImage[] imgs) {
        this.images = new RenderedImage[imgs.length];
        for (int i = 0; i < imgs.length; ++i) {
            this.images[i] = imgs[i];
        }
    }

    public void setImage(int index, BufferedImage bi) {
        this.images[index] = bi;
    }

    public void setImage(BufferedImage bi) {
        this.setImage(0, bi);
    }

    public void setImage(int index, PlanarImage img) {
        this.images[index] = img;
    }

    public void setImage(PlanarImage img) {
        this.setImage(0, img);
    }

    public int getNumOfImages() {
        return this.images.length;
    }

    public int getWidth() {
        Node screenDescNode;
        if (this.format == ImageFormat.GIF && this.streamMetadata != null && (screenDescNode = NodeUtils.getChild(this.streamMetadata, "LogicalScreenDescriptor")) != null) {
            return NodeUtils.getIntAttr(screenDescNode, "logicalScreenWidth");
        }
        return this.getWidth(0);
    }

    public int getHeight() {
        Node screenDescNode;
        if (this.format == ImageFormat.GIF && this.streamMetadata != null && (screenDescNode = NodeUtils.getChild(this.streamMetadata, "LogicalScreenDescriptor")) != null) {
            return NodeUtils.getIntAttr(screenDescNode, "logicalScreenHeight");
        }
        return this.getHeight(0);
    }

    public int getWidth(int index) {
        if (index < 0 || index >= this.images.length) {
            throw new IndexOutOfBoundsException("Just totally have " + this.images.length + " images");
        }
        return this.images[index].getWidth();
    }

    public int getHeight(int index) {
        if (index < 0 || index >= this.images.length) {
            throw new IndexOutOfBoundsException("Just totally have " + this.images.length + " images");
        }
        return this.images[index].getHeight();
    }

    public Object clone() throws CloneNotSupportedException {
        int numOfImages = this.images.length;
        BufferedImage[] imgs = new BufferedImage[numOfImages];
        for (int i = 0; i < numOfImages; ++i) {
            PlanarImage oldImg = this.getAsPlanarImage(i);
            imgs[i] = oldImg.getAsBufferedImage();
        }
        ImageWrapper newImgWrapper = new ImageWrapper(imgs);
        newImgWrapper.quality = this.quality;
        newImgWrapper.broken = this.broken;
        newImgWrapper.format = this.format;
        if (this.horizontalSamplingFactors != null) {
            newImgWrapper.horizontalSamplingFactors = (int[])this.horizontalSamplingFactors.clone();
        }
        if (this.verticalSamplingFactors != null) {
            newImgWrapper.verticalSamplingFactors = (int[])this.verticalSamplingFactors.clone();
        }
        if (this.streamMetadata != null) {
            newImgWrapper.streamMetadata = NodeUtils.cloneNode(this.streamMetadata);
        }
        if (this.metadatas != null) {
            newImgWrapper.metadatas = new Node[this.metadatas.length];
            for (int i = 0; i < this.metadatas.length; ++i) {
                newImgWrapper.metadatas[i] = NodeUtils.cloneNode(this.metadatas[i]);
            }
        }
        return newImgWrapper;
    }

    public boolean isBroken() {
        return this.broken;
    }

    public void setBroken(boolean broken) {
        this.broken = broken;
    }
}

