/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.simpleimage.analyze.harris.match;

import com.alibaba.simpleimage.analyze.ModifiableConst;
import com.alibaba.simpleimage.analyze.harissurf.SURFInterestPointN;
import com.alibaba.simpleimage.analyze.harris.match.SurfMatch;
import com.alibaba.simpleimage.analyze.kdtree.KDTree;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SurfMatchPoints {
    public static List<SurfMatch> findMatchesBBF(List<SURFInterestPointN> keys1, List<SURFInterestPointN> keys2) {
        return SurfMatchPoints.findMatchesBBF(keys1, KDTree.createKDTree(keys2));
    }

    public static List<SurfMatch> findMatchesBBF(List<SURFInterestPointN> keys1, KDTree kd) {
        _mylist matches = new _mylist();
        for (SURFInterestPointN sp : keys1) {
            SURFInterestPointN kpN;
            ArrayList<KDTree.BestEntry> kpNNList = kd.nearestNeighbourListBBF(sp, 2, 40);
            if (kpNNList.size() < 2) {
                throw new IllegalArgumentException("BUG: less than two neighbours!");
            }
            KDTree.BestEntry be1 = kpNNList.get(0);
            KDTree.BestEntry be2 = kpNNList.get(1);
            if (be1.getDist() / be2.getDist() > ModifiableConst.getTowPntDistRatio() || !(Math.abs((kpN = (SURFInterestPointN)be1.getNeighbour()).getOrientation() - sp.getOrientation()) > ModifiableConst.getTowPntOrientationMinus())) continue;
            matches.add(new SurfMatch(sp, kpN, be1.getDist(), be2.getDist()));
        }
        return matches;
    }

    public static ArrayList<SurfMatch> filterJoins(List<SurfMatch> matches) {
        Integer kp2V;
        HashMap<SURFInterestPointN, Integer> map = new HashMap<SURFInterestPointN, Integer>();
        for (SurfMatch m : matches) {
            Integer kp1V = (Integer)map.get(m.getSp1());
            int lI = kp1V == null ? 0 : kp1V;
            map.put(m.getSp1(), lI + 1);
            kp2V = (Integer)map.get(m.getSp2());
            int rI = kp2V == null ? 0 : kp2V;
            map.put(m.getSp2(), rI + 1);
        }
        ArrayList<SurfMatch> survivors = new ArrayList<SurfMatch>();
        for (SurfMatch m : matches) {
            Integer kp1V = (Integer)map.get(m.getSp1());
            kp2V = (Integer)map.get(m.getSp2());
            if (kp1V > 1 || kp2V > 1) continue;
            survivors.add(m);
        }
        return survivors;
    }

    public static void filterNBest(ArrayList<SurfMatch> matches, int bestQ) {
        Collections.sort(matches, new SurfMatch.MatchWeighter());
        if (matches.size() > bestQ) {
            ((_mylist)matches).removeRange(bestQ, matches.size() - bestQ);
        }
    }

    public static List<SurfMatch> filterFarMatchL(List<SurfMatch> matches, double minX, double minY) {
        int arcStep = ModifiableConst.getSolpeArcStep();
        if (matches.size() <= 1) {
            return matches;
        }
        int max_vote_count = 0;
        long max_vote = 0L;
        int[] ms = new int[90 / arcStep + 1];
        for (SurfMatch m : matches) {
            if ((double)Math.abs(m.sp2.getOrientation() - m.sp1.getOrientation()) > 0.1) continue;
            double r = Math.atan(((double)m.sp2.getY() + minY - (double)m.sp1.getY()) / ((double)m.sp2.getX() + minX - (double)m.sp1.getX())) * 360.0 / (Math.PI * 2);
            if (r < 0.0) {
                r += 90.0;
            }
            int idx = (int)r / arcStep;
            ms[idx] = ms[idx] + 1;
            if (ms[idx] > max_vote_count) {
                max_vote_count = ms[idx];
                max_vote = idx;
            }
            m.slopeArc = idx;
        }
        ArrayList<SurfMatch> survivors = new ArrayList<SurfMatch>();
        for (SurfMatch m : matches) {
            if ((long)m.slopeArc != max_vote) continue;
            survivors.add(m);
        }
        return survivors;
    }

    public static List<SurfMatch> filterFarMatchR(List<SurfMatch> matches, double minX, double minY) {
        int arcStep = ModifiableConst.getSolpeArcStep();
        if (matches.size() <= 1) {
            return matches;
        }
        int[] ms = new int[90 / arcStep];
        for (SurfMatch m : matches) {
            double r = Math.atan(((double)m.sp1.getY() - ((double)m.sp2.getY() + minY)) / ((double)m.sp1.getX() + minX - (double)m.sp2.getX())) * 360.0 / (Math.PI * 2);
            m.slopeArc = (int)r / arcStep * arcStep;
            if (m.slopeArc < 0) {
                m.slopeArc += 90;
            }
            ms[m.slopeArc / arcStep] = ms[m.slopeArc / arcStep] + 1;
        }
        int count = 0;
        int idx = 0;
        for (int i = 0; i < ms.length; ++i) {
            if (ms[i] <= count) continue;
            count = ms[i];
            idx = i;
        }
        idx *= arcStep;
        ArrayList<SurfMatch> survivors = new ArrayList<SurfMatch>();
        for (SurfMatch m : matches) {
            if (m.slopeArc != idx) continue;
            survivors.add(m);
        }
        return survivors;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class _mylist
    extends ArrayList<SurfMatch> {
        private static final long serialVersionUID = -1672787720681683109L;

        private _mylist() {
        }

        @Override
        public void removeRange(int formIndex, int toIndex) {
            super.removeRange(formIndex, toIndex);
        }
    }
}

