/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.simpleimage.analyze.kdtree;

import com.alibaba.simpleimage.analyze.RefFloat;
import com.alibaba.simpleimage.analyze.RefInt;
import com.alibaba.simpleimage.analyze.kdtree.IKDTreeDomain;
import com.alibaba.simpleimage.analyze.kdtree.SortedLimitedList;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KDTree {
    IKDTreeDomain dr;
    int splitDim;
    KDTree left;
    KDTree right;

    public static int distanceSq(IKDTreeDomain t1, IKDTreeDomain t2) {
        int distance = 0;
        for (int n = 0; n < t1.dim; ++n) {
            int dimDist = t1.descriptor[n] - t2.descriptor[n];
            distance += dimDist * dimDist;
        }
        return distance;
    }

    public IKDTreeDomain nearestNeighbour(IKDTreeDomain target, RefFloat ref) {
        HyperRectangle hr = HyperRectangle.createUniverseRectangle(target.dim);
        IKDTreeDomain nearest = this.nearestNeighbourI(target, hr, Float.POSITIVE_INFINITY, ref);
        return nearest;
    }

    private IKDTreeDomain nearestNeighbourI(IKDTreeDomain target, HyperRectangle hr, float maxDistSq, RefFloat resDistSq) {
        HyperRectangle furtherHr;
        KDTree furtherKd;
        HyperRectangle nearerHr;
        KDTree nearerKd;
        resDistSq.val = Float.POSITIVE_INFINITY;
        IKDTreeDomain pivot = this.dr;
        HyperRectangle leftHr = hr;
        HyperRectangle rightHr = leftHr.splitAt(this.splitDim, pivot.descriptor[this.splitDim]);
        if (target.descriptor[this.splitDim] <= pivot.descriptor[this.splitDim]) {
            nearerKd = this.left;
            nearerHr = leftHr;
            furtherKd = this.right;
            furtherHr = rightHr;
        } else {
            nearerKd = this.right;
            nearerHr = rightHr;
            furtherKd = this.left;
            furtherHr = leftHr;
        }
        IKDTreeDomain nearest = null;
        RefFloat distSq = new RefFloat();
        if (nearerKd == null) {
            distSq.val = Float.POSITIVE_INFINITY;
        } else {
            nearest = nearerKd.nearestNeighbourI(target, nearerHr, maxDistSq, distSq);
        }
        maxDistSq = Math.min(maxDistSq, distSq.val);
        if (furtherHr.isInReach(target, (float)Math.sqrt(maxDistSq))) {
            float ptDistSq = KDTree.distanceSq(pivot, target);
            if (ptDistSq < distSq.val) {
                nearest = pivot;
                maxDistSq = distSq.val = ptDistSq;
            }
            RefFloat tempDistSq = new RefFloat();
            IKDTreeDomain tempNearest = null;
            if (furtherKd == null) {
                tempDistSq.val = Float.POSITIVE_INFINITY;
            } else {
                tempNearest = furtherKd.nearestNeighbourI(target, furtherHr, maxDistSq, tempDistSq);
            }
            if (tempDistSq.val < distSq.val) {
                nearest = tempNearest;
                distSq = tempDistSq;
            }
        }
        resDistSq = distSq;
        return nearest;
    }

    public static KDTree createKDTree(List<? extends IKDTreeDomain> exset) {
        if (exset.size() == 0) {
            return null;
        }
        KDTree cur = new KDTree();
        RefInt splitDim = new RefInt();
        splitDim.val = cur.splitDim;
        cur.dr = KDTree.goodCandidate(exset, splitDim);
        cur.splitDim = splitDim.val;
        ArrayList<IKDTreeDomain> leftElems = new ArrayList<IKDTreeDomain>();
        ArrayList<IKDTreeDomain> rightElems = new ArrayList<IKDTreeDomain>();
        float bound = cur.dr.descriptor[splitDim.val];
        for (IKDTreeDomain iKDTreeDomain : exset) {
            if (iKDTreeDomain == cur.dr) continue;
            if ((float)iKDTreeDomain.descriptor[splitDim.val] <= bound) {
                leftElems.add(iKDTreeDomain);
                continue;
            }
            rightElems.add(iKDTreeDomain);
        }
        cur.left = KDTree.createKDTree(leftElems);
        cur.right = KDTree.createKDTree(rightElems);
        return cur;
    }

    private static IKDTreeDomain goodCandidate(List<? extends IKDTreeDomain> exset, RefInt splitDim) {
        int n;
        IKDTreeDomain first = exset.get(0);
        if (first == null) {
            throw new NullPointerException("Not of type IKDTreeDomain ");
        }
        int dim = first.dim;
        float[] minHr = new float[dim];
        float[] maxHr = new float[dim];
        for (int k = 0; k < dim; ++k) {
            minHr[k] = Float.POSITIVE_INFINITY;
            maxHr[k] = Float.NEGATIVE_INFINITY;
        }
        for (IKDTreeDomain iKDTreeDomain : exset) {
            for (int k = 0; k < dim; ++k) {
                float dimE = iKDTreeDomain.descriptor[k];
                if (dimE < minHr[k]) {
                    minHr[k] = dimE;
                }
                if (!(dimE > maxHr[k])) continue;
                maxHr[k] = dimE;
            }
        }
        float[] diffHr = new float[dim];
        boolean bl = false;
        float maxDiff = 0.0f;
        for (int k = 0; k < dim; ++k) {
            diffHr[k] = maxHr[k] - minHr[k];
            if (!(diffHr[k] > maxDiff)) continue;
            maxDiff = diffHr[k];
            n = k;
        }
        float middle = 0.0f;
        try {
            middle = maxDiff / 2.0f + minHr[n];
        }
        catch (Exception e) {
            System.out.println(dim);
            System.out.println(minHr.length);
        }
        IKDTreeDomain exemplar = null;
        float exemMinDiff = Float.POSITIVE_INFINITY;
        for (IKDTreeDomain iKDTreeDomain : exset) {
            float curDiff = Math.abs((float)iKDTreeDomain.descriptor[n] - middle);
            if (!(curDiff < exemMinDiff)) continue;
            exemMinDiff = curDiff;
            exemplar = iKDTreeDomain;
        }
        splitDim.val = n;
        return exemplar;
    }

    public ArrayList<BestEntry> nearestNeighbourListBBF(IKDTreeDomain kp, int q, int searchSteps) {
        HyperRectangle hr = HyperRectangle.createUniverseRectangle(kp.dim);
        SortedLimitedList<BestEntry> best = new SortedLimitedList<BestEntry>(q);
        SortedLimitedList<HREntry> searchHr = new SortedLimitedList<HREntry>(searchSteps);
        RefInt dummyDist = new RefInt();
        RefInt step = new RefInt();
        dummyDist.val = 0;
        step.val = searchSteps;
        this.nearestNeighbourListBBFI(best, q, kp, hr, Integer.MAX_VALUE, dummyDist, searchHr, step);
        for (BestEntry be : best) {
            be.dist = (float)Math.sqrt(be.distSq);
        }
        return best;
    }

    private IKDTreeDomain nearestNeighbourListBBFI(SortedLimitedList<BestEntry> best, int q, IKDTreeDomain target, HyperRectangle hr, int maxDistSq, RefInt resDistSq, SortedLimitedList<HREntry> searchHr, RefInt searchSteps) {
        HyperRectangle furtherHr;
        KDTree furtherKd;
        HyperRectangle nearerHr;
        KDTree nearerKd;
        resDistSq.val = Integer.MAX_VALUE;
        IKDTreeDomain pivot = this.dr;
        best.add(new BestEntry(this.dr, KDTree.distanceSq(target, this.dr)));
        HyperRectangle leftHr = hr;
        HyperRectangle rightHr = leftHr.splitAt(this.splitDim, pivot.descriptor[this.splitDim]);
        if (target.descriptor[this.splitDim] <= pivot.descriptor[this.splitDim]) {
            nearerKd = this.left;
            nearerHr = leftHr;
            furtherKd = this.right;
            furtherHr = rightHr;
        } else {
            nearerKd = this.right;
            nearerHr = rightHr;
            furtherKd = this.left;
            furtherHr = leftHr;
        }
        IKDTreeDomain nearest = null;
        RefInt distSq = new RefInt();
        searchHr.add(new HREntry(furtherHr, furtherKd, pivot, furtherHr.distance(target)));
        if (nearerKd == null) {
            distSq.val = Integer.MAX_VALUE;
        } else {
            nearest = nearerKd.nearestNeighbourListBBFI(best, q, target, nearerHr, maxDistSq, distSq, searchHr, searchSteps);
        }
        maxDistSq = best.size() >= q ? ((BestEntry)best.get(q - 1)).getDistSq() : Integer.MAX_VALUE;
        if (searchHr.size() > 0) {
            HREntry hre = (HREntry)searchHr.get(0);
            searchHr.remove(0);
            furtherHr = hre.rect;
            furtherKd = hre.tree;
            pivot = hre.pivot;
        }
        --searchSteps.val;
        if (searchSteps.val > 0 && furtherHr.isInReach(target, (float)Math.sqrt(maxDistSq))) {
            int ptDistSq = KDTree.distanceSq(pivot, target);
            if (ptDistSq < distSq.val) {
                nearest = pivot;
                maxDistSq = distSq.val = ptDistSq;
            }
            RefInt tempDistSq = new RefInt();
            IKDTreeDomain tempNearest = null;
            if (furtherKd == null) {
                tempDistSq.val = Integer.MAX_VALUE;
            } else {
                tempNearest = furtherKd.nearestNeighbourListBBFI(best, q, target, furtherHr, maxDistSq, tempDistSq, searchHr, searchSteps);
            }
            if (tempDistSq.val < distSq.val) {
                nearest = tempNearest;
                distSq = tempDistSq;
            }
        }
        resDistSq = distSq;
        return nearest;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class HREntry
    implements Comparable<HREntry> {
        float dist;
        IKDTreeDomain pivot;
        HyperRectangle rect;
        KDTree tree;

        public float getDist() {
            return this.dist;
        }

        public IKDTreeDomain getPivot() {
            return this.pivot;
        }

        public HyperRectangle getRect() {
            return this.rect;
        }

        public KDTree getTree() {
            return this.tree;
        }

        public HREntry(HyperRectangle rect, KDTree tree, IKDTreeDomain pivot, float dist) {
            this.dist = dist;
            this.pivot = pivot;
            this.tree = tree;
            this.rect = rect;
        }

        @Override
        public int compareTo(HREntry o) {
            HREntry hre = o;
            if (this.dist < hre.dist) {
                return -1;
            }
            if (this.dist > hre.dist) {
                return 1;
            }
            return 0;
        }
    }

    static class HyperRectangle
    implements Cloneable {
        int[] leftTop;
        int[] rightBottom;
        int dim;

        private HyperRectangle(int dim) {
            this.dim = dim;
            this.leftTop = new int[dim];
            this.rightBottom = new int[dim];
        }

        public Object clone() {
            HyperRectangle rec = new HyperRectangle(this.dim);
            for (int n = 0; n < this.dim; ++n) {
                rec.leftTop[n] = this.leftTop[n];
                rec.rightBottom[n] = this.rightBottom[n];
            }
            return rec;
        }

        static HyperRectangle createUniverseRectangle(int dim) {
            HyperRectangle rec = new HyperRectangle(dim);
            for (int n = 0; n < dim; ++n) {
                rec.leftTop[n] = Integer.MIN_VALUE;
                rec.rightBottom[n] = Integer.MAX_VALUE;
            }
            return rec;
        }

        HyperRectangle splitAt(int splitDim, int splitVal) {
            if (this.leftTop[splitDim] >= splitVal || this.rightBottom[splitDim] < splitVal) {
                throw new IllegalArgumentException("SplitAt with splitpoint outside rec");
            }
            HyperRectangle r2 = (HyperRectangle)this.clone();
            this.rightBottom[splitDim] = splitVal;
            r2.leftTop[splitDim] = splitVal;
            return r2;
        }

        boolean isIn(IKDTreeDomain target) {
            if (target.dim != this.dim) {
                throw new IllegalArgumentException("isIn dimension mismatch");
            }
            for (int n = 0; n < this.dim; ++n) {
                int targD = target.descriptor[n];
                if (targD >= this.leftTop[n] && targD < this.rightBottom[n]) continue;
                return false;
            }
            return true;
        }

        boolean isInReach(IKDTreeDomain target, float distRad) {
            return this.distance(target) < distRad;
        }

        float distance(IKDTreeDomain target) {
            int distance = 0;
            for (int n = 0; n < this.dim; ++n) {
                int tI = target.descriptor[n];
                int hrMin = this.leftTop[n];
                int hrMax = this.rightBottom[n];
                int closestPointN = 0;
                if (tI <= hrMin) {
                    closestPointN = hrMin;
                } else if (tI > hrMin && tI < hrMax) {
                    closestPointN = tI;
                } else if (tI >= hrMax) {
                    closestPointN = hrMax;
                }
                int dimDist = tI - closestPointN;
                distance += dimDist * dimDist;
            }
            return (float)Math.sqrt(distance);
        }
    }

    public static class BestEntry
    implements Comparable {
        private float dist;
        private int distSq;
        IKDTreeDomain neighbour;

        public IKDTreeDomain getNeighbour() {
            return this.neighbour;
        }

        public int getDistSq() {
            return this.distSq;
        }

        public void setDistSq(int distSq) {
            this.distSq = distSq;
        }

        public float getDist() {
            return this.dist;
        }

        public void setDist(float dist) {
            this.dist = dist;
        }

        BestEntry(IKDTreeDomain neighbour, int distSq) {
            this.neighbour = neighbour;
            this.distSq = distSq;
        }

        BestEntry(IKDTreeDomain neighbour, float dist) {
            this.neighbour = neighbour;
            this.dist = dist;
        }

        public int compareTo(Object o) {
            BestEntry be = (BestEntry)o;
            if (this.distSq < be.distSq) {
                return -1;
            }
            if (this.distSq > be.distSq) {
                return 1;
            }
            return 0;
        }
    }
}

