/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.simpleimage.analyze.sift.scale;

import com.alibaba.simpleimage.analyze.sift.ImagePixelArray;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class GaussianArray {
    private static final Logger log = Logger.getLogger(GaussianArray.class);
    private static Map<Float, float[]> cachedMask = new HashMap<Float, float[]>();
    public float[] mask;

    public GaussianArray(float sigma) {
        if (cachedMask.containsKey(Float.valueOf(sigma))) {
            this.mask = cachedMask.get(Float.valueOf(sigma));
        } else {
            this.mask = GaussianArray.makeMask(sigma, 1 + 2 * (int)(3.0f * sigma));
            log.info((Object)("remake mask,sigma = " + sigma));
        }
    }

    public static float[] makeMask(float sigma, int dim) {
        float[] mask = new float[dim |= 1];
        float sigma2sq = 2.0f * sigma * sigma;
        float normalizeFactor = 1.0f / ((float)Math.sqrt(Math.PI * 2) * sigma);
        for (int i = 0; i < dim; ++i) {
            int relPos = i - mask.length / 2;
            float G = (float)(relPos * relPos) / sigma2sq;
            G = (float)Math.exp(-G);
            mask[i] = G *= normalizeFactor;
        }
        return mask;
    }

    public ImagePixelArray convolve(ImagePixelArray map) {
        return Filter.convolve(map, this.mask);
    }

    static {
        float[] sigmaVal = new float[]{1.5f, 1.2262735f, 1.5450078f, 1.9465879f, 2.452547f, 3.0900156f};
        for (int i = 0; i < sigmaVal.length; ++i) {
            float[] mask = GaussianArray.makeMask(sigmaVal[i], 1 + 2 * (int)(3.0f * sigmaVal[i]));
            cachedMask.put(Float.valueOf(sigmaVal[i]), mask);
        }
    }

    private static class Filter {
        private Filter() {
        }

        public static ImagePixelArray convolve(ImagePixelArray img, float[] mask) {
            ImagePixelArray im1 = new ImagePixelArray(img.width, img.height);
            ImagePixelArray im2 = new ImagePixelArray(img.width, img.height);
            Filter.convolve1D(im1, mask, img, Direction.VERTICAL);
            Filter.convolve1D(im2, mask, im1, Direction.HORIZONTAL);
            return im2;
        }

        public static void convolve1D(ImagePixelArray dest, float[] mask, ImagePixelArray src, Direction dir) {
            int maxP;
            int maxN;
            if (dir == Direction.VERTICAL) {
                maxN = src.width;
                maxP = src.height;
            } else if (dir == Direction.HORIZONTAL) {
                maxN = src.height;
                maxP = src.width;
            } else {
                throw new IllegalArgumentException("invalid direction");
            }
            for (int n = 0; n < maxN; ++n) {
                for (int p = 0; p < maxP; ++p) {
                    float val = Filter.calculateConvolutionValue1D(src, mask, n, p, maxN, maxP, dir);
                    if (dir == Direction.VERTICAL) {
                        dest.data[n + p * dest.width] = val;
                        continue;
                    }
                    dest.data[p + n * dest.width] = val;
                }
            }
        }

        private static float calculateConvolutionValue1D(ImagePixelArray src, float[] mask, int n, int p, int maxN, int maxP, Direction dir) {
            float sum = 0.0f;
            boolean isOut = false;
            float outBound = 0.0f;
            for (int i = 0; i < mask.length; ++i) {
                int curAbsP = i - mask.length / 2 + p;
                if (curAbsP < 0 || curAbsP >= maxP) {
                    isOut = true;
                    outBound += mask[i];
                    continue;
                }
                if (dir == Direction.VERTICAL) {
                    sum += mask[i] * src.data[curAbsP * src.width + n];
                    continue;
                }
                sum += mask[i] * src.data[n * src.width + curAbsP];
            }
            if (isOut) {
                sum = (float)((double)sum * (1.0 / (1.0 - (double)outBound)));
            }
            return sum;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Direction {
            VERTICAL,
            HORIZONTAL;

        }
    }
}

