/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.simpleimage.jai.scale;

import com.alibaba.simpleimage.jai.scale.InterpolationLanczos;
import com.alibaba.simpleimage.jai.scale.LanczosContributionInfo;
import com.alibaba.simpleimage.jai.scale.LanczosResizeFilter;
import com.alibaba.simpleimage.util.ImageUtils;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.GeometricOpImage;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;

@Deprecated
public class LanczosOpImage
extends GeometricOpImage {
    private static final double WORK_LOAD_FACTOR = 0.265;
    protected double scaleX;
    protected double scaleY;
    protected double scaleFactor;
    protected int destWidth;
    protected int destHeight;
    protected LanczosResizeFilter filter;
    protected Rectangle filterRect;
    protected int xTrans;
    protected int yTrans;

    public LanczosOpImage(RenderedImage source, ImageLayout layout, Map config, double scaleX, double scaleY) {
        super(LanczosOpImage.vectorize((RenderedImage)source), LanczosOpImage.layoutHelper(source, scaleX, scaleY, layout), config, true, null, (Interpolation)new InterpolationLanczos(), null);
        this.scaleX = scaleX;
        this.scaleY = scaleY;
        this.destWidth = (int)((double)source.getWidth() * scaleX);
        this.destHeight = (int)((double)source.getHeight() * scaleY);
        if (this.destWidth <= 0) {
            this.destWidth = 1;
        }
        if (this.destHeight <= 0) {
            this.destHeight = 1;
        }
        this.filter = new LanczosResizeFilter();
        int bandsNum = source.getColorModel().getNumComponents();
        if (bandsNum != 3) {
            throw new IllegalArgumentException("Not supported");
        }
        this.scaleFactor = this.scaleX * this.scaleY;
        this.filterRect = this.scaleFactor > 0.265 ? new Rectangle(this.destWidth, source.getHeight()) : new Rectangle(source.getWidth(), this.destHeight);
    }

    private static ImageLayout layoutHelper(RenderedImage source, double scaleX, double scaleY, ImageLayout il) {
        int dHeight;
        ImageLayout layout;
        ImageLayout imageLayout = layout = il == null ? new ImageLayout() : (ImageLayout)il.clone();
        if (scaleX <= 0.0 || scaleY <= 0.0) {
            throw new IllegalArgumentException("Illegal scaleX or scaleY value");
        }
        int dWidth = (int)((double)source.getWidth() * scaleX);
        if (dWidth <= 0) {
            dWidth = 1;
        }
        if ((dHeight = (int)((double)source.getHeight() * scaleY)) <= 0) {
            dHeight = 1;
        }
        layout.setMinX((int)Math.floor((double)source.getMinX() * scaleX));
        layout.setMinY((int)Math.floor((double)source.getMinY() * scaleY));
        layout.setWidth(dWidth);
        layout.setHeight(dHeight);
        return layout;
    }

    protected Rectangle backwardMapRect(Rectangle destRect, int sourceIndex) {
        int startY;
        double scale = Math.max(1.0 / this.scaleX, 1.0);
        double support = scale * this.filter.getSupport() * this.filter.getBlur();
        if (support < 0.5) {
            support = 0.5;
        }
        Rectangle srcRect = this.getSourceImage(sourceIndex).getBounds();
        double center = ((double)destRect.x + 0.5) / this.scaleX;
        double t1 = center - support + 0.5;
        double t2 = center + support + 0.5;
        int start = (int)(t1 > 0.0 ? t1 : 0.0);
        int stop = (int)(t2 < (double)srcRect.width ? t2 : (double)srcRect.width);
        int startX = (int)((double)start - center) + (int)center;
        if (startX < 0) {
            startX = 0;
        }
        this.xTrans = (int)center - startX;
        center = ((double)destRect.x + destRect.getWidth() - 1.0 + 0.5) / this.scaleX;
        t1 = center - support + 0.5;
        t2 = center + support + 0.5;
        start = (int)(t1 > 0.0 ? t1 : 0.0);
        int endX = stop = (int)(t2 < (double)srcRect.width ? t2 : (double)srcRect.width);
        scale = Math.max(1.0 / this.scaleY, 1.0);
        support = scale * this.filter.getSupport() * this.filter.getBlur();
        if (support < 0.5) {
            support = 0.5;
        }
        if ((startY = (int)((double)(start = (int)((t1 = (center = ((double)destRect.y + 0.5) / this.scaleY) - support + 0.5) > 0.0 ? t1 : 0.0)) - center) + (int)center) < 0) {
            startY = 0;
        }
        this.yTrans = (int)center - startY;
        center = (destRect.getY() + destRect.getHeight() - 1.0 + 0.5) / this.scaleY;
        t1 = center - support + 0.5;
        t2 = center + support + 0.5;
        start = (int)(t1 > 0.0 ? t1 : 0.0);
        int endY = stop = (int)(t2 < srcRect.getHeight() ? t2 : srcRect.getHeight());
        Rectangle mapRect = new Rectangle(startX, startY, endX - startX + 1, endY - startY + 1);
        return mapRect.intersection(srcRect);
    }

    protected Rectangle forwardMapRect(Rectangle sourceRect, int sourceIndex) {
        return null;
    }

    protected Rectangle mapHorizontalComputeRect(Rectangle srcRect, Rectangle destRect) {
        return new Rectangle(destRect.x, srcRect.y, destRect.width, srcRect.height);
    }

    protected Rectangle mapVerticalComputeRect(Rectangle srcRect, Rectangle destRect) {
        return new Rectangle(srcRect.x, destRect.y, srcRect.width, destRect.height);
    }

    protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect) {
        RasterFormatTag[] formatTags = this.getFormatTags();
        RasterAccessor dst = new RasterAccessor((Raster)dest, destRect, formatTags[1], this.getColorModel());
        Rectangle mapRect = this.backwardMapRect(destRect, 0);
        Rectangle tmpRect = null;
        tmpRect = this.scaleFactor > 0.265 ? this.mapHorizontalComputeRect(mapRect, destRect).intersection(this.filterRect) : this.mapVerticalComputeRect(mapRect, destRect).intersection(this.filterRect);
        SampleModel nsm = dest.getSampleModel().createCompatibleSampleModel(tmpRect.width, tmpRect.height);
        WritableRaster filterRaster = Raster.createWritableRaster(nsm, tmpRect.getLocation());
        RasterAccessor f = new RasterAccessor((Raster)filterRaster, tmpRect, formatTags[1], this.getColorModel());
        RasterAccessor src = new RasterAccessor(sources[0], mapRect.intersection(sources[0].getBounds()), formatTags[0], this.getSourceImage(0).getColorModel());
        switch (dst.getDataType()) {
            case 0: {
                this.computeRectByte(src, f, dst);
                break;
            }
            case 1: {
                this.computeRectUShort(src, f, dst);
                break;
            }
            case 2: {
                this.computeRectShort(src, f, dst);
                break;
            }
            case 3: {
                this.computeRectInt(src, f, dst);
                break;
            }
            case 4: {
                this.computeRectFloat(src, f, dst);
                break;
            }
            case 5: {
                this.computeRectDouble(src, f, dst);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Not implemented yet");
            }
        }
        if (dst.isDataCopy()) {
            dst.clampDataArrays();
            dst.copyDataToRaster();
        }
    }

    private void computeRectByte(RasterAccessor src, RasterAccessor mid, RasterAccessor dst) {
        if (this.scaleFactor > 0.265) {
            this.lanczosHorizontalFilterByte(src, mid);
            this.lanczosVerticalFilterByte(mid, dst);
        } else {
            this.lanczosVerticalFilterByte(src, mid);
            this.lanczosHorizontalFilterByte(mid, dst);
        }
    }

    private void computeRectUShort(RasterAccessor src, RasterAccessor mid, RasterAccessor dst) {
        if (this.scaleX * this.scaleY > 0.265) {
            // empty if block
        }
    }

    private void computeRectShort(RasterAccessor src, RasterAccessor mid, RasterAccessor dst) {
        if (this.scaleX * this.scaleY > 0.265) {
            // empty if block
        }
    }

    private void computeRectInt(RasterAccessor src, RasterAccessor mid, RasterAccessor dst) {
        if (this.scaleX * this.scaleY > 0.265) {
            // empty if block
        }
    }

    private void computeRectFloat(RasterAccessor src, RasterAccessor mid, RasterAccessor dst) {
        if (this.scaleX * this.scaleY > 0.265) {
            // empty if block
        }
    }

    private void computeRectDouble(RasterAccessor src, RasterAccessor mid, RasterAccessor dst) {
        if (this.scaleX * this.scaleY > 0.265) {
            // empty if block
        }
    }

    private void lanczosHorizontalFilterByte(RasterAccessor src, RasterAccessor dst) {
        double scale = Math.max(1.0 / this.scaleX, 1.0);
        double support = scale * this.filter.getSupport() * this.filter.getBlur();
        if (support < 0.5) {
            support = 0.5;
            scale = 1.0;
        }
        byte[][] srcDataArrays = src.getByteDataArrays();
        byte[][] dstDataArrays = dst.getByteDataArrays();
        double[] pixel = new double[]{0.0, 0.0, 0.0, 0.0};
        int channel = src.getNumBands();
        scale = 1.0 / scale;
        int contributionsNum = (int)(2.0 * support + 3.0);
        LanczosContributionInfo[] contribution = new LanczosContributionInfo[contributionsNum];
        for (int t = 0; t < contributionsNum; ++t) {
            contribution[t] = new LanczosContributionInfo();
        }
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int srcWidth = src.getWidth();
        int dstScanlineStride = dst.getScanlineStride();
        int srcScanlineStride = src.getScanlineStride();
        for (int x = 0; x < dstWidth; ++x) {
            int n;
            double center = ((double)x + 0.5) / this.scaleX + (double)this.xTrans;
            double t1 = center - support + 0.5;
            double t2 = center + support + 0.5;
            int start = (int)(t1 > 0.0 ? t1 : 0.0);
            int stop = (int)(t2 < (double)srcWidth ? t2 : (double)srcWidth);
            double density = 0.0;
            for (n = 0; n < stop - start; ++n) {
                contribution[n].pixel = start + n;
                contribution[n].weight = this.getLanczosResizeFilterWeight(scale * ((double)(start + n) - center + 0.5));
                density += contribution[n].weight;
            }
            if (density != 0.0 && density != 1.0) {
                density = 1.0 / density;
                for (int i = 0; i < n; ++i) {
                    contribution[i].weight *= density;
                }
            }
            int tmp3 = x * channel;
            int tmp5 = ((int)((double)start - center) + (int)center) * channel + this.xTrans * channel;
            for (int y = 0; y < dstHeight; ++y) {
                pixel[0] = 0.0;
                pixel[1] = 0.0;
                pixel[2] = 0.0;
                pixel[3] = 0.0;
                int tmp6 = tmp5;
                for (int i = 0; i < n; ++i) {
                    pixel[0] = pixel[0] + (double)(srcDataArrays[0][tmp6++] & 0xFF) * contribution[i].weight;
                    pixel[1] = pixel[1] + (double)(srcDataArrays[1][tmp6++] & 0xFF) * contribution[i].weight;
                    pixel[2] = pixel[2] + (double)(srcDataArrays[2][tmp6++] & 0xFF) * contribution[i].weight;
                }
                int tmp4 = tmp3;
                dstDataArrays[0][tmp4++] = ImageUtils.clampRoundByte(pixel[0]);
                dstDataArrays[1][tmp4++] = ImageUtils.clampRoundByte(pixel[1]);
                dstDataArrays[2][tmp4] = ImageUtils.clampRoundByte(pixel[2]);
                tmp3 += dstScanlineStride;
                tmp5 += srcScanlineStride;
            }
        }
    }

    private void lanczosVerticalFilterByte(RasterAccessor src, RasterAccessor dst) {
        double scale = Math.max(1.0 / this.scaleY, 1.0);
        double support = scale * this.filter.getSupport() * this.filter.getBlur();
        if (support < 0.5) {
            support = 0.5;
            scale = 1.0;
        }
        scale = 1.0 / scale;
        byte[][] srcDataArrays = src.getByteDataArrays();
        byte[][] dstDataArrays = dst.getByteDataArrays();
        double[] pixel = new double[]{0.0, 0.0, 0.0, 0.0};
        int channel = dst.getNumBands();
        int contributionNums = (int)(2.0 * support + 3.0);
        LanczosContributionInfo[] contribution = new LanczosContributionInfo[contributionNums];
        for (int t = 0; t < contributionNums; ++t) {
            contribution[t] = new LanczosContributionInfo();
        }
        int dstHeight = dst.getHeight();
        int dstWidth = dst.getWidth();
        int srcHeight = src.getHeight();
        int srcScanlineStride = src.getScanlineStride();
        int dstScanlineStride = dst.getScanlineStride();
        for (int y = 0; y < dstHeight; ++y) {
            int n;
            double center = ((double)y + 0.5) / this.scaleY;
            double t1 = center - support + 0.5;
            double t2 = center + support + 0.5;
            int start = (int)(t1 > 0.0 ? t1 : 0.0);
            int stop = (int)(t2 < (double)srcHeight ? t2 : (double)srcHeight);
            double density = 0.0;
            for (n = 0; n < stop - start; ++n) {
                contribution[n].pixel = start + n;
                contribution[n].weight = this.getLanczosResizeFilterWeight(scale * ((double)(start + n) - center + 0.5));
                density += contribution[n].weight;
            }
            if (density != 0.0 && density != 1.0) {
                density = 1.0 / density;
                for (int i = 0; i < n; ++i) {
                    contribution[i].weight *= density;
                }
            }
            int tmp3 = y * dstScanlineStride;
            int tmp5 = (int)center * srcScanlineStride + (int)((double)start - center) * srcScanlineStride + this.yTrans * srcScanlineStride;
            for (int x = 0; x < dstWidth; ++x) {
                pixel[0] = 0.0;
                pixel[1] = 0.0;
                pixel[2] = 0.0;
                pixel[3] = 0.0;
                int tmp6 = tmp5;
                for (int i = 0; i < n; ++i) {
                    int tmp7 = tmp6;
                    pixel[0] = pixel[0] + (double)(srcDataArrays[0][tmp7++] & 0xFF) * contribution[i].weight;
                    pixel[1] = pixel[1] + (double)(srcDataArrays[1][tmp7++] & 0xFF) * contribution[i].weight;
                    pixel[2] = pixel[2] + (double)(srcDataArrays[2][tmp7] & 0xFF) * contribution[i].weight;
                    tmp6 += srcScanlineStride;
                }
                dstDataArrays[0][tmp3++] = ImageUtils.clampRoundByte(pixel[0]);
                dstDataArrays[1][tmp3++] = ImageUtils.clampRoundByte(pixel[1]);
                dstDataArrays[2][tmp3++] = ImageUtils.clampRoundByte(pixel[2]);
                tmp5 += channel;
            }
        }
    }

    private double getLanczosResizeFilterWeight(double x) {
        double blur = Math.abs(x) / this.filter.getBlur();
        double scale = this.filter.getScale() / this.filter.getWindowSupport();
        scale = this.filter.window(blur * scale);
        return scale * this.filter.filter(blur);
    }
}

