/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.simpleimage.render;

import com.alibaba.simpleimage.render.DrawTextItem;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;

public class ReleatePositionDrawTextItem
extends DrawTextItem {
    protected float textWidthPercent;
    protected float xFactor;
    protected float yFactor;

    public ReleatePositionDrawTextItem(String text, Color fontColor, Color fontShadowColor, Font font, int minFontSize, float textWidthPercent, float xFactor, float yFactor) {
        super(text, fontColor, fontShadowColor, font, minFontSize);
        this.textWidthPercent = textWidthPercent;
        this.xFactor = xFactor;
        this.yFactor = yFactor;
    }

    public void drawText(Graphics2D graphics, int width, int height) {
        int textLength = (int)((float)width * this.textWidthPercent);
        int fontsize = textLength / this.text.length();
        if (fontsize < this.minFontSize) {
            return;
        }
        graphics.setFont(new Font(this.defaultFont.getFontName(), 0, fontsize));
        graphics.setColor(this.fontColor);
        graphics.drawString(this.text, (int)((float)width * this.xFactor), (int)((float)height * this.yFactor));
    }
}

