/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.simpleimage.render;

import com.alibaba.simpleimage.ImageRender;
import com.alibaba.simpleimage.ImageWrapper;
import com.alibaba.simpleimage.SimpleImageException;
import com.alibaba.simpleimage.render.WatermarkParameter;
import com.alibaba.simpleimage.util.ImageDrawHelper;
import java.awt.image.BufferedImage;

public class WatermarkRender
extends ImageRender {
    private WatermarkParameter param;
    private ImageWrapper imageWrapper;

    public WatermarkRender(ImageRender imageRender, WatermarkParameter param) {
        super(imageRender);
        this.param = param;
    }

    public WatermarkRender(ImageWrapper srcImage, WatermarkParameter param) {
        super(null);
        this.imageWrapper = srcImage;
        this.param = param;
    }

    public ImageWrapper render() throws SimpleImageException {
        if (this.imageWrapper == null) {
            this.imageWrapper = this.imageRender.render();
        }
        if (this.param == null) {
            return this.imageWrapper;
        }
        for (int i = 0; i < this.imageWrapper.getNumOfImages(); ++i) {
            BufferedImage img = ImageDrawHelper.drawWatermark(this.imageWrapper.getAsBufferedImage(i), this.param);
            this.imageWrapper.setImage(i, img);
        }
        return this.imageWrapper;
    }

    public void dispose() throws SimpleImageException {
        super.dispose();
        this.param = null;
    }

    public WatermarkParameter getParam() {
        return this.param;
    }

    public void setParam(WatermarkParameter param) {
        this.param = param;
    }
}

